'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var ExecutionList = require('./flow/execution').ExecutionList;
var FlowRevisionList = require('./flow/flowRevision').FlowRevisionList;
var FlowTestUserList = require('./flow/testUser').FlowTestUserList;
var Page = require('../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../base/deserialize');  /* jshint ignore:line */
var serialize = require('../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var FlowList;
var FlowPage;
var FlowInstance;
var FlowContext;

/* jshint ignore:start */
/**
 * Initialize the FlowList
 *
 * @constructor Twilio.Studio.V2.FlowList
 *
 * @param {Twilio.Studio.V2} version - Version of the resource
 */
/* jshint ignore:end */
FlowList = function FlowList(version) {
  /* jshint ignore:start */
  /**
   * @function flows
   * @memberof Twilio.Studio.V2#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Studio.V2.FlowContext}
   */
  /* jshint ignore:end */
  function FlowListInstance(sid) {
    return FlowListInstance.get(sid);
  }

  FlowListInstance._version = version;
  // Path Solution
  FlowListInstance._solution = {};
  FlowListInstance._uri = `/Flows`;
  /* jshint ignore:start */
  /**
   * create a FlowInstance
   *
   * @function create
   * @memberof Twilio.Studio.V2.FlowList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.friendlyName -
   *          The string that you assigned to describe the Flow
   * @param {flow.status} opts.status - The status of the Flow
   * @param {object} opts.definition - JSON representation of flow definition
   * @param {string} [opts.commitMessage] -
   *          Description of change made in the revision
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed FlowInstance
   */
  /* jshint ignore:end */
  FlowListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts.friendlyName)) {
      throw new Error('Required parameter "opts.friendlyName" missing.');
    }
    if (_.isUndefined(opts.status)) {
      throw new Error('Required parameter "opts.status" missing.');
    }
    if (_.isUndefined(opts.definition)) {
      throw new Error('Required parameter "opts.definition" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'FriendlyName': _.get(opts, 'friendlyName'),
      'Status': _.get(opts, 'status'),
      'Definition': serialize.object(_.get(opts, 'definition')),
      'CommitMessage': _.get(opts, 'commitMessage')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new FlowInstance(this._version, payload, this._solution.sid));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Streams FlowInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Studio.V2.FlowList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  FlowListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists FlowInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Studio.V2.FlowList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  FlowListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of FlowInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Studio.V2.FlowList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  FlowListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new FlowPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of FlowInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Studio.V2.FlowList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  FlowListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new FlowPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a flow
   *
   * @function get
   * @memberof Twilio.Studio.V2.FlowList#
   *
   * @param {string} sid - The SID that identifies the resource to fetch
   *
   * @returns {Twilio.Studio.V2.FlowContext}
   */
  /* jshint ignore:end */
  FlowListInstance.get = function get(sid) {
    return new FlowContext(this._version, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Studio.V2.FlowList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  FlowListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  FlowListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return FlowListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the FlowPage
 *
 * @constructor Twilio.Studio.V2.FlowPage
 *
 * @param {V2} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {FlowSolution} solution - Path solution
 *
 * @returns FlowPage
 */
/* jshint ignore:end */
FlowPage = function FlowPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(FlowPage.prototype, Page.prototype);
FlowPage.prototype.constructor = FlowPage;

/* jshint ignore:start */
/**
 * Build an instance of FlowInstance
 *
 * @function getInstance
 * @memberof Twilio.Studio.V2.FlowPage#
 *
 * @param {FlowPayload} payload - Payload response from the API
 *
 * @returns FlowInstance
 */
/* jshint ignore:end */
FlowPage.prototype.getInstance = function getInstance(payload) {
  return new FlowInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Studio.V2.FlowPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
FlowPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

FlowPage.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the FlowContext
 *
 * @constructor Twilio.Studio.V2.FlowInstance
 *
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} friendlyName -
 *          The string that you assigned to describe the Flow
 * @property {object} definition - JSON representation of flow definition
 * @property {flow.status} status - The status of the Flow
 * @property {number} revision -
 *          The latest revision number of the Flow's definition
 * @property {string} commitMessage - Description of change made in the revision
 * @property {boolean} valid - Boolean if the flow definition is valid
 * @property {object} errors - List of error in the flow definition
 * @property {object} warnings - List of warnings in the flow definition
 * @property {Date} dateCreated -
 *          The ISO 8601 date and time in GMT when the resource was created
 * @property {Date} dateUpdated -
 *          The ISO 8601 date and time in GMT when the resource was last updated
 * @property {string} webhookUrl - The webhook_url
 * @property {string} url - The absolute URL of the resource
 * @property {string} links - Nested resource URLs
 *
 * @param {V2} version - Version of the resource
 * @param {FlowPayload} payload - The instance payload
 * @param {sid} sid - The SID that identifies the resource to fetch
 */
/* jshint ignore:end */
FlowInstance = function FlowInstance(version, payload, sid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.friendlyName = payload.friendly_name; // jshint ignore:line
  this.definition = payload.definition; // jshint ignore:line
  this.status = payload.status; // jshint ignore:line
  this.revision = deserialize.integer(payload.revision); // jshint ignore:line
  this.commitMessage = payload.commit_message; // jshint ignore:line
  this.valid = payload.valid; // jshint ignore:line
  this.errors = payload.errors; // jshint ignore:line
  this.warnings = payload.warnings; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.webhookUrl = payload.webhook_url; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.links = payload.links; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {sid: sid || this.sid, };
};

Object.defineProperty(FlowInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new FlowContext(this._version, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * update a FlowInstance
 *
 * @function update
 * @memberof Twilio.Studio.V2.FlowInstance#
 *
 * @param {object} opts - Options for request
 * @param {flow.status} opts.status - The status of the Flow
 * @param {string} [opts.friendlyName] -
 *          The string that you assigned to describe the Flow
 * @param {object} [opts.definition] - JSON representation of flow definition
 * @param {string} [opts.commitMessage] -
 *          Description of change made in the revision
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FlowInstance
 */
/* jshint ignore:end */
FlowInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * fetch a FlowInstance
 *
 * @function fetch
 * @memberof Twilio.Studio.V2.FlowInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FlowInstance
 */
/* jshint ignore:end */
FlowInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * remove a FlowInstance
 *
 * @function remove
 * @memberof Twilio.Studio.V2.FlowInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FlowInstance
 */
/* jshint ignore:end */
FlowInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * Access the revisions
 *
 * @function revisions
 * @memberof Twilio.Studio.V2.FlowInstance#
 *
 * @returns {Twilio.Studio.V2.FlowContext.FlowRevisionList}
 */
/* jshint ignore:end */
FlowInstance.prototype.revisions = function revisions() {
  return this._proxy.revisions;
};

/* jshint ignore:start */
/**
 * Access the testUsers
 *
 * @function testUsers
 * @memberof Twilio.Studio.V2.FlowInstance#
 *
 * @returns {Twilio.Studio.V2.FlowContext.FlowTestUserList}
 */
/* jshint ignore:end */
FlowInstance.prototype.testUsers = function testUsers() {
  return this._proxy.testUsers;
};

/* jshint ignore:start */
/**
 * Access the executions
 *
 * @function executions
 * @memberof Twilio.Studio.V2.FlowInstance#
 *
 * @returns {Twilio.Studio.V2.FlowContext.ExecutionList}
 */
/* jshint ignore:end */
FlowInstance.prototype.executions = function executions() {
  return this._proxy.executions;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Studio.V2.FlowInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
FlowInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

FlowInstance.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the FlowContext
 *
 * @constructor Twilio.Studio.V2.FlowContext
 *
 * @property {Twilio.Studio.V2.FlowContext.FlowRevisionList} revisions -
 *          revisions resource
 * @property {Twilio.Studio.V2.FlowContext.FlowTestUserList} testUsers -
 *          testUsers resource
 * @property {Twilio.Studio.V2.FlowContext.ExecutionList} executions -
 *          executions resource
 *
 * @param {V2} version - Version of the resource
 * @param {sid} sid - The SID that identifies the resource to fetch
 */
/* jshint ignore:end */
FlowContext = function FlowContext(version, sid) {
  this._version = version;

  // Path Solution
  this._solution = {sid: sid, };
  this._uri = `/Flows/${sid}`;

  // Dependents
  this._revisions = undefined;
  this._testUsers = undefined;
  this._executions = undefined;
};

/* jshint ignore:start */
/**
 * update a FlowInstance
 *
 * @function update
 * @memberof Twilio.Studio.V2.FlowContext#
 *
 * @param {object} opts - Options for request
 * @param {flow.status} opts.status - The status of the Flow
 * @param {string} [opts.friendlyName] -
 *          The string that you assigned to describe the Flow
 * @param {object} [opts.definition] - JSON representation of flow definition
 * @param {string} [opts.commitMessage] -
 *          Description of change made in the revision
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FlowInstance
 */
/* jshint ignore:end */
FlowContext.prototype.update = function update(opts, callback) {
  if (_.isUndefined(opts)) {
    throw new Error('Required parameter "opts" missing.');
  }
  if (_.isUndefined(opts.status)) {
    throw new Error('Required parameter "opts.status" missing.');
  }

  var deferred = Q.defer();
  var data = values.of({
    'Status': _.get(opts, 'status'),
    'FriendlyName': _.get(opts, 'friendlyName'),
    'Definition': serialize.object(_.get(opts, 'definition')),
    'CommitMessage': _.get(opts, 'commitMessage')
  });

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new FlowInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * fetch a FlowInstance
 *
 * @function fetch
 * @memberof Twilio.Studio.V2.FlowContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FlowInstance
 */
/* jshint ignore:end */
FlowContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new FlowInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a FlowInstance
 *
 * @function remove
 * @memberof Twilio.Studio.V2.FlowContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FlowInstance
 */
/* jshint ignore:end */
FlowContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

Object.defineProperty(FlowContext.prototype,
  'revisions', {
    get: function() {
      if (!this._revisions) {
        this._revisions = new FlowRevisionList(this._version, this._solution.sid);
      }
      return this._revisions;
    }
});

Object.defineProperty(FlowContext.prototype,
  'testUsers', {
    get: function() {
      if (!this._testUsers) {
        this._testUsers = new FlowTestUserList(this._version, this._solution.sid);
      }
      return this._testUsers;
    }
});

Object.defineProperty(FlowContext.prototype,
  'executions', {
    get: function() {
      if (!this._executions) {
        this._executions = new ExecutionList(this._version, this._solution.sid);
      }
      return this._executions;
    }
});

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Studio.V2.FlowContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
FlowContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

FlowContext.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  FlowList: FlowList,
  FlowPage: FlowPage,
  FlowInstance: FlowInstance,
  FlowContext: FlowContext
};
