/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the SettingList
 *
 * @param version - Version of the resource
 */
declare function SettingList(version: V1): SettingListInstance;

/**
 * Options to pass to fetch
 *
 * @property subaccountSid - The subaccount_sid
 */
interface SettingInstanceFetchOptions {
  subaccountSid?: string;
}

/**
 * Options to pass to update
 *
 * @property advancedFeatures - The advanced_features
 * @property subaccountSid - The subaccount_sid
 * @property voiceTrace - The voice_trace
 */
interface SettingInstanceUpdateOptions {
  advancedFeatures?: boolean;
  subaccountSid?: string;
  voiceTrace?: boolean;
}

interface SettingListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): SettingContext;
  /**
   * Constructs a setting
   */
  get(): SettingContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface SettingPayload extends SettingResource, Page.TwilioResponsePayload {
}

interface SettingResource {
  account_sid: string;
  advanced_features: boolean;
  url: string;
  voice_trace: boolean;
}

interface SettingSolution {
}


declare class SettingContext {
  /**
   * Initialize the SettingContext
   *
   * @param version - Version of the resource
   */
  constructor(version: V1);

  /**
   * fetch a SettingInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: SettingInstance) => any): Promise<SettingInstance>;
  /**
   * fetch a SettingInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: SettingInstanceFetchOptions, callback?: (error: Error | null, items: SettingInstance) => any): Promise<SettingInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a SettingInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: SettingInstance) => any): Promise<SettingInstance>;
  /**
   * update a SettingInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: SettingInstanceUpdateOptions, callback?: (error: Error | null, items: SettingInstance) => any): Promise<SettingInstance>;
}


declare class SettingInstance extends SerializableClass {
  /**
   * Initialize the SettingContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: V1, payload: SettingPayload);

  private _proxy: SettingContext;
  accountSid: string;
  advancedFeatures: boolean;
  /**
   * fetch a SettingInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: SettingInstance) => any): Promise<SettingInstance>;
  /**
   * fetch a SettingInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: SettingInstanceFetchOptions, callback?: (error: Error | null, items: SettingInstance) => any): Promise<SettingInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a SettingInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: SettingInstance) => any): Promise<SettingInstance>;
  /**
   * update a SettingInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: SettingInstanceUpdateOptions, callback?: (error: Error | null, items: SettingInstance) => any): Promise<SettingInstance>;
  url: string;
  voiceTrace: boolean;
}


declare class SettingPage extends Page<V1, SettingPayload, SettingResource, SettingInstance> {
  /**
   * Initialize the SettingPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: SettingSolution);

  /**
   * Build an instance of SettingInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: SettingPayload): SettingInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { SettingContext, SettingInstance, SettingInstanceFetchOptions, SettingInstanceUpdateOptions, SettingList, SettingListInstance, SettingPage, SettingPayload, SettingResource, SettingSolution }
