/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { PlaybackGrantList } from './playerStreamer/playbackGrant';
import { PlaybackGrantListInstance } from './playerStreamer/playbackGrant';
import { SerializableClass } from '../../../interfaces';

type PlayerStreamerEndedReason = 'ended-via-api'|'max-duration-exceeded'|'stream-disconnected-by-source'|'unexpected-failure';

type PlayerStreamerOrder = 'asc'|'desc';

type PlayerStreamerStatus = 'created'|'started'|'ended'|'failed';

type PlayerStreamerUpdateStatus = 'ended';

/**
 * Initialize the PlayerStreamerList
 *
 * @param version - Version of the resource
 */
declare function PlayerStreamerList(version: V1): PlayerStreamerListInstance;

/**
 * Options to pass to update
 *
 * @property status - The status the PlayerStreamer should be transitioned to
 */
interface PlayerStreamerInstanceUpdateOptions {
  status: PlayerStreamerUpdateStatus;
}

interface PlayerStreamerListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): PlayerStreamerContext;
  /**
   * create a PlayerStreamerInstance
   *
   * @param callback - Callback to handle processed record
   */
  create(callback?: (error: Error | null, item: PlayerStreamerInstance) => any): Promise<PlayerStreamerInstance>;
  /**
   * create a PlayerStreamerInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts?: PlayerStreamerListInstanceCreateOptions, callback?: (error: Error | null, item: PlayerStreamerInstance) => any): Promise<PlayerStreamerInstance>;
  /**
   * Streams PlayerStreamerInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: PlayerStreamerInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams PlayerStreamerInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: PlayerStreamerListInstanceEachOptions, callback?: (item: PlayerStreamerInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a player_streamer
   *
   * @param sid - The SID that identifies the resource to fetch
   */
  get(sid: string): PlayerStreamerContext;
  /**
   * Retrieve a single target page of PlayerStreamerInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: PlayerStreamerPage) => any): Promise<PlayerStreamerPage>;
  /**
   * Retrieve a single target page of PlayerStreamerInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: PlayerStreamerPage) => any): Promise<PlayerStreamerPage>;
  /**
   * Lists PlayerStreamerInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: PlayerStreamerInstance[]) => any): Promise<PlayerStreamerInstance[]>;
  /**
   * Lists PlayerStreamerInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: PlayerStreamerListInstanceOptions, callback?: (error: Error | null, items: PlayerStreamerInstance[]) => any): Promise<PlayerStreamerInstance[]>;
  /**
   * Retrieve a single page of PlayerStreamerInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: PlayerStreamerPage) => any): Promise<PlayerStreamerPage>;
  /**
   * Retrieve a single page of PlayerStreamerInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: PlayerStreamerListInstancePageOptions, callback?: (error: Error | null, items: PlayerStreamerPage) => any): Promise<PlayerStreamerPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property statusCallback - The URL to which Twilio will send PlayerStreamer event updates
 * @property statusCallbackMethod - The HTTP method Twilio should use to call the `status_callback` URL
 * @property video - Whether the PlayerStreamer is configured to stream video
 */
interface PlayerStreamerListInstanceCreateOptions {
  statusCallback?: string;
  statusCallbackMethod?: string;
  video?: boolean;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property order - The sort order of the list
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 * @property status - Status to filter by
 */
interface PlayerStreamerListInstanceEachOptions {
  callback?: (item: PlayerStreamerInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  order?: PlayerStreamerOrder;
  pageSize?: number;
  status?: PlayerStreamerStatus;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property order - The sort order of the list
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 * @property status - Status to filter by
 */
interface PlayerStreamerListInstanceOptions {
  limit?: number;
  order?: PlayerStreamerOrder;
  pageSize?: number;
  status?: PlayerStreamerStatus;
}

/**
 * Options to pass to page
 *
 * @property order - The sort order of the list
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 * @property status - Status to filter by
 */
interface PlayerStreamerListInstancePageOptions {
  order?: PlayerStreamerOrder;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
  status?: PlayerStreamerStatus;
}

interface PlayerStreamerPayload extends PlayerStreamerResource, Page.TwilioResponsePayload {
}

interface PlayerStreamerResource {
  account_sid: string;
  date_created: Date;
  date_updated: Date;
  ended_reason: PlayerStreamerEndedReason;
  links: string;
  sid: string;
  status: PlayerStreamerStatus;
  status_callback: string;
  status_callback_method: string;
  url: string;
  video: boolean;
}

interface PlayerStreamerSolution {
}


declare class PlayerStreamerContext {
  /**
   * Initialize the PlayerStreamerContext
   *
   * @param version - Version of the resource
   * @param sid - The SID that identifies the resource to fetch
   */
  constructor(version: V1, sid: string);

  /**
   * fetch a PlayerStreamerInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: PlayerStreamerInstance) => any): Promise<PlayerStreamerInstance>;
  playbackGrant: PlaybackGrantListInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a PlayerStreamerInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts: PlayerStreamerInstanceUpdateOptions, callback?: (error: Error | null, items: PlayerStreamerInstance) => any): Promise<PlayerStreamerInstance>;
}


declare class PlayerStreamerInstance extends SerializableClass {
  /**
   * Initialize the PlayerStreamerContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The SID that identifies the resource to fetch
   */
  constructor(version: V1, payload: PlayerStreamerPayload, sid: string);

  private _proxy: PlayerStreamerContext;
  accountSid: string;
  dateCreated: Date;
  dateUpdated: Date;
  endedReason: PlayerStreamerEndedReason;
  /**
   * fetch a PlayerStreamerInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: PlayerStreamerInstance) => any): Promise<PlayerStreamerInstance>;
  links: string;
  /**
   * Access the playbackGrant
   */
  playbackGrant(): PlaybackGrantListInstance;
  sid: string;
  status: PlayerStreamerStatus;
  statusCallback: string;
  statusCallbackMethod: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a PlayerStreamerInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts: PlayerStreamerInstanceUpdateOptions, callback?: (error: Error | null, items: PlayerStreamerInstance) => any): Promise<PlayerStreamerInstance>;
  url: string;
  video: boolean;
}


declare class PlayerStreamerPage extends Page<V1, PlayerStreamerPayload, PlayerStreamerResource, PlayerStreamerInstance> {
  /**
   * Initialize the PlayerStreamerPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: PlayerStreamerSolution);

  /**
   * Build an instance of PlayerStreamerInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: PlayerStreamerPayload): PlayerStreamerInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { PlayerStreamerContext, PlayerStreamerEndedReason, PlayerStreamerInstance, PlayerStreamerInstanceUpdateOptions, PlayerStreamerList, PlayerStreamerListInstance, PlayerStreamerListInstanceCreateOptions, PlayerStreamerListInstanceEachOptions, PlayerStreamerListInstanceOptions, PlayerStreamerListInstancePageOptions, PlayerStreamerOrder, PlayerStreamerPage, PlayerStreamerPayload, PlayerStreamerResource, PlayerStreamerSolution, PlayerStreamerStatus, PlayerStreamerUpdateStatus }
