'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../base/deserialize');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var PlaybackGrantList;
var PlaybackGrantPage;
var PlaybackGrantInstance;
var PlaybackGrantContext;

/* jshint ignore:start */
/**
 * Initialize the PlaybackGrantList
 *
 * @constructor Twilio.Media.V1.PlayerStreamerContext.PlaybackGrantList
 *
 * @param {Twilio.Media.V1} version - Version of the resource
 * @param {string} sid -
 *          The unique string that identifies the PlayerStreamer associated with this PlaybackGrant.
 */
/* jshint ignore:end */
PlaybackGrantList = function PlaybackGrantList(version, sid) {
  /* jshint ignore:start */
  /**
   * @function playbackGrant
   * @memberof Twilio.Media.V1.PlayerStreamerContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Media.V1.PlayerStreamerContext.PlaybackGrantContext}
   */
  /* jshint ignore:end */
  function PlaybackGrantListInstance(sid) {
    return PlaybackGrantListInstance.get(sid);
  }

  PlaybackGrantListInstance._version = version;
  // Path Solution
  PlaybackGrantListInstance._solution = {sid: sid};
  /* jshint ignore:start */
  /**
   * Constructs a playback_grant
   *
   * @function get
   * @memberof Twilio.Media.V1.PlayerStreamerContext.PlaybackGrantList#
   *
   * @returns {Twilio.Media.V1.PlayerStreamerContext.PlaybackGrantContext}
   */
  /* jshint ignore:end */
  PlaybackGrantListInstance.get = function get() {
    return new PlaybackGrantContext(this._version, this._solution.sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Media.V1.PlayerStreamerContext.PlaybackGrantList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  PlaybackGrantListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  PlaybackGrantListInstance[util.inspect.custom] = function inspect(depth,
      options) {
    return util.inspect(this.toJSON(), options);
  };

  return PlaybackGrantListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the PlaybackGrantPage
 *
 * @constructor Twilio.Media.V1.PlayerStreamerContext.PlaybackGrantPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {PlaybackGrantSolution} solution - Path solution
 *
 * @returns PlaybackGrantPage
 */
/* jshint ignore:end */
PlaybackGrantPage = function PlaybackGrantPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(PlaybackGrantPage.prototype, Page.prototype);
PlaybackGrantPage.prototype.constructor = PlaybackGrantPage;

/* jshint ignore:start */
/**
 * Build an instance of PlaybackGrantInstance
 *
 * @function getInstance
 * @memberof Twilio.Media.V1.PlayerStreamerContext.PlaybackGrantPage#
 *
 * @param {PlaybackGrantPayload} payload - Payload response from the API
 *
 * @returns PlaybackGrantInstance
 */
/* jshint ignore:end */
PlaybackGrantPage.prototype.getInstance = function getInstance(payload) {
  return new PlaybackGrantInstance(this._version, payload, this._solution.sid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Media.V1.PlayerStreamerContext.PlaybackGrantPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
PlaybackGrantPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

PlaybackGrantPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the PlaybackGrantContext
 *
 * @constructor Twilio.Media.V1.PlayerStreamerContext.PlaybackGrantInstance
 *
 * @property {string} sid -
 *          The unique string that identifies the PlayerStreamer associated with this PlaybackGrant.
 * @property {string} url - The absolute URL of the resource
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {Date} dateCreated -
 *          The ISO 8601 date and time in GMT when the resource was created
 * @property {object} grant -
 *          The grant that authorizes the player sdk to connect to the livestream
 *
 * @param {V1} version - Version of the resource
 * @param {PlaybackGrantPayload} payload - The instance payload
 * @param {sid} sid -
 *          The unique string that identifies the PlayerStreamer associated with this PlaybackGrant.
 */
/* jshint ignore:end */
PlaybackGrantInstance = function PlaybackGrantInstance(version, payload, sid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.grant = payload.grant; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {sid: sid, };
};

Object.defineProperty(PlaybackGrantInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new PlaybackGrantContext(this._version, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * create a PlaybackGrantInstance
 *
 * @function create
 * @memberof Twilio.Media.V1.PlayerStreamerContext.PlaybackGrantInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {number} [opts.ttl] - The time to live of the PlaybackGrant
 * @param {string} [opts.accessControlAllowOrigin] -
 *          The full URL that is authorized to play back the livestream
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed PlaybackGrantInstance
 */
/* jshint ignore:end */
PlaybackGrantInstance.prototype.create = function create(opts, callback) {
  return this._proxy.create(opts, callback);
};

/* jshint ignore:start */
/**
 * fetch a PlaybackGrantInstance
 *
 * @function fetch
 * @memberof Twilio.Media.V1.PlayerStreamerContext.PlaybackGrantInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed PlaybackGrantInstance
 */
/* jshint ignore:end */
PlaybackGrantInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Media.V1.PlayerStreamerContext.PlaybackGrantInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
PlaybackGrantInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

PlaybackGrantInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the PlaybackGrantContext
 *
 * @constructor Twilio.Media.V1.PlayerStreamerContext.PlaybackGrantContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid} sid - The SID that identifies the resource to fetch
 */
/* jshint ignore:end */
PlaybackGrantContext = function PlaybackGrantContext(version, sid) {
  this._version = version;

  // Path Solution
  this._solution = {sid: sid, };
  this._uri = `/PlayerStreamers/${sid}/PlaybackGrant`;
};

/* jshint ignore:start */
/**
 * create a PlaybackGrantInstance
 *
 * @function create
 * @memberof Twilio.Media.V1.PlayerStreamerContext.PlaybackGrantContext#
 *
 * @param {object} [opts] - Options for request
 * @param {number} [opts.ttl] - The time to live of the PlaybackGrant
 * @param {string} [opts.accessControlAllowOrigin] -
 *          The full URL that is authorized to play back the livestream
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed PlaybackGrantInstance
 */
/* jshint ignore:end */
PlaybackGrantContext.prototype.create = function create(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'Ttl': _.get(opts, 'ttl'),
    'AccessControlAllowOrigin': _.get(opts, 'accessControlAllowOrigin')
  });

  var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new PlaybackGrantInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * fetch a PlaybackGrantInstance
 *
 * @function fetch
 * @memberof Twilio.Media.V1.PlayerStreamerContext.PlaybackGrantContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed PlaybackGrantInstance
 */
/* jshint ignore:end */
PlaybackGrantContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new PlaybackGrantInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Media.V1.PlayerStreamerContext.PlaybackGrantContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
PlaybackGrantContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

PlaybackGrantContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  PlaybackGrantList: PlaybackGrantList,
  PlaybackGrantPage: PlaybackGrantPage,
  PlaybackGrantInstance: PlaybackGrantInstance,
  PlaybackGrantContext: PlaybackGrantContext
};
