/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V2 = require('../../V2');
import { BundleCopyList } from './bundle/bundleCopy';
import { BundleCopyListInstance } from './bundle/bundleCopy';
import { EvaluationList } from './bundle/evaluation';
import { EvaluationListInstance } from './bundle/evaluation';
import { ItemAssignmentList } from './bundle/itemAssignment';
import { ItemAssignmentListInstance } from './bundle/itemAssignment';
import { ReplaceItemsList } from './bundle/replaceItems';
import { ReplaceItemsListInstance } from './bundle/replaceItems';
import { SerializableClass } from '../../../../interfaces';

type BundleEndUserType = 'individual'|'business';

type BundleStatus = 'draft'|'pending-review'|'in-review'|'twilio-rejected'|'twilio-approved'|'provisionally-approved';

/**
 * Initialize the BundleList
 *
 * @param version - Version of the resource
 */
declare function BundleList(version: V2): BundleListInstance;

/**
 * Options to pass to update
 *
 * @property email - The email address
 * @property friendlyName - The string that you assigned to describe the resource
 * @property status - The verification status of the Bundle resource
 * @property statusCallback - The URL we call to inform your application of status changes.
 */
interface BundleInstanceUpdateOptions {
  email?: string;
  friendlyName?: string;
  status?: BundleStatus;
  statusCallback?: string;
}

interface BundleListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): BundleContext;
  /**
   * create a BundleInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: BundleListInstanceCreateOptions, callback?: (error: Error | null, item: BundleInstance) => any): Promise<BundleInstance>;
  /**
   * Streams BundleInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: BundleInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams BundleInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: BundleListInstanceEachOptions, callback?: (item: BundleInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a bundle
   *
   * @param sid - The unique string that identifies the resource.
   */
  get(sid: string): BundleContext;
  /**
   * Retrieve a single target page of BundleInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: BundlePage) => any): Promise<BundlePage>;
  /**
   * Retrieve a single target page of BundleInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: BundlePage) => any): Promise<BundlePage>;
  /**
   * Lists BundleInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: BundleInstance[]) => any): Promise<BundleInstance[]>;
  /**
   * Lists BundleInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: BundleListInstanceOptions, callback?: (error: Error | null, items: BundleInstance[]) => any): Promise<BundleInstance[]>;
  /**
   * Retrieve a single page of BundleInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: BundlePage) => any): Promise<BundlePage>;
  /**
   * Retrieve a single page of BundleInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: BundleListInstancePageOptions, callback?: (error: Error | null, items: BundlePage) => any): Promise<BundlePage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property email - The email address
 * @property endUserType - The type of End User of the Bundle resource
 * @property friendlyName - The string that you assigned to describe the resource
 * @property isoCountry - The ISO country code of the country
 * @property numberType - The type of phone number
 * @property regulationSid - The unique string of a regulation.
 * @property statusCallback - The URL we call to inform your application of status changes.
 */
interface BundleListInstanceCreateOptions {
  email: string;
  endUserType?: BundleEndUserType;
  friendlyName: string;
  isoCountry?: string;
  numberType?: string;
  regulationSid?: string;
  statusCallback?: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property friendlyName - The string that you assigned to describe the resource
 * @property isoCountry - The ISO country code of the country
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property numberType - The type of phone number
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 * @property regulationSid - The unique string of a regulation.
 * @property status - The verification status of the Bundle resource
 */
interface BundleListInstanceEachOptions {
  callback?: (item: BundleInstance, done: (err?: Error) => void) => void;
  done?: Function;
  friendlyName?: string;
  isoCountry?: string;
  limit?: number;
  numberType?: string;
  pageSize?: number;
  regulationSid?: string;
  status?: BundleStatus;
}

/**
 * Options to pass to list
 *
 * @property friendlyName - The string that you assigned to describe the resource
 * @property isoCountry - The ISO country code of the country
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property numberType - The type of phone number
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 * @property regulationSid - The unique string of a regulation.
 * @property status - The verification status of the Bundle resource
 */
interface BundleListInstanceOptions {
  friendlyName?: string;
  isoCountry?: string;
  limit?: number;
  numberType?: string;
  pageSize?: number;
  regulationSid?: string;
  status?: BundleStatus;
}

/**
 * Options to pass to page
 *
 * @property friendlyName - The string that you assigned to describe the resource
 * @property isoCountry - The ISO country code of the country
 * @property numberType - The type of phone number
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 * @property regulationSid - The unique string of a regulation.
 * @property status - The verification status of the Bundle resource
 */
interface BundleListInstancePageOptions {
  friendlyName?: string;
  isoCountry?: string;
  numberType?: string;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
  regulationSid?: string;
  status?: BundleStatus;
}

interface BundlePayload extends BundleResource, Page.TwilioResponsePayload {
}

interface BundleResource {
  account_sid: string;
  date_created: Date;
  date_updated: Date;
  email: string;
  friendly_name: string;
  links: string;
  regulation_sid: string;
  sid: string;
  status: BundleStatus;
  status_callback: string;
  url: string;
  valid_until: Date;
}

interface BundleSolution {
}


declare class BundleContext {
  /**
   * Initialize the BundleContext
   *
   * @param version - Version of the resource
   * @param sid - The unique string that identifies the resource.
   */
  constructor(version: V2, sid: string);

  bundleCopies: BundleCopyListInstance;
  evaluations: EvaluationListInstance;
  /**
   * fetch a BundleInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: BundleInstance) => any): Promise<BundleInstance>;
  itemAssignments: ItemAssignmentListInstance;
  /**
   * remove a BundleInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: BundleInstance) => any): Promise<boolean>;
  replaceItems: ReplaceItemsListInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a BundleInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: BundleInstance) => any): Promise<BundleInstance>;
  /**
   * update a BundleInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: BundleInstanceUpdateOptions, callback?: (error: Error | null, items: BundleInstance) => any): Promise<BundleInstance>;
}


declare class BundleInstance extends SerializableClass {
  /**
   * Initialize the BundleContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The unique string that identifies the resource.
   */
  constructor(version: V2, payload: BundlePayload, sid: string);

  private _proxy: BundleContext;
  accountSid: string;
  /**
   * Access the bundleCopies
   */
  bundleCopies(): BundleCopyListInstance;
  dateCreated: Date;
  dateUpdated: Date;
  email: string;
  /**
   * Access the evaluations
   */
  evaluations(): EvaluationListInstance;
  /**
   * fetch a BundleInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: BundleInstance) => any): Promise<BundleInstance>;
  friendlyName: string;
  /**
   * Access the itemAssignments
   */
  itemAssignments(): ItemAssignmentListInstance;
  links: string;
  regulationSid: string;
  /**
   * remove a BundleInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: BundleInstance) => any): Promise<boolean>;
  /**
   * Access the replaceItems
   */
  replaceItems(): ReplaceItemsListInstance;
  sid: string;
  status: BundleStatus;
  statusCallback: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a BundleInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: BundleInstance) => any): Promise<BundleInstance>;
  /**
   * update a BundleInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: BundleInstanceUpdateOptions, callback?: (error: Error | null, items: BundleInstance) => any): Promise<BundleInstance>;
  url: string;
  validUntil: Date;
}


declare class BundlePage extends Page<V2, BundlePayload, BundleResource, BundleInstance> {
  /**
   * Initialize the BundlePage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2, response: Response<string>, solution: BundleSolution);

  /**
   * Build an instance of BundleInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: BundlePayload): BundleInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { BundleContext, BundleEndUserType, BundleInstance, BundleInstanceUpdateOptions, BundleList, BundleListInstance, BundleListInstanceCreateOptions, BundleListInstanceEachOptions, BundleListInstanceOptions, BundleListInstancePageOptions, BundlePage, BundlePayload, BundleResource, BundleSolution, BundleStatus }
