/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V2010 = require('../../V2010');
import { ParticipantList } from './conference/participant';
import { ParticipantListInstance } from './conference/participant';
import { RecordingList } from './conference/recording';
import { RecordingListInstance } from './conference/recording';
import { SerializableClass } from '../../../../interfaces';

type ConferenceReasonConferenceEnded = 'conference-ended-via-api'|'participant-with-end-conference-on-exit-left'|'participant-with-end-conference-on-exit-kicked'|'last-participant-kicked'|'last-participant-left';

type ConferenceStatus = 'init'|'in-progress'|'completed';

type ConferenceUpdateStatus = 'completed';

/**
 * Initialize the ConferenceList
 *
 * @param version - Version of the resource
 * @param accountSid - The SID of the Account that created this resource
 */
declare function ConferenceList(version: V2010, accountSid: string): ConferenceListInstance;

/**
 * Options to pass to update
 *
 * @property announceMethod - he HTTP method used to call announce_url
 * @property announceUrl - The URL we should call to announce something into the conference
 * @property status - The new status of the resource
 */
interface ConferenceInstanceUpdateOptions {
  announceMethod?: string;
  announceUrl?: string;
  status?: ConferenceUpdateStatus;
}

interface ConferenceListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): ConferenceContext;
  /**
   * Streams ConferenceInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: ConferenceInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams ConferenceInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: ConferenceListInstanceEachOptions, callback?: (item: ConferenceInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a conference
   *
   * @param sid - The unique string that identifies this resource
   */
  get(sid: string): ConferenceContext;
  /**
   * Retrieve a single target page of ConferenceInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: ConferencePage) => any): Promise<ConferencePage>;
  /**
   * Retrieve a single target page of ConferenceInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: ConferencePage) => any): Promise<ConferencePage>;
  /**
   * Lists ConferenceInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: ConferenceInstance[]) => any): Promise<ConferenceInstance[]>;
  /**
   * Lists ConferenceInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: ConferenceListInstanceOptions, callback?: (error: Error | null, items: ConferenceInstance[]) => any): Promise<ConferenceInstance[]>;
  /**
   * Retrieve a single page of ConferenceInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: ConferencePage) => any): Promise<ConferencePage>;
  /**
   * Retrieve a single page of ConferenceInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: ConferenceListInstancePageOptions, callback?: (error: Error | null, items: ConferencePage) => any): Promise<ConferencePage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property dateCreated - The `YYYY-MM-DD` value of the resources to read
 * @property dateCreatedAfter - The `YYYY-MM-DD` value of the resources to read
 * @property dateCreatedBefore - The `YYYY-MM-DD` value of the resources to read
 * @property dateUpdated - The `YYYY-MM-DD` value of the resources to read
 * @property dateUpdatedAfter - The `YYYY-MM-DD` value of the resources to read
 * @property dateUpdatedBefore - The `YYYY-MM-DD` value of the resources to read
 * @property done - Function to be called upon completion of streaming
 * @property friendlyName - The string that identifies the Conference resources to read
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 * @property status - The status of the resources to read
 */
interface ConferenceListInstanceEachOptions {
  callback?: (item: ConferenceInstance, done: (err?: Error) => void) => void;
  dateCreated?: Date;
  dateCreatedAfter?: Date;
  dateCreatedBefore?: Date;
  dateUpdated?: Date;
  dateUpdatedAfter?: Date;
  dateUpdatedBefore?: Date;
  done?: Function;
  friendlyName?: string;
  limit?: number;
  pageSize?: number;
  status?: ConferenceStatus;
}

/**
 * Options to pass to list
 *
 * @property dateCreated - The `YYYY-MM-DD` value of the resources to read
 * @property dateCreatedAfter - The `YYYY-MM-DD` value of the resources to read
 * @property dateCreatedBefore - The `YYYY-MM-DD` value of the resources to read
 * @property dateUpdated - The `YYYY-MM-DD` value of the resources to read
 * @property dateUpdatedAfter - The `YYYY-MM-DD` value of the resources to read
 * @property dateUpdatedBefore - The `YYYY-MM-DD` value of the resources to read
 * @property friendlyName - The string that identifies the Conference resources to read
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 * @property status - The status of the resources to read
 */
interface ConferenceListInstanceOptions {
  dateCreated?: Date;
  dateCreatedAfter?: Date;
  dateCreatedBefore?: Date;
  dateUpdated?: Date;
  dateUpdatedAfter?: Date;
  dateUpdatedBefore?: Date;
  friendlyName?: string;
  limit?: number;
  pageSize?: number;
  status?: ConferenceStatus;
}

/**
 * Options to pass to page
 *
 * @property dateCreated - The `YYYY-MM-DD` value of the resources to read
 * @property dateCreatedAfter - The `YYYY-MM-DD` value of the resources to read
 * @property dateCreatedBefore - The `YYYY-MM-DD` value of the resources to read
 * @property dateUpdated - The `YYYY-MM-DD` value of the resources to read
 * @property dateUpdatedAfter - The `YYYY-MM-DD` value of the resources to read
 * @property dateUpdatedBefore - The `YYYY-MM-DD` value of the resources to read
 * @property friendlyName - The string that identifies the Conference resources to read
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 * @property status - The status of the resources to read
 */
interface ConferenceListInstancePageOptions {
  dateCreated?: Date;
  dateCreatedAfter?: Date;
  dateCreatedBefore?: Date;
  dateUpdated?: Date;
  dateUpdatedAfter?: Date;
  dateUpdatedBefore?: Date;
  friendlyName?: string;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
  status?: ConferenceStatus;
}

interface ConferencePayload extends ConferenceResource, Page.TwilioResponsePayload {
}

interface ConferenceResource {
  account_sid: string;
  api_version: string;
  call_sid_ending_conference: string;
  date_created: Date;
  date_updated: Date;
  friendly_name: string;
  reason_conference_ended: ConferenceReasonConferenceEnded;
  region: string;
  sid: string;
  status: ConferenceStatus;
  subresource_uris: string;
  uri: string;
}

interface ConferenceSolution {
  accountSid?: string;
}


declare class ConferenceContext {
  /**
   * Initialize the ConferenceContext
   *
   * @param version - Version of the resource
   * @param accountSid - The SID of the Account that created the resource(s) to fetch
   * @param sid - The unique string that identifies this resource
   */
  constructor(version: V2010, accountSid: string, sid: string);

  /**
   * fetch a ConferenceInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ConferenceInstance) => any): Promise<ConferenceInstance>;
  participants: ParticipantListInstance;
  recordings: RecordingListInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a ConferenceInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: ConferenceInstance) => any): Promise<ConferenceInstance>;
  /**
   * update a ConferenceInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: ConferenceInstanceUpdateOptions, callback?: (error: Error | null, items: ConferenceInstance) => any): Promise<ConferenceInstance>;
}


declare class ConferenceInstance extends SerializableClass {
  /**
   * Initialize the ConferenceContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param accountSid - The SID of the Account that created this resource
   * @param sid - The unique string that identifies this resource
   */
  constructor(version: V2010, payload: ConferencePayload, accountSid: string, sid: string);

  private _proxy: ConferenceContext;
  accountSid: string;
  apiVersion: string;
  callSidEndingConference: string;
  dateCreated: Date;
  dateUpdated: Date;
  /**
   * fetch a ConferenceInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ConferenceInstance) => any): Promise<ConferenceInstance>;
  friendlyName: string;
  /**
   * Access the participants
   */
  participants(): ParticipantListInstance;
  reasonConferenceEnded: ConferenceReasonConferenceEnded;
  /**
   * Access the recordings
   */
  recordings(): RecordingListInstance;
  region: string;
  sid: string;
  status: ConferenceStatus;
  subresourceUris: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a ConferenceInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: ConferenceInstance) => any): Promise<ConferenceInstance>;
  /**
   * update a ConferenceInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: ConferenceInstanceUpdateOptions, callback?: (error: Error | null, items: ConferenceInstance) => any): Promise<ConferenceInstance>;
  uri: string;
}


declare class ConferencePage extends Page<V2010, ConferencePayload, ConferenceResource, ConferenceInstance> {
  /**
   * Initialize the ConferencePage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2010, response: Response<string>, solution: ConferenceSolution);

  /**
   * Build an instance of ConferenceInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: ConferencePayload): ConferenceInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { ConferenceContext, ConferenceInstance, ConferenceInstanceUpdateOptions, ConferenceList, ConferenceListInstance, ConferenceListInstanceEachOptions, ConferenceListInstanceOptions, ConferenceListInstancePageOptions, ConferencePage, ConferencePayload, ConferenceReasonConferenceEnded, ConferenceResource, ConferenceSolution, ConferenceStatus, ConferenceUpdateStatus }
