/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { SerializableClass } from '../../../../interfaces';

type ExportCustomJobStatus = 'ErrorDuringRun'|'Submitted'|'Running'|'CompletedEmptyRecords'|'Completed'|'Failed'|'RunningToBeDeleted'|'DeletedByUserRequest';

/**
 * Initialize the ExportCustomJobList
 *
 * @param version - Version of the resource
 * @param resourceType - The type of communication – Messages, Calls, Conferences, and Participants
 */
declare function ExportCustomJobList(version: V1, resourceType: string): ExportCustomJobListInstance;

interface ExportCustomJobListInstance {
  /**
   * create a ExportCustomJobInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: ExportCustomJobListInstanceCreateOptions, callback?: (error: Error | null, item: ExportCustomJobInstance) => any): Promise<ExportCustomJobInstance>;
  /**
   * Streams ExportCustomJobInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: ExportCustomJobInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams ExportCustomJobInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: ExportCustomJobListInstanceEachOptions, callback?: (item: ExportCustomJobInstance, done: (err?: Error) => void) => void): void;
  /**
   * Retrieve a single target page of ExportCustomJobInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: ExportCustomJobPage) => any): Promise<ExportCustomJobPage>;
  /**
   * Retrieve a single target page of ExportCustomJobInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: ExportCustomJobPage) => any): Promise<ExportCustomJobPage>;
  /**
   * Lists ExportCustomJobInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: ExportCustomJobInstance[]) => any): Promise<ExportCustomJobInstance[]>;
  /**
   * Lists ExportCustomJobInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: ExportCustomJobListInstanceOptions, callback?: (error: Error | null, items: ExportCustomJobInstance[]) => any): Promise<ExportCustomJobInstance[]>;
  /**
   * Retrieve a single page of ExportCustomJobInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: ExportCustomJobPage) => any): Promise<ExportCustomJobPage>;
  /**
   * Retrieve a single page of ExportCustomJobInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: ExportCustomJobListInstancePageOptions, callback?: (error: Error | null, items: ExportCustomJobPage) => any): Promise<ExportCustomJobPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property email - The optional email to send the completion notification to
 * @property endDay - The end day for the custom export specified as a string in the format of yyyy-mm-dd. End day is inclusive and must be 2 days earlier than the current UTC day.
 * @property friendlyName - The friendly name specified when creating the job
 * @property startDay - The start day for the custom export specified as a string in the format of yyyy-mm-dd
 * @property webhookMethod - This is the method used to call the webhook on completion of the job. If this is supplied, `WebhookUrl` must also be supplied.
 * @property webhookUrl - The optional webhook url called on completion of the job. If this is supplied, `WebhookMethod` must also be supplied.
 */
interface ExportCustomJobListInstanceCreateOptions {
  email?: string;
  endDay: string;
  friendlyName: string;
  startDay: string;
  webhookMethod?: string;
  webhookUrl?: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface ExportCustomJobListInstanceEachOptions {
  callback?: (item: ExportCustomJobInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface ExportCustomJobListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface ExportCustomJobListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface ExportCustomJobPayload extends ExportCustomJobResource, Page.TwilioResponsePayload {
}

interface ExportCustomJobResource {
  details: object;
  email: string;
  end_day: string;
  estimated_completion_time: string;
  friendly_name: string;
  job_queue_position: string;
  job_sid: string;
  resource_type: string;
  start_day: string;
  webhook_method: string;
  webhook_url: string;
}

interface ExportCustomJobSolution {
  resourceType?: string;
}


declare class ExportCustomJobInstance extends SerializableClass {
  /**
   * Initialize the ExportCustomJobContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param resourceType - The type of communication – Messages, Calls, Conferences, and Participants
   */
  constructor(version: V1, payload: ExportCustomJobPayload, resourceType: string);

  details: any;
  email: string;
  endDay: string;
  estimatedCompletionTime: string;
  friendlyName: string;
  jobQueuePosition: string;
  jobSid: string;
  resourceType: string;
  startDay: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  webhookMethod: string;
  webhookUrl: string;
}


declare class ExportCustomJobPage extends Page<V1, ExportCustomJobPayload, ExportCustomJobResource, ExportCustomJobInstance> {
  /**
   * Initialize the ExportCustomJobPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: ExportCustomJobSolution);

  /**
   * Build an instance of ExportCustomJobInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: ExportCustomJobPayload): ExportCustomJobInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { ExportCustomJobInstance, ExportCustomJobList, ExportCustomJobListInstance, ExportCustomJobListInstanceCreateOptions, ExportCustomJobListInstanceEachOptions, ExportCustomJobListInstanceOptions, ExportCustomJobListInstancePageOptions, ExportCustomJobPage, ExportCustomJobPayload, ExportCustomJobResource, ExportCustomJobSolution, ExportCustomJobStatus }
