/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { SerializableClass } from '../../../../interfaces';

type UserConversationNotificationLevel = 'default'|'muted';

type UserConversationState = 'inactive'|'active'|'closed';

/**
 * Initialize the UserConversationList
 *
 * @param version - Version of the resource
 * @param userSid - The unique ID for the User.
 */
declare function UserConversationList(version: V1, userSid: string): UserConversationListInstance;

/**
 * Options to pass to update
 *
 * @property lastReadMessageIndex - The index of the last read Message.
 * @property lastReadTimestamp - The date of the last message read in conversation by the user.
 * @property notificationLevel - The Notification Level of this User Conversation.
 */
interface UserConversationInstanceUpdateOptions {
  lastReadMessageIndex?: number;
  lastReadTimestamp?: Date;
  notificationLevel?: UserConversationNotificationLevel;
}

interface UserConversationListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): UserConversationContext;
  /**
   * Streams UserConversationInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: UserConversationInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams UserConversationInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: UserConversationListInstanceEachOptions, callback?: (item: UserConversationInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a user_conversation
   *
   * @param conversationSid - The unique SID identifier of the Conversation.
   */
  get(conversationSid: string): UserConversationContext;
  /**
   * Retrieve a single target page of UserConversationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: UserConversationPage) => any): Promise<UserConversationPage>;
  /**
   * Retrieve a single target page of UserConversationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: UserConversationPage) => any): Promise<UserConversationPage>;
  /**
   * Lists UserConversationInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: UserConversationInstance[]) => any): Promise<UserConversationInstance[]>;
  /**
   * Lists UserConversationInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: UserConversationListInstanceOptions, callback?: (error: Error | null, items: UserConversationInstance[]) => any): Promise<UserConversationInstance[]>;
  /**
   * Retrieve a single page of UserConversationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: UserConversationPage) => any): Promise<UserConversationPage>;
  /**
   * Retrieve a single page of UserConversationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: UserConversationListInstancePageOptions, callback?: (error: Error | null, items: UserConversationPage) => any): Promise<UserConversationPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface UserConversationListInstanceEachOptions {
  callback?: (item: UserConversationInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface UserConversationListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface UserConversationListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface UserConversationPayload extends UserConversationResource, Page.TwilioResponsePayload {
}

interface UserConversationResource {
  account_sid: string;
  attributes: string;
  chat_service_sid: string;
  conversation_sid: string;
  conversation_state: UserConversationState;
  created_by: string;
  date_created: Date;
  date_updated: Date;
  friendly_name: string;
  last_read_message_index: number;
  links: string;
  notification_level: UserConversationNotificationLevel;
  participant_sid: string;
  timers: object;
  unique_name: string;
  unread_messages_count: number;
  url: string;
  user_sid: string;
}

interface UserConversationSolution {
  userSid?: string;
}


declare class UserConversationContext {
  /**
   * Initialize the UserConversationContext
   *
   * @param version - Version of the resource
   * @param userSid - The unique SID identifier of the User.
   * @param conversationSid - The unique SID identifier of the Conversation.
   */
  constructor(version: V1, userSid: string, conversationSid: string);

  /**
   * fetch a UserConversationInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: UserConversationInstance) => any): Promise<UserConversationInstance>;
  /**
   * remove a UserConversationInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: UserConversationInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a UserConversationInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: UserConversationInstance) => any): Promise<UserConversationInstance>;
  /**
   * update a UserConversationInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: UserConversationInstanceUpdateOptions, callback?: (error: Error | null, items: UserConversationInstance) => any): Promise<UserConversationInstance>;
}


declare class UserConversationInstance extends SerializableClass {
  /**
   * Initialize the UserConversationContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param userSid - The unique ID for the User.
   * @param conversationSid - The unique SID identifier of the Conversation.
   */
  constructor(version: V1, payload: UserConversationPayload, userSid: string, conversationSid: string);

  private _proxy: UserConversationContext;
  accountSid: string;
  attributes: string;
  chatServiceSid: string;
  conversationSid: string;
  conversationState: UserConversationState;
  createdBy: string;
  dateCreated: Date;
  dateUpdated: Date;
  /**
   * fetch a UserConversationInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: UserConversationInstance) => any): Promise<UserConversationInstance>;
  friendlyName: string;
  lastReadMessageIndex: number;
  links: string;
  notificationLevel: UserConversationNotificationLevel;
  participantSid: string;
  /**
   * remove a UserConversationInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: UserConversationInstance) => any): Promise<boolean>;
  timers: any;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  uniqueName: string;
  unreadMessagesCount: number;
  /**
   * update a UserConversationInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: UserConversationInstance) => any): Promise<UserConversationInstance>;
  /**
   * update a UserConversationInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: UserConversationInstanceUpdateOptions, callback?: (error: Error | null, items: UserConversationInstance) => any): Promise<UserConversationInstance>;
  url: string;
  userSid: string;
}


declare class UserConversationPage extends Page<V1, UserConversationPayload, UserConversationResource, UserConversationInstance> {
  /**
   * Initialize the UserConversationPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: UserConversationSolution);

  /**
   * Build an instance of UserConversationInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: UserConversationPayload): UserConversationInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { UserConversationContext, UserConversationInstance, UserConversationInstanceUpdateOptions, UserConversationList, UserConversationListInstance, UserConversationListInstanceEachOptions, UserConversationListInstanceOptions, UserConversationListInstancePageOptions, UserConversationNotificationLevel, UserConversationPage, UserConversationPayload, UserConversationResource, UserConversationSolution, UserConversationState }
