/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the EventTypeList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 */
declare function EventTypeList(version: V1): EventTypeListInstance;

interface EventTypeListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): EventTypeContext;
  /**
   * Streams EventTypeInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: EventTypeInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams EventTypeInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: EventTypeListInstanceEachOptions, callback?: (item: EventTypeInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a event_type
   *
   * @param type - A string that uniquely identifies this Event Type.
   */
  get(type: string): EventTypeContext;
  /**
   * Retrieve a single target page of EventTypeInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: EventTypePage) => any): Promise<EventTypePage>;
  /**
   * Retrieve a single target page of EventTypeInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: EventTypePage) => any): Promise<EventTypePage>;
  /**
   * Lists EventTypeInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: EventTypeInstance[]) => any): Promise<EventTypeInstance[]>;
  /**
   * Lists EventTypeInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: EventTypeListInstanceOptions, callback?: (error: Error | null, items: EventTypeInstance[]) => any): Promise<EventTypeInstance[]>;
  /**
   * Retrieve a single page of EventTypeInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: EventTypePage) => any): Promise<EventTypePage>;
  /**
   * Retrieve a single page of EventTypeInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: EventTypeListInstancePageOptions, callback?: (error: Error | null, items: EventTypePage) => any): Promise<EventTypePage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 * @property schemaId - A string to filter Event Types by schema.
 */
interface EventTypeListInstanceEachOptions {
  callback?: (item: EventTypeInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
  schemaId?: string;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 * @property schemaId - A string to filter Event Types by schema.
 */
interface EventTypeListInstanceOptions {
  limit?: number;
  pageSize?: number;
  schemaId?: string;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 * @property schemaId - A string to filter Event Types by schema.
 */
interface EventTypeListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
  schemaId?: string;
}

interface EventTypePayload extends EventTypeResource, Page.TwilioResponsePayload {
}

interface EventTypeResource {
  date_created: Date;
  date_updated: Date;
  description: string;
  links: string;
  schema_id: string;
  type: string;
  url: string;
}

interface EventTypeSolution {
}


declare class EventTypeContext {
  /**
   * Initialize the EventTypeContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param type - A string that uniquely identifies this Event Type.
   */
  constructor(version: V1, type: string);

  /**
   * fetch a EventTypeInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: EventTypeInstance) => any): Promise<EventTypeInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class EventTypeInstance extends SerializableClass {
  /**
   * Initialize the EventTypeContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param type - A string that uniquely identifies this Event Type.
   */
  constructor(version: V1, payload: EventTypePayload, type: string);

  private _proxy: EventTypeContext;
  dateCreated: Date;
  dateUpdated: Date;
  description: string;
  /**
   * fetch a EventTypeInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: EventTypeInstance) => any): Promise<EventTypeInstance>;
  links: string;
  schemaId: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  type: string;
  url: string;
}


declare class EventTypePage extends Page<V1, EventTypePayload, EventTypeResource, EventTypeInstance> {
  /**
   * Initialize the EventTypePage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: EventTypeSolution);

  /**
   * Build an instance of EventTypeInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: EventTypePayload): EventTypeInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { EventTypeContext, EventTypeInstance, EventTypeList, EventTypeListInstance, EventTypeListInstanceEachOptions, EventTypeListInstanceOptions, EventTypeListInstancePageOptions, EventTypePage, EventTypePayload, EventTypeResource, EventTypeSolution }
