'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../base/deserialize');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var FaxMediaList;
var FaxMediaPage;
var FaxMediaInstance;
var FaxMediaContext;

/* jshint ignore:start */
/**
 * Initialize the FaxMediaList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Fax.V1.FaxContext.FaxMediaList
 *
 * @param {Twilio.Fax.V1} version - Version of the resource
 * @param {string} faxSid -
 *          The SID of the fax the FaxMedia resource is associated with
 */
/* jshint ignore:end */
FaxMediaList = function FaxMediaList(version, faxSid) {
  /* jshint ignore:start */
  /**
   * @function media
   * @memberof Twilio.Fax.V1.FaxContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Fax.V1.FaxContext.FaxMediaContext}
   */
  /* jshint ignore:end */
  function FaxMediaListInstance(sid) {
    return FaxMediaListInstance.get(sid);
  }

  FaxMediaListInstance._version = version;
  // Path Solution
  FaxMediaListInstance._solution = {faxSid: faxSid};
  FaxMediaListInstance._uri = `/Faxes/${faxSid}/Media`;
  /* jshint ignore:start */
  /**
   * Streams FaxMediaInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Fax.V1.FaxContext.FaxMediaList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  FaxMediaListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        } else {
          onComplete();
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists FaxMediaInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Fax.V1.FaxContext.FaxMediaList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  FaxMediaListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of FaxMediaInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Fax.V1.FaxContext.FaxMediaList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  FaxMediaListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new FaxMediaPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of FaxMediaInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Fax.V1.FaxContext.FaxMediaList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  FaxMediaListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new FaxMediaPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a fax_media
   *
   * @function get
   * @memberof Twilio.Fax.V1.FaxContext.FaxMediaList#
   *
   * @param {string} sid - The unique string that identifies the resource to fetch
   *
   * @returns {Twilio.Fax.V1.FaxContext.FaxMediaContext}
   */
  /* jshint ignore:end */
  FaxMediaListInstance.get = function get(sid) {
    return new FaxMediaContext(this._version, this._solution.faxSid, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Fax.V1.FaxContext.FaxMediaList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  FaxMediaListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  FaxMediaListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return FaxMediaListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the FaxMediaPage
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Fax.V1.FaxContext.FaxMediaPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {FaxMediaSolution} solution - Path solution
 *
 * @returns FaxMediaPage
 */
/* jshint ignore:end */
FaxMediaPage = function FaxMediaPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(FaxMediaPage.prototype, Page.prototype);
FaxMediaPage.prototype.constructor = FaxMediaPage;

/* jshint ignore:start */
/**
 * Build an instance of FaxMediaInstance
 *
 * @function getInstance
 * @memberof Twilio.Fax.V1.FaxContext.FaxMediaPage#
 *
 * @param {FaxMediaPayload} payload - Payload response from the API
 *
 * @returns FaxMediaInstance
 */
/* jshint ignore:end */
FaxMediaPage.prototype.getInstance = function getInstance(payload) {
  return new FaxMediaInstance(this._version, payload, this._solution.faxSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Fax.V1.FaxContext.FaxMediaPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
FaxMediaPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

FaxMediaPage.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the FaxMediaContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Fax.V1.FaxContext.FaxMediaInstance
 *
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} faxSid -
 *          The SID of the fax the FaxMedia resource is associated with
 * @property {string} contentType - The content type of the stored fax media
 * @property {Date} dateCreated -
 *          The ISO 8601 date and time in GMT when the resource was created
 * @property {Date} dateUpdated -
 *          The ISO 8601 date and time in GMT when the resource was last updated
 * @property {string} url - The absolute URL of the FaxMedia resource
 *
 * @param {V1} version - Version of the resource
 * @param {FaxMediaPayload} payload - The instance payload
 * @param {sid} faxSid -
 *          The SID of the fax the FaxMedia resource is associated with
 * @param {sid} sid - The unique string that identifies the resource to fetch
 */
/* jshint ignore:end */
FaxMediaInstance = function FaxMediaInstance(version, payload, faxSid, sid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.faxSid = payload.fax_sid; // jshint ignore:line
  this.contentType = payload.content_type; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {faxSid: faxSid, sid: sid || this.sid, };
};

Object.defineProperty(FaxMediaInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new FaxMediaContext(this._version, this._solution.faxSid, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a FaxMediaInstance
 *
 * @function fetch
 * @memberof Twilio.Fax.V1.FaxContext.FaxMediaInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FaxMediaInstance
 */
/* jshint ignore:end */
FaxMediaInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * remove a FaxMediaInstance
 *
 * @function remove
 * @memberof Twilio.Fax.V1.FaxContext.FaxMediaInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FaxMediaInstance
 */
/* jshint ignore:end */
FaxMediaInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Fax.V1.FaxContext.FaxMediaInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
FaxMediaInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

FaxMediaInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the FaxMediaContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Fax.V1.FaxContext.FaxMediaContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid} faxSid - The SID of the fax with the FaxMedia resource to fetch
 * @param {sid} sid - The unique string that identifies the resource to fetch
 */
/* jshint ignore:end */
FaxMediaContext = function FaxMediaContext(version, faxSid, sid) {
  this._version = version;

  // Path Solution
  this._solution = {faxSid: faxSid, sid: sid, };
  this._uri = `/Faxes/${faxSid}/Media/${sid}`;
};

/* jshint ignore:start */
/**
 * fetch a FaxMediaInstance
 *
 * @function fetch
 * @memberof Twilio.Fax.V1.FaxContext.FaxMediaContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FaxMediaInstance
 */
/* jshint ignore:end */
FaxMediaContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new FaxMediaInstance(
      this._version,
      payload,
      this._solution.faxSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a FaxMediaInstance
 *
 * @function remove
 * @memberof Twilio.Fax.V1.FaxContext.FaxMediaContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FaxMediaInstance
 */
/* jshint ignore:end */
FaxMediaContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Fax.V1.FaxContext.FaxMediaContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
FaxMediaContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

FaxMediaContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  FaxMediaList: FaxMediaList,
  FaxMediaPage: FaxMediaPage,
  FaxMediaInstance: FaxMediaInstance,
  FaxMediaContext: FaxMediaContext
};
