'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../../base/deserialize');  /* jshint ignore:line */
var serialize = require(
    '../../../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../../../base/values');  /* jshint ignore:line */

var SyncMapItemList;
var SyncMapItemPage;
var SyncMapItemInstance;
var SyncMapItemContext;

/* jshint ignore:start */
/**
 * Initialize the SyncMapItemList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Sync.ServiceContext.SyncMapContext.SyncMapItemList
 *
 * @param {Twilio.Preview.Sync} version - Version of the resource
 * @param {string} serviceSid - The service_sid
 * @param {string} mapSid - The map_sid
 */
/* jshint ignore:end */
SyncMapItemList = function SyncMapItemList(version, serviceSid, mapSid) {
  /* jshint ignore:start */
  /**
   * @function syncMapItems
   * @memberof Twilio.Preview.Sync.ServiceContext.SyncMapContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Preview.Sync.ServiceContext.SyncMapContext.SyncMapItemContext}
   */
  /* jshint ignore:end */
  function SyncMapItemListInstance(sid) {
    return SyncMapItemListInstance.get(sid);
  }

  SyncMapItemListInstance._version = version;
  // Path Solution
  SyncMapItemListInstance._solution = {serviceSid: serviceSid, mapSid: mapSid};
  SyncMapItemListInstance._uri = `/Services/${serviceSid}/Maps/${mapSid}/Items`;
  /* jshint ignore:start */
  /**
   * create a SyncMapItemInstance
   *
   * @function create
   * @memberof Twilio.Preview.Sync.ServiceContext.SyncMapContext.SyncMapItemList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.key - The key
   * @param {object} opts.data - The data
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed SyncMapItemInstance
   */
  /* jshint ignore:end */
  SyncMapItemListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts['key'])) {
      throw new Error('Required parameter "opts[\'key\']" missing.');
    }
    if (_.isUndefined(opts['data'])) {
      throw new Error('Required parameter "opts[\'data\']" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({'Key': _.get(opts, 'key'), 'Data': serialize.object(_.get(opts, 'data'))});

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new SyncMapItemInstance(
        this._version,
        payload,
        this._solution.serviceSid,
        this._solution.mapSid,
        this._solution.key
      ));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Streams SyncMapItemInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Preview.Sync.ServiceContext.SyncMapContext.SyncMapItemList#
   *
   * @param {object} [opts] - Options for request
   * @param {sync_map_item.query_result_order} [opts.order] - The order
   * @param {string} [opts.from] - The from
   * @param {sync_map_item.query_from_bound_type} [opts.bounds] - The bounds
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  SyncMapItemListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        } else {
          onComplete();
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists SyncMapItemInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Preview.Sync.ServiceContext.SyncMapContext.SyncMapItemList#
   *
   * @param {object} [opts] - Options for request
   * @param {sync_map_item.query_result_order} [opts.order] - The order
   * @param {string} [opts.from] - The from
   * @param {sync_map_item.query_from_bound_type} [opts.bounds] - The bounds
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  SyncMapItemListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of SyncMapItemInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Preview.Sync.ServiceContext.SyncMapContext.SyncMapItemList#
   *
   * @param {object} [opts] - Options for request
   * @param {sync_map_item.query_result_order} [opts.order] - The order
   * @param {string} [opts.from] - The from
   * @param {sync_map_item.query_from_bound_type} [opts.bounds] - The bounds
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  SyncMapItemListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'Order': _.get(opts, 'order'),
      'From': _.get(opts, 'from'),
      'Bounds': _.get(opts, 'bounds'),
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new SyncMapItemPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of SyncMapItemInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Preview.Sync.ServiceContext.SyncMapContext.SyncMapItemList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  SyncMapItemListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new SyncMapItemPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a sync_map_item
   *
   * @function get
   * @memberof Twilio.Preview.Sync.ServiceContext.SyncMapContext.SyncMapItemList#
   *
   * @param {string} key - The key
   *
   * @returns {Twilio.Preview.Sync.ServiceContext.SyncMapContext.SyncMapItemContext}
   */
  /* jshint ignore:end */
  SyncMapItemListInstance.get = function get(key) {
    return new SyncMapItemContext(this._version, this._solution.serviceSid, this._solution.mapSid, key);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Preview.Sync.ServiceContext.SyncMapContext.SyncMapItemList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  SyncMapItemListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  SyncMapItemListInstance[util.inspect.custom] = function inspect(depth, options)
      {
    return util.inspect(this.toJSON(), options);
  };

  return SyncMapItemListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the SyncMapItemPage
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Sync.ServiceContext.SyncMapContext.SyncMapItemPage
 *
 * @param {Sync} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {SyncMapItemSolution} solution - Path solution
 *
 * @returns SyncMapItemPage
 */
/* jshint ignore:end */
SyncMapItemPage = function SyncMapItemPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(SyncMapItemPage.prototype, Page.prototype);
SyncMapItemPage.prototype.constructor = SyncMapItemPage;

/* jshint ignore:start */
/**
 * Build an instance of SyncMapItemInstance
 *
 * @function getInstance
 * @memberof Twilio.Preview.Sync.ServiceContext.SyncMapContext.SyncMapItemPage#
 *
 * @param {SyncMapItemPayload} payload - Payload response from the API
 *
 * @returns SyncMapItemInstance
 */
/* jshint ignore:end */
SyncMapItemPage.prototype.getInstance = function getInstance(payload) {
  return new SyncMapItemInstance(
    this._version,
    payload,
    this._solution.serviceSid,
    this._solution.mapSid
  );
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Sync.ServiceContext.SyncMapContext.SyncMapItemPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
SyncMapItemPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

SyncMapItemPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the SyncMapItemContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Sync.ServiceContext.SyncMapContext.SyncMapItemInstance
 *
 * @property {string} key - The key
 * @property {string} accountSid - The account_sid
 * @property {string} serviceSid - The service_sid
 * @property {string} mapSid - The map_sid
 * @property {string} url - The url
 * @property {string} revision - The revision
 * @property {object} data - The data
 * @property {Date} dateCreated - The date_created
 * @property {Date} dateUpdated - The date_updated
 * @property {string} createdBy - The created_by
 *
 * @param {Sync} version - Version of the resource
 * @param {SyncMapItemPayload} payload - The instance payload
 * @param {sid} serviceSid - The service_sid
 * @param {sid} mapSid - The map_sid
 * @param {string} key - The key
 */
/* jshint ignore:end */
SyncMapItemInstance = function SyncMapItemInstance(version, payload, serviceSid,
                                                    mapSid, key) {
  this._version = version;

  // Marshaled Properties
  this.key = payload.key; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.serviceSid = payload.service_sid; // jshint ignore:line
  this.mapSid = payload.map_sid; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.revision = payload.revision; // jshint ignore:line
  this.data = payload.data; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.createdBy = payload.created_by; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {serviceSid: serviceSid, mapSid: mapSid, key: key || this.key, };
};

Object.defineProperty(SyncMapItemInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new SyncMapItemContext(
          this._version,
          this._solution.serviceSid,
          this._solution.mapSid,
          this._solution.key
        );
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a SyncMapItemInstance
 *
 * @function fetch
 * @memberof Twilio.Preview.Sync.ServiceContext.SyncMapContext.SyncMapItemInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SyncMapItemInstance
 */
/* jshint ignore:end */
SyncMapItemInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * remove a SyncMapItemInstance
 *
 * @function remove
 * @memberof Twilio.Preview.Sync.ServiceContext.SyncMapContext.SyncMapItemInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.ifMatch] - The If-Match HTTP request header
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SyncMapItemInstance
 */
/* jshint ignore:end */
SyncMapItemInstance.prototype.remove = function remove(opts, callback) {
  return this._proxy.remove(opts, callback);
};

/* jshint ignore:start */
/**
 * update a SyncMapItemInstance
 *
 * @function update
 * @memberof Twilio.Preview.Sync.ServiceContext.SyncMapContext.SyncMapItemInstance#
 *
 * @param {object} opts - Options for request
 * @param {object} opts.data - The data
 * @param {string} [opts.ifMatch] - The If-Match HTTP request header
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SyncMapItemInstance
 */
/* jshint ignore:end */
SyncMapItemInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Sync.ServiceContext.SyncMapContext.SyncMapItemInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
SyncMapItemInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

SyncMapItemInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the SyncMapItemContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Sync.ServiceContext.SyncMapContext.SyncMapItemContext
 *
 * @param {Sync} version - Version of the resource
 * @param {sid} serviceSid - The service_sid
 * @param {sid_like} mapSid - The map_sid
 * @param {string} key - The key
 */
/* jshint ignore:end */
SyncMapItemContext = function SyncMapItemContext(version, serviceSid, mapSid,
                                                  key) {
  this._version = version;

  // Path Solution
  this._solution = {serviceSid: serviceSid, mapSid: mapSid, key: key, };
  this._uri = `/Services/${serviceSid}/Maps/${mapSid}/Items/${key}`;
};

/* jshint ignore:start */
/**
 * fetch a SyncMapItemInstance
 *
 * @function fetch
 * @memberof Twilio.Preview.Sync.ServiceContext.SyncMapContext.SyncMapItemContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SyncMapItemInstance
 */
/* jshint ignore:end */
SyncMapItemContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new SyncMapItemInstance(
      this._version,
      payload,
      this._solution.serviceSid,
      this._solution.mapSid,
      this._solution.key
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a SyncMapItemInstance
 *
 * @function remove
 * @memberof Twilio.Preview.Sync.ServiceContext.SyncMapContext.SyncMapItemContext#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.ifMatch] - The If-Match HTTP request header
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SyncMapItemInstance
 */
/* jshint ignore:end */
SyncMapItemContext.prototype.remove = function remove(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var headers = values.of({'If-Match': _.get(opts, 'ifMatch')});

  var promise = this._version.remove({uri: this._uri, method: 'DELETE', headers: headers});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a SyncMapItemInstance
 *
 * @function update
 * @memberof Twilio.Preview.Sync.ServiceContext.SyncMapContext.SyncMapItemContext#
 *
 * @param {object} opts - Options for request
 * @param {object} opts.data - The data
 * @param {string} [opts.ifMatch] - The If-Match HTTP request header
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SyncMapItemInstance
 */
/* jshint ignore:end */
SyncMapItemContext.prototype.update = function update(opts, callback) {
  if (_.isUndefined(opts)) {
    throw new Error('Required parameter "opts" missing.');
  }
  if (_.isUndefined(opts['data'])) {
    throw new Error('Required parameter "opts[\'data\']" missing.');
  }

  var deferred = Q.defer();
  var data = values.of({'Data': serialize.object(_.get(opts, 'data'))});
  var headers = values.of({'If-Match': _.get(opts, 'ifMatch')});

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data, headers: headers});

  promise = promise.then(function(payload) {
    deferred.resolve(new SyncMapItemInstance(
      this._version,
      payload,
      this._solution.serviceSid,
      this._solution.mapSid,
      this._solution.key
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Sync.ServiceContext.SyncMapContext.SyncMapItemContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
SyncMapItemContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

SyncMapItemContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  SyncMapItemList: SyncMapItemList,
  SyncMapItemPage: SyncMapItemPage,
  SyncMapItemInstance: SyncMapItemInstance,
  SyncMapItemContext: SyncMapItemContext
};
