/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import TrustedComms = require('../TrustedComms');
import { ChannelList } from './brandedChannel/channel';
import { ChannelListInstance } from './brandedChannel/channel';
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the BrandedChannelList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 */
declare function BrandedChannelList(version: TrustedComms): BrandedChannelListInstance;

interface BrandedChannelListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): BrandedChannelContext;
  /**
   * Constructs a branded_channel
   *
   * @param sid - Branded Channel Sid.
   */
  get(sid: string): BrandedChannelContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface BrandedChannelPayload extends BrandedChannelResource, Page.TwilioResponsePayload {
}

interface BrandedChannelResource {
  account_sid: string;
  brand_sid: string;
  business_sid: string;
  links: string;
  sid: string;
  url: string;
}

interface BrandedChannelSolution {
}


declare class BrandedChannelContext {
  /**
   * Initialize the BrandedChannelContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param sid - Branded Channel Sid.
   */
  constructor(version: TrustedComms, sid: string);

  channels: ChannelListInstance;
  /**
   * fetch a BrandedChannelInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: BrandedChannelInstance) => any): Promise<BrandedChannelInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class BrandedChannelInstance extends SerializableClass {
  /**
   * Initialize the BrandedChannelContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - Branded Channel Sid.
   */
  constructor(version: TrustedComms, payload: BrandedChannelPayload, sid: string);

  private _proxy: BrandedChannelContext;
  accountSid: string;
  brandSid: string;
  businessSid: string;
  /**
   * Access the channels
   */
  channels(): ChannelListInstance;
  /**
   * fetch a BrandedChannelInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: BrandedChannelInstance) => any): Promise<BrandedChannelInstance>;
  links: string;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class BrandedChannelPage extends Page<TrustedComms, BrandedChannelPayload, BrandedChannelResource, BrandedChannelInstance> {
  /**
   * Initialize the BrandedChannelPage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: TrustedComms, response: Response<string>, solution: BrandedChannelSolution);

  /**
   * Build an instance of BrandedChannelInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: BrandedChannelPayload): BrandedChannelInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { BrandedChannelContext, BrandedChannelInstance, BrandedChannelList, BrandedChannelListInstance, BrandedChannelPage, BrandedChannelPayload, BrandedChannelResource, BrandedChannelSolution }
