/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

type IpCommandDirection = 'to_sim'|'from_sim';

type IpCommandPayloadType = 'text'|'binary';

type IpCommandStatus = 'queued'|'sent'|'received'|'failed';

/**
 * Initialize the IpCommandList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 */
declare function IpCommandList(version: V1): IpCommandListInstance;

interface IpCommandListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): IpCommandContext;
  /**
   * create a IpCommandInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: IpCommandListInstanceCreateOptions, callback?: (error: Error | null, item: IpCommandInstance) => any): Promise<IpCommandInstance>;
  /**
   * Streams IpCommandInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: IpCommandInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams IpCommandInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: IpCommandListInstanceEachOptions, callback?: (item: IpCommandInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a ip_command
   *
   * @param sid - The SID that identifies the resource to fetch
   */
  get(sid: string): IpCommandContext;
  /**
   * Retrieve a single target page of IpCommandInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: IpCommandPage) => any): Promise<IpCommandPage>;
  /**
   * Retrieve a single target page of IpCommandInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: IpCommandPage) => any): Promise<IpCommandPage>;
  /**
   * Lists IpCommandInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: IpCommandInstance[]) => any): Promise<IpCommandInstance[]>;
  /**
   * Lists IpCommandInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: IpCommandListInstanceOptions, callback?: (error: Error | null, items: IpCommandInstance[]) => any): Promise<IpCommandInstance[]>;
  /**
   * Retrieve a single page of IpCommandInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: IpCommandPage) => any): Promise<IpCommandPage>;
  /**
   * Retrieve a single page of IpCommandInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: IpCommandListInstancePageOptions, callback?: (error: Error | null, items: IpCommandPage) => any): Promise<IpCommandPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property callbackMethod - The HTTP method we should use to call callback_url
 * @property callbackUrl - The URL we should call after we have sent the IP Command
 * @property devicePort - The device port to which the IP Command will be sent
 * @property payload - The payload to be delivered to the device
 * @property payloadType - Indicates how the payload is encoded
 * @property sim - The sid or unique_name of the Super SIM to send the IP Command to
 */
interface IpCommandListInstanceCreateOptions {
  callbackMethod?: string;
  callbackUrl?: string;
  devicePort: number;
  payload: string;
  payloadType?: IpCommandPayloadType;
  sim: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property direction - The direction of the IP Command
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 * @property sim - The SID or unique name of the Sim resource that IP Command was sent to or from.
 * @property simIccid - The ICCID of the Sim resource that IP Command was sent to or from.
 * @property status - The status of the IP Command
 */
interface IpCommandListInstanceEachOptions {
  callback?: (item: IpCommandInstance, done: (err?: Error) => void) => void;
  direction?: IpCommandDirection;
  done?: Function;
  limit?: number;
  pageSize?: number;
  sim?: string;
  simIccid?: string;
  status?: IpCommandStatus;
}

/**
 * Options to pass to list
 *
 * @property direction - The direction of the IP Command
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 * @property sim - The SID or unique name of the Sim resource that IP Command was sent to or from.
 * @property simIccid - The ICCID of the Sim resource that IP Command was sent to or from.
 * @property status - The status of the IP Command
 */
interface IpCommandListInstanceOptions {
  direction?: IpCommandDirection;
  limit?: number;
  pageSize?: number;
  sim?: string;
  simIccid?: string;
  status?: IpCommandStatus;
}

/**
 * Options to pass to page
 *
 * @property direction - The direction of the IP Command
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 * @property sim - The SID or unique name of the Sim resource that IP Command was sent to or from.
 * @property simIccid - The ICCID of the Sim resource that IP Command was sent to or from.
 * @property status - The status of the IP Command
 */
interface IpCommandListInstancePageOptions {
  direction?: IpCommandDirection;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
  sim?: string;
  simIccid?: string;
  status?: IpCommandStatus;
}

interface IpCommandPayload extends IpCommandResource, Page.TwilioResponsePayload {
}

interface IpCommandResource {
  account_sid: string;
  date_created: Date;
  date_updated: Date;
  device_ip: string;
  device_port: number;
  direction: IpCommandDirection;
  payload: string;
  payload_type: IpCommandPayloadType;
  sid: string;
  sim_iccid: string;
  sim_sid: string;
  status: IpCommandStatus;
  url: string;
}

interface IpCommandSolution {
}


declare class IpCommandContext {
  /**
   * Initialize the IpCommandContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param sid - The SID that identifies the resource to fetch
   */
  constructor(version: V1, sid: string);

  /**
   * fetch a IpCommandInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: IpCommandInstance) => any): Promise<IpCommandInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class IpCommandInstance extends SerializableClass {
  /**
   * Initialize the IpCommandContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The SID that identifies the resource to fetch
   */
  constructor(version: V1, payload: IpCommandPayload, sid: string);

  private _proxy: IpCommandContext;
  accountSid: string;
  dateCreated: Date;
  dateUpdated: Date;
  deviceIp: string;
  devicePort: number;
  direction: IpCommandDirection;
  /**
   * fetch a IpCommandInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: IpCommandInstance) => any): Promise<IpCommandInstance>;
  payload: string;
  payloadType: IpCommandPayloadType;
  sid: string;
  simIccid: string;
  simSid: string;
  status: IpCommandStatus;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class IpCommandPage extends Page<V1, IpCommandPayload, IpCommandResource, IpCommandInstance> {
  /**
   * Initialize the IpCommandPage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: IpCommandSolution);

  /**
   * Build an instance of IpCommandInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: IpCommandPayload): IpCommandInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { IpCommandContext, IpCommandDirection, IpCommandInstance, IpCommandList, IpCommandListInstance, IpCommandListInstanceCreateOptions, IpCommandListInstanceEachOptions, IpCommandListInstanceOptions, IpCommandListInstancePageOptions, IpCommandPage, IpCommandPayload, IpCommandPayloadType, IpCommandResource, IpCommandSolution, IpCommandStatus }
