'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var ReservationList = require('./task/reservation').ReservationList;
var deserialize = require(
    '../../../../base/deserialize');  /* jshint ignore:line */
var serialize = require('../../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var TaskList;
var TaskPage;
var TaskInstance;
var TaskContext;

/* jshint ignore:start */
/**
 * Initialize the TaskList
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceContext.TaskList
 *
 * @param {Twilio.Taskrouter.V1} version - Version of the resource
 * @param {string} workspaceSid - The SID of the Workspace that contains the Task
 */
/* jshint ignore:end */
TaskList = function TaskList(version, workspaceSid) {
  /* jshint ignore:start */
  /**
   * @function tasks
   * @memberof Twilio.Taskrouter.V1.WorkspaceContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Taskrouter.V1.WorkspaceContext.TaskContext}
   */
  /* jshint ignore:end */
  function TaskListInstance(sid) {
    return TaskListInstance.get(sid);
  }

  TaskListInstance._version = version;
  // Path Solution
  TaskListInstance._solution = {workspaceSid: workspaceSid};
  TaskListInstance._uri = `/Workspaces/${workspaceSid}/Tasks`;
  /* jshint ignore:start */
  /**
   * Streams TaskInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.priority] - The priority value of the Tasks to read
   * @param {string|list} [opts.assignmentStatus] -
   *          Returns the list of all Tasks in the Workspace with the specified assignment_status
   * @param {string} [opts.workflowSid] -
   *          The SID of the Workflow with the Tasks to read
   * @param {string} [opts.workflowName] -
   *          The friendly name of the Workflow with the Tasks to read
   * @param {string} [opts.taskQueueSid] -
   *          The SID of the TaskQueue with the Tasks to read
   * @param {string} [opts.taskQueueName] -
   *          The friendly_name of the TaskQueue with the Tasks to read
   * @param {string} [opts.evaluateTaskAttributes] -
   *          The task attributes of the Tasks to read
   * @param {string} [opts.ordering] - Controls the order of the Tasks returned
   * @param {boolean} [opts.hasAddons] - Whether to read Tasks with addons
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  TaskListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        } else {
          onComplete();
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists TaskInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.priority] - The priority value of the Tasks to read
   * @param {string|list} [opts.assignmentStatus] -
   *          Returns the list of all Tasks in the Workspace with the specified assignment_status
   * @param {string} [opts.workflowSid] -
   *          The SID of the Workflow with the Tasks to read
   * @param {string} [opts.workflowName] -
   *          The friendly name of the Workflow with the Tasks to read
   * @param {string} [opts.taskQueueSid] -
   *          The SID of the TaskQueue with the Tasks to read
   * @param {string} [opts.taskQueueName] -
   *          The friendly_name of the TaskQueue with the Tasks to read
   * @param {string} [opts.evaluateTaskAttributes] -
   *          The task attributes of the Tasks to read
   * @param {string} [opts.ordering] - Controls the order of the Tasks returned
   * @param {boolean} [opts.hasAddons] - Whether to read Tasks with addons
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  TaskListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of TaskInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.priority] - The priority value of the Tasks to read
   * @param {string|list} [opts.assignmentStatus] -
   *          Returns the list of all Tasks in the Workspace with the specified assignment_status
   * @param {string} [opts.workflowSid] -
   *          The SID of the Workflow with the Tasks to read
   * @param {string} [opts.workflowName] -
   *          The friendly name of the Workflow with the Tasks to read
   * @param {string} [opts.taskQueueSid] -
   *          The SID of the TaskQueue with the Tasks to read
   * @param {string} [opts.taskQueueName] -
   *          The friendly_name of the TaskQueue with the Tasks to read
   * @param {string} [opts.evaluateTaskAttributes] -
   *          The task attributes of the Tasks to read
   * @param {string} [opts.ordering] - Controls the order of the Tasks returned
   * @param {boolean} [opts.hasAddons] - Whether to read Tasks with addons
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  TaskListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'Priority': _.get(opts, 'priority'),
      'AssignmentStatus': serialize.map(_.get(opts, 'assignmentStatus'), function(e) { return e; }),
      'WorkflowSid': _.get(opts, 'workflowSid'),
      'WorkflowName': _.get(opts, 'workflowName'),
      'TaskQueueSid': _.get(opts, 'taskQueueSid'),
      'TaskQueueName': _.get(opts, 'taskQueueName'),
      'EvaluateTaskAttributes': _.get(opts, 'evaluateTaskAttributes'),
      'Ordering': _.get(opts, 'ordering'),
      'HasAddons': serialize.bool(_.get(opts, 'hasAddons')),
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new TaskPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of TaskInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  TaskListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new TaskPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * create a TaskInstance
   *
   * @function create
   * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.timeout] -
   *          The amount of time in seconds the task can live before being assigned
   * @param {number} [opts.priority] -
   *          The priority to assign the new task and override the default
   * @param {string} [opts.taskChannel] -
   *          When MultiTasking is enabled specify the TaskChannel by passing either its unique_name or SID
   * @param {string} [opts.workflowSid] -
   *          The SID of the Workflow that you would like to handle routing for the new Task
   * @param {string} [opts.attributes] -
   *          A URL-encoded JSON string describing the attributes of the task
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed TaskInstance
   */
  /* jshint ignore:end */
  TaskListInstance.create = function create(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'Timeout': _.get(opts, 'timeout'),
      'Priority': _.get(opts, 'priority'),
      'TaskChannel': _.get(opts, 'taskChannel'),
      'WorkflowSid': _.get(opts, 'workflowSid'),
      'Attributes': _.get(opts, 'attributes')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new TaskInstance(
        this._version,
        payload,
        this._solution.workspaceSid,
        this._solution.sid
      ));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a task
   *
   * @function get
   * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskList#
   *
   * @param {string} sid - The SID of the resource to fetch
   *
   * @returns {Twilio.Taskrouter.V1.WorkspaceContext.TaskContext}
   */
  /* jshint ignore:end */
  TaskListInstance.get = function get(sid) {
    return new TaskContext(this._version, this._solution.workspaceSid, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  TaskListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  TaskListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return TaskListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the TaskPage
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceContext.TaskPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {TaskSolution} solution - Path solution
 *
 * @returns TaskPage
 */
/* jshint ignore:end */
TaskPage = function TaskPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(TaskPage.prototype, Page.prototype);
TaskPage.prototype.constructor = TaskPage;

/* jshint ignore:start */
/**
 * Build an instance of TaskInstance
 *
 * @function getInstance
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskPage#
 *
 * @param {TaskPayload} payload - Payload response from the API
 *
 * @returns TaskInstance
 */
/* jshint ignore:end */
TaskPage.prototype.getInstance = function getInstance(payload) {
  return new TaskInstance(this._version, payload, this._solution.workspaceSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
TaskPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

TaskPage.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the TaskContext
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceContext.TaskInstance
 *
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {number} age - The number of seconds since the Task was created
 * @property {task.status} assignmentStatus -
 *          The current status of the Task's assignment
 * @property {string} attributes -
 *          The JSON string with custom attributes of the work
 * @property {string} addons -
 *          An object that contains the addon data for all installed addons
 * @property {Date} dateCreated -
 *          The ISO 8601 date and time in GMT when the resource was created
 * @property {Date} dateUpdated -
 *          The ISO 8601 date and time in GMT when the resource was last updated
 * @property {Date} taskQueueEnteredDate -
 *          The ISO 8601 date and time in GMT when the Task entered the TaskQueue.
 * @property {number} priority -
 *          Retrieve the list of all Tasks in the Workspace with the specified priority
 * @property {string} reason - The reason the Task was canceled or completed
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} taskQueueSid - The SID of the TaskQueue
 * @property {string} taskQueueFriendlyName - The friendly name of the TaskQueue
 * @property {string} taskChannelSid - The SID of the TaskChannel
 * @property {string} taskChannelUniqueName - The unique name of the TaskChannel
 * @property {number} timeout -
 *          The amount of time in seconds that the Task can live before being assigned
 * @property {string} workflowSid -
 *          The SID of the Workflow that is controlling the Task
 * @property {string} workflowFriendlyName -
 *          The friendly name of the Workflow that is controlling the Task
 * @property {string} workspaceSid -
 *          The SID of the Workspace that contains the Task
 * @property {string} url - The absolute URL of the Task resource
 * @property {string} links - The URLs of related resources
 *
 * @param {V1} version - Version of the resource
 * @param {TaskPayload} payload - The instance payload
 * @param {sid} workspaceSid - The SID of the Workspace that contains the Task
 * @param {sid} sid - The SID of the resource to fetch
 */
/* jshint ignore:end */
TaskInstance = function TaskInstance(version, payload, workspaceSid, sid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.age = deserialize.integer(payload.age); // jshint ignore:line
  this.assignmentStatus = payload.assignment_status; // jshint ignore:line
  this.attributes = payload.attributes; // jshint ignore:line
  this.addons = payload.addons; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.taskQueueEnteredDate = deserialize.iso8601DateTime(payload.task_queue_entered_date); // jshint ignore:line
  this.priority = deserialize.integer(payload.priority); // jshint ignore:line
  this.reason = payload.reason; // jshint ignore:line
  this.sid = payload.sid; // jshint ignore:line
  this.taskQueueSid = payload.task_queue_sid; // jshint ignore:line
  this.taskQueueFriendlyName = payload.task_queue_friendly_name; // jshint ignore:line
  this.taskChannelSid = payload.task_channel_sid; // jshint ignore:line
  this.taskChannelUniqueName = payload.task_channel_unique_name; // jshint ignore:line
  this.timeout = deserialize.integer(payload.timeout); // jshint ignore:line
  this.workflowSid = payload.workflow_sid; // jshint ignore:line
  this.workflowFriendlyName = payload.workflow_friendly_name; // jshint ignore:line
  this.workspaceSid = payload.workspace_sid; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.links = payload.links; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {workspaceSid: workspaceSid, sid: sid || this.sid, };
};

Object.defineProperty(TaskInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new TaskContext(this._version, this._solution.workspaceSid, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a TaskInstance
 *
 * @function fetch
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed TaskInstance
 */
/* jshint ignore:end */
TaskInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * update a TaskInstance
 *
 * @function update
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.attributes] -
 *          The JSON string that describes the custom attributes of the task
 * @param {task.status} [opts.assignmentStatus] - The new status of the task
 * @param {string} [opts.reason] -
 *          The reason that the Task was canceled or complete
 * @param {number} [opts.priority] - The Task's new priority value
 * @param {string} [opts.taskChannel] -
 *          When MultiTasking is enabled, specify the TaskChannel with the task to update
 * @param {string} [opts.ifMatch] - The If-Match HTTP request header
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed TaskInstance
 */
/* jshint ignore:end */
TaskInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * remove a TaskInstance
 *
 * @function remove
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.ifMatch] - The If-Match HTTP request header
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed TaskInstance
 */
/* jshint ignore:end */
TaskInstance.prototype.remove = function remove(opts, callback) {
  return this._proxy.remove(opts, callback);
};

/* jshint ignore:start */
/**
 * Access the reservations
 *
 * @function reservations
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskInstance#
 *
 * @returns {Twilio.Taskrouter.V1.WorkspaceContext.TaskContext.ReservationList}
 */
/* jshint ignore:end */
TaskInstance.prototype.reservations = function reservations() {
  return this._proxy.reservations;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
TaskInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

TaskInstance.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the TaskContext
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceContext.TaskContext
 *
 * @property {Twilio.Taskrouter.V1.WorkspaceContext.TaskContext.ReservationList} reservations -
 *          reservations resource
 *
 * @param {V1} version - Version of the resource
 * @param {sid} workspaceSid - The SID of the Workspace with the Task to fetch
 * @param {sid} sid - The SID of the resource to fetch
 */
/* jshint ignore:end */
TaskContext = function TaskContext(version, workspaceSid, sid) {
  this._version = version;

  // Path Solution
  this._solution = {workspaceSid: workspaceSid, sid: sid, };
  this._uri = `/Workspaces/${workspaceSid}/Tasks/${sid}`;

  // Dependents
  this._reservations = undefined;
};

/* jshint ignore:start */
/**
 * fetch a TaskInstance
 *
 * @function fetch
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed TaskInstance
 */
/* jshint ignore:end */
TaskContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new TaskInstance(
      this._version,
      payload,
      this._solution.workspaceSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a TaskInstance
 *
 * @function update
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskContext#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.attributes] -
 *          The JSON string that describes the custom attributes of the task
 * @param {task.status} [opts.assignmentStatus] - The new status of the task
 * @param {string} [opts.reason] -
 *          The reason that the Task was canceled or complete
 * @param {number} [opts.priority] - The Task's new priority value
 * @param {string} [opts.taskChannel] -
 *          When MultiTasking is enabled, specify the TaskChannel with the task to update
 * @param {string} [opts.ifMatch] - The If-Match HTTP request header
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed TaskInstance
 */
/* jshint ignore:end */
TaskContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'Attributes': _.get(opts, 'attributes'),
    'AssignmentStatus': _.get(opts, 'assignmentStatus'),
    'Reason': _.get(opts, 'reason'),
    'Priority': _.get(opts, 'priority'),
    'TaskChannel': _.get(opts, 'taskChannel')
  });
  var headers = values.of({'If-Match': _.get(opts, 'ifMatch')});

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data, headers: headers});

  promise = promise.then(function(payload) {
    deferred.resolve(new TaskInstance(
      this._version,
      payload,
      this._solution.workspaceSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a TaskInstance
 *
 * @function remove
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskContext#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.ifMatch] - The If-Match HTTP request header
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed TaskInstance
 */
/* jshint ignore:end */
TaskContext.prototype.remove = function remove(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var headers = values.of({'If-Match': _.get(opts, 'ifMatch')});

  var promise = this._version.remove({uri: this._uri, method: 'DELETE', headers: headers});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

Object.defineProperty(TaskContext.prototype,
  'reservations', {
    get: function() {
      if (!this._reservations) {
        this._reservations = new ReservationList(
          this._version,
          this._solution.workspaceSid,
          this._solution.sid
        );
      }
      return this._reservations;
    }
});

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
TaskContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

TaskContext.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  TaskList: TaskList,
  TaskPage: TaskPage,
  TaskInstance: TaskInstance,
  TaskContext: TaskContext
};
