/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../base/Page');
import Response = require('../../../../../http/response');
import V2 = require('../../../V2');
import { SerializableClass } from '../../../../../interfaces';

/**
 * Initialize the BucketList
 *
 * @param version - Version of the resource
 * @param serviceSid - The SID of the Service that the resource is associated with
 * @param rateLimitSid - Rate Limit Sid.
 */
declare function BucketList(version: V2, serviceSid: string, rateLimitSid: string): BucketListInstance;

/**
 * Options to pass to update
 *
 * @property interval - Number of seconds that the rate limit will be enforced over.
 * @property max - Max number of requests.
 */
interface BucketInstanceUpdateOptions {
  interval?: number;
  max?: number;
}

interface BucketListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): BucketContext;
  /**
   * create a BucketInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: BucketListInstanceCreateOptions, callback?: (error: Error | null, item: BucketInstance) => any): Promise<BucketInstance>;
  /**
   * Streams BucketInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: BucketInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams BucketInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: BucketListInstanceEachOptions, callback?: (item: BucketInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a bucket
   *
   * @param sid - A string that uniquely identifies this Bucket.
   */
  get(sid: string): BucketContext;
  /**
   * Retrieve a single target page of BucketInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: BucketPage) => any): Promise<BucketPage>;
  /**
   * Retrieve a single target page of BucketInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: BucketPage) => any): Promise<BucketPage>;
  /**
   * Lists BucketInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: BucketInstance[]) => any): Promise<BucketInstance[]>;
  /**
   * Lists BucketInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: BucketListInstanceOptions, callback?: (error: Error | null, items: BucketInstance[]) => any): Promise<BucketInstance[]>;
  /**
   * Retrieve a single page of BucketInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: BucketPage) => any): Promise<BucketPage>;
  /**
   * Retrieve a single page of BucketInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: BucketListInstancePageOptions, callback?: (error: Error | null, items: BucketPage) => any): Promise<BucketPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property interval - Number of seconds that the rate limit will be enforced over.
 * @property max - Max number of requests.
 */
interface BucketListInstanceCreateOptions {
  interval: number;
  max: number;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface BucketListInstanceEachOptions {
  callback?: (item: BucketInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface BucketListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface BucketListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface BucketPayload extends BucketResource, Page.TwilioResponsePayload {
}

interface BucketResource {
  account_sid: string;
  date_created: Date;
  date_updated: Date;
  interval: number;
  max: number;
  rate_limit_sid: string;
  service_sid: string;
  sid: string;
  url: string;
}

interface BucketSolution {
  rateLimitSid?: string;
  serviceSid?: string;
}


declare class BucketContext {
  /**
   * Initialize the BucketContext
   *
   * @param version - Version of the resource
   * @param serviceSid - The SID of the Service that the resource is associated with
   * @param rateLimitSid - Rate Limit Sid.
   * @param sid - A string that uniquely identifies this Bucket.
   */
  constructor(version: V2, serviceSid: string, rateLimitSid: string, sid: string);

  /**
   * fetch a BucketInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: BucketInstance) => any): Promise<BucketInstance>;
  /**
   * remove a BucketInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: BucketInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a BucketInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: BucketInstance) => any): Promise<BucketInstance>;
  /**
   * update a BucketInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: BucketInstanceUpdateOptions, callback?: (error: Error | null, items: BucketInstance) => any): Promise<BucketInstance>;
}


declare class BucketInstance extends SerializableClass {
  /**
   * Initialize the BucketContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param serviceSid - The SID of the Service that the resource is associated with
   * @param rateLimitSid - Rate Limit Sid.
   * @param sid - A string that uniquely identifies this Bucket.
   */
  constructor(version: V2, payload: BucketPayload, serviceSid: string, rateLimitSid: string, sid: string);

  private _proxy: BucketContext;
  accountSid: string;
  dateCreated: Date;
  dateUpdated: Date;
  /**
   * fetch a BucketInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: BucketInstance) => any): Promise<BucketInstance>;
  interval: number;
  max: number;
  rateLimitSid: string;
  /**
   * remove a BucketInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: BucketInstance) => any): Promise<boolean>;
  serviceSid: string;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a BucketInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: BucketInstance) => any): Promise<BucketInstance>;
  /**
   * update a BucketInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: BucketInstanceUpdateOptions, callback?: (error: Error | null, items: BucketInstance) => any): Promise<BucketInstance>;
  url: string;
}


declare class BucketPage extends Page<V2, BucketPayload, BucketResource, BucketInstance> {
  /**
   * Initialize the BucketPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2, response: Response<string>, solution: BucketSolution);

  /**
   * Build an instance of BucketInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: BucketPayload): BucketInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { BucketContext, BucketInstance, BucketInstanceUpdateOptions, BucketList, BucketListInstance, BucketListInstanceCreateOptions, BucketListInstanceEachOptions, BucketListInstanceOptions, BucketListInstancePageOptions, BucketPage, BucketPayload, BucketResource, BucketSolution }
