'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var _ = require('lodash');  /* jshint ignore:line */
var Domain = require('../base/Domain');  /* jshint ignore:line */
var V1 = require('./pricing/V1');  /* jshint ignore:line */
var V2 = require('./pricing/V2');  /* jshint ignore:line */


/* jshint ignore:start */
/**
 * Initialize pricing domain
 *
 * @constructor Twilio.Pricing
 *
 * @property {Twilio.Pricing.V1} v1 - v1 version
 * @property {Twilio.Pricing.V2} v2 - v2 version
 * @property {Twilio.Pricing.V1.MessagingList} messaging - messaging resource
 * @property {Twilio.Pricing.V1.PhoneNumberList} phoneNumbers -
 *          phoneNumbers resource
 * @property {Twilio.Pricing.V2.VoiceList} voice - voice resource
 * @property {Twilio.Pricing.V2.CountryList} countries - countries resource
 * @property {Twilio.Pricing.V2.NumberList} numbers - numbers resource
 *
 * @param {Twilio} twilio - The twilio client
 */
/* jshint ignore:end */
function Pricing(twilio) {
  Domain.prototype.constructor.call(this, twilio, 'https://pricing.twilio.com');

  // Versions
  this._v1 = undefined;
  this._v2 = undefined;
}

_.extend(Pricing.prototype, Domain.prototype);
Pricing.prototype.constructor = Pricing;

Object.defineProperty(Pricing.prototype,
  'v1', {
    get: function() {
      this._v1 = this._v1 || new V1(this);
      return this._v1;
    }
});

Object.defineProperty(Pricing.prototype,
  'v2', {
    get: function() {
      this._v2 = this._v2 || new V2(this);
      return this._v2;
    }
});

Object.defineProperty(Pricing.prototype,
  'messaging', {
    get: function() {
      return this.v1.messaging;
    }
});

Object.defineProperty(Pricing.prototype,
  'phoneNumbers', {
    get: function() {
      return this.v1.phoneNumbers;
    }
});

Object.defineProperty(Pricing.prototype,
  'voice', {
    get: function() {
      return this.v2.voice;
    }
});

Object.defineProperty(Pricing.prototype,
  'countries', {
    get: function() {
      return this.v2.countries;
    }
});

Object.defineProperty(Pricing.prototype,
  'numbers', {
    get: function() {
      return this.v2.numbers;
    }
});

module.exports = Pricing;
