/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../base/Page');
import Response = require('../../../../../http/response');
import V2010 = require('../../../V2010');
import { SerializableClass } from '../../../../../interfaces';

type PaymentBankAccountType = 'consumer-checking'|'consumer-savings'|'commercial-checking';

type PaymentCapture = 'payment-card-number'|'expiration-date'|'security-code'|'postal-code'|'bank-routing-number'|'bank-account-number';

type PaymentPaymentMethod = 'credit-card'|'ach-debit';

type PaymentStatus = 'complete'|'cancel';

type PaymentTokenType = 'one-time'|'reusable';

/**
 * Initialize the PaymentList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 * @param accountSid - The SID of the Account that created the Payments resource.
 * @param callSid - The SID of the Call the resource is associated with.
 */
declare function PaymentList(version: V2010, accountSid: string, callSid: string): PaymentListInstance;

/**
 * Options to pass to update
 *
 * @property capture - The piece of payment information that you wish the caller to enter.
 * @property idempotencyKey - A unique token that will be used to ensure that multiple API calls with the same information do not result in multiple transactions.
 * @property status - Indicates whether the current payment session should be cancelled or completed.
 * @property statusCallback - Provide an absolute or relative URL to receive status updates regarding your Pay session.
 */
interface PaymentInstanceUpdateOptions {
  capture?: PaymentCapture;
  idempotencyKey: string;
  status?: PaymentStatus;
  statusCallback: string;
}

interface PaymentListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): PaymentContext;
  /**
   * create a PaymentInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: PaymentListInstanceCreateOptions, callback?: (error: Error | null, item: PaymentInstance) => any): Promise<PaymentInstance>;
  /**
   * Constructs a payment
   *
   * @param sid - The SID of Payments session
   */
  get(sid: string): PaymentContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property bankAccountType - Type of bank account if payment source is ACH.
 * @property chargeAmount - A positive decimal value less than 1,000,000 to charge against the credit card or bank account.
 * @property currency - The currency of the `charge_amount`.
 * @property description - The description can be used to provide more details regarding the transaction.
 * @property idempotencyKey - A unique token that will be used to ensure that multiple API calls with the same information do not result in multiple transactions.
 * @property input - A list of inputs that should be accepted. Currently only `dtmf` is supported.
 * @property minPostalCodeLength - A positive integer that is used to validate the length of the `PostalCode` inputted by the user.
 * @property parameter - A single-level JSON object used to pass custom parameters to payment processors. (Required for ACH payments)
 * @property paymentConnector - This is the unique name corresponding to the Payment Gateway Connector installed in the Twilio Add-ons.
 * @property paymentMethod - Type of payment being captured.
 * @property postalCode - Indicates whether the credit card PostalCode (zip code) is a required piece of payment information that must be provided by the caller.
 * @property securityCode - Indicates whether the credit card security code is a required piece of payment information that must be provided by the caller.
 * @property statusCallback - Provide an absolute or relative URL to receive status updates regarding your Pay session..
 * @property timeout - The number of seconds that <Pay> should wait for the caller to press a digit between each subsequent digit, after the first one, before moving on to validate the digits captured.
 * @property tokenType - Indicates whether the payment method should be tokenized as a `one-time` or `reusable` token.
 * @property validCardTypes - Credit card types separated by space that Pay should accept.
 */
interface PaymentListInstanceCreateOptions {
  bankAccountType?: PaymentBankAccountType;
  chargeAmount?: number;
  currency?: string;
  description?: string;
  idempotencyKey: string;
  input?: string;
  minPostalCodeLength?: number;
  parameter?: object;
  paymentConnector?: string;
  paymentMethod?: PaymentPaymentMethod;
  postalCode?: boolean;
  securityCode?: boolean;
  statusCallback: string;
  timeout?: number;
  tokenType?: PaymentTokenType;
  validCardTypes?: string;
}

interface PaymentPayload extends PaymentResource, Page.TwilioResponsePayload {
}

interface PaymentResource {
  account_sid: string;
  call_sid: string;
  date_created: Date;
  date_updated: Date;
  sid: string;
  uri: string;
}

interface PaymentSolution {
  accountSid?: string;
  callSid?: string;
}


declare class PaymentContext {
  /**
   * Initialize the PaymentContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param accountSid - The SID of the Account that will update the resource
   * @param callSid - The SID of the call that will create the resource.
   * @param sid - The SID of Payments session
   */
  constructor(version: V2010, accountSid: string, callSid: string, sid: string);

  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a PaymentInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts: PaymentInstanceUpdateOptions, callback?: (error: Error | null, items: PaymentInstance) => any): Promise<PaymentInstance>;
}


declare class PaymentInstance extends SerializableClass {
  /**
   * Initialize the PaymentContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param accountSid - The SID of the Account that created the Payments resource.
   * @param callSid - The SID of the Call the resource is associated with.
   * @param sid - The SID of Payments session
   */
  constructor(version: V2010, payload: PaymentPayload, accountSid: string, callSid: string, sid: string);

  private _proxy: PaymentContext;
  accountSid: string;
  callSid: string;
  dateCreated: Date;
  dateUpdated: Date;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a PaymentInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts: PaymentInstanceUpdateOptions, callback?: (error: Error | null, items: PaymentInstance) => any): Promise<PaymentInstance>;
  uri: string;
}


declare class PaymentPage extends Page<V2010, PaymentPayload, PaymentResource, PaymentInstance> {
  /**
   * Initialize the PaymentPage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2010, response: Response<string>, solution: PaymentSolution);

  /**
   * Build an instance of PaymentInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: PaymentPayload): PaymentInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { PaymentBankAccountType, PaymentCapture, PaymentContext, PaymentInstance, PaymentInstanceUpdateOptions, PaymentList, PaymentListInstance, PaymentListInstanceCreateOptions, PaymentPage, PaymentPayload, PaymentPaymentMethod, PaymentResource, PaymentSolution, PaymentStatus, PaymentTokenType }
