/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

type AddressConfigurationAutoCreationType = 'webhook'|'studio'|'default';

type AddressConfigurationMethod = 'GET'|'POST';

type AddressConfigurationType = 'sms'|'whatsapp'|'messenger'|'gbm';

/**
 * Initialize the AddressConfigurationList
 *
 * @param version - Version of the resource
 */
declare function AddressConfigurationList(version: V1): AddressConfigurationListInstance;

/**
 * Options to pass to update
 *
 * @property autoCreation.conversationServiceSid - Conversation Service for the auto-created conversation.
 * @property autoCreation.enabled - Enable/Disable auto-creating conversations for messages to this address
 * @property autoCreation.studioFlowSid - For type `studio`, the studio flow SID where the webhook should be sent to.
 * @property autoCreation.studioRetryCount - For type `studio`, number of times to retry the webhook request
 * @property autoCreation.type - Type of Auto Creation.
 * @property autoCreation.webhookFilters - The list of events, firing webhook event for this Conversation.
 * @property autoCreation.webhookMethod - For type `webhook`, the HTTP method to be used when sending a webhook request.
 * @property autoCreation.webhookUrl - For type `webhook`, the url for the webhook request.
 * @property friendlyName - The human-readable name of this configuration.
 */
interface AddressConfigurationInstanceUpdateOptions {
  autoCreation?: {
    enabled?: boolean;
    type?: AddressConfigurationAutoCreationType;
    conversationServiceSid?: string;
    webhookUrl?: string;
    webhookMethod?: AddressConfigurationMethod;
    webhookFilters?: string | string[];
    studioFlowSid?: string;
    studioRetryCount?: number;
  };
  friendlyName?: string;
}

interface AddressConfigurationListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): AddressConfigurationContext;
  /**
   * create a AddressConfigurationInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: AddressConfigurationListInstanceCreateOptions, callback?: (error: Error | null, item: AddressConfigurationInstance) => any): Promise<AddressConfigurationInstance>;
  /**
   * Streams AddressConfigurationInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: AddressConfigurationInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams AddressConfigurationInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: AddressConfigurationListInstanceEachOptions, callback?: (item: AddressConfigurationInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a address_configuration
   *
   * @param sid - The SID or Address of the Configuration.
   */
  get(sid: string): AddressConfigurationContext;
  /**
   * Retrieve a single target page of AddressConfigurationInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: AddressConfigurationPage) => any): Promise<AddressConfigurationPage>;
  /**
   * Retrieve a single target page of AddressConfigurationInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: AddressConfigurationPage) => any): Promise<AddressConfigurationPage>;
  /**
   * Lists AddressConfigurationInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: AddressConfigurationInstance[]) => any): Promise<AddressConfigurationInstance[]>;
  /**
   * Lists AddressConfigurationInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: AddressConfigurationListInstanceOptions, callback?: (error: Error | null, items: AddressConfigurationInstance[]) => any): Promise<AddressConfigurationInstance[]>;
  /**
   * Retrieve a single page of AddressConfigurationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: AddressConfigurationPage) => any): Promise<AddressConfigurationPage>;
  /**
   * Retrieve a single page of AddressConfigurationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: AddressConfigurationListInstancePageOptions, callback?: (error: Error | null, items: AddressConfigurationPage) => any): Promise<AddressConfigurationPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property address - The unique address to be configured.
 * @property autoCreation.conversationServiceSid - Conversation Service for the auto-created conversation.
 * @property autoCreation.enabled - Enable/Disable auto-creating conversations for messages to this address
 * @property autoCreation.studioFlowSid - For type `studio`, the studio flow SID where the webhook should be sent to.
 * @property autoCreation.studioRetryCount - For type `studio`, number of times to retry the webhook request
 * @property autoCreation.type - Type of Auto Creation.
 * @property autoCreation.webhookFilters - The list of events, firing webhook event for this Conversation.
 * @property autoCreation.webhookMethod - For type `webhook`, the HTTP method to be used when sending a webhook request.
 * @property autoCreation.webhookUrl - For type `webhook`, the url for the webhook request.
 * @property friendlyName - The human-readable name of this configuration.
 * @property type - Type of Address.
 */
interface AddressConfigurationListInstanceCreateOptions {
  address: string;
  autoCreation?: {
    enabled?: boolean;
    type?: AddressConfigurationAutoCreationType;
    conversationServiceSid?: string;
    webhookUrl?: string;
    webhookMethod?: AddressConfigurationMethod;
    webhookFilters?: string | string[];
    studioFlowSid?: string;
    studioRetryCount?: number;
  };
  friendlyName?: string;
  type: AddressConfigurationType;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface AddressConfigurationListInstanceEachOptions {
  callback?: (item: AddressConfigurationInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface AddressConfigurationListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface AddressConfigurationListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface AddressConfigurationPayload extends AddressConfigurationResource, Page.TwilioResponsePayload {
}

interface AddressConfigurationResource {
  account_sid: string;
  address: string;
  auto_creation: object;
  date_created: Date;
  date_updated: Date;
  friendly_name: string;
  sid: string;
  type: string;
  url: string;
}

interface AddressConfigurationSolution {
}


declare class AddressConfigurationContext {
  /**
   * Initialize the AddressConfigurationContext
   *
   * @param version - Version of the resource
   * @param sid - The SID or Address of the Configuration.
   */
  constructor(version: V1, sid: string);

  /**
   * fetch a AddressConfigurationInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: AddressConfigurationInstance) => any): Promise<AddressConfigurationInstance>;
  /**
   * remove a AddressConfigurationInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: AddressConfigurationInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a AddressConfigurationInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: AddressConfigurationInstance) => any): Promise<AddressConfigurationInstance>;
  /**
   * update a AddressConfigurationInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: AddressConfigurationInstanceUpdateOptions, callback?: (error: Error | null, items: AddressConfigurationInstance) => any): Promise<AddressConfigurationInstance>;
}


declare class AddressConfigurationInstance extends SerializableClass {
  /**
   * Initialize the AddressConfigurationContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The SID or Address of the Configuration.
   */
  constructor(version: V1, payload: AddressConfigurationPayload, sid: string);

  private _proxy: AddressConfigurationContext;
  accountSid: string;
  address: string;
  autoCreation: any;
  dateCreated: Date;
  dateUpdated: Date;
  /**
   * fetch a AddressConfigurationInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: AddressConfigurationInstance) => any): Promise<AddressConfigurationInstance>;
  friendlyName: string;
  /**
   * remove a AddressConfigurationInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: AddressConfigurationInstance) => any): Promise<boolean>;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  type: string;
  /**
   * update a AddressConfigurationInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: AddressConfigurationInstance) => any): Promise<AddressConfigurationInstance>;
  /**
   * update a AddressConfigurationInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: AddressConfigurationInstanceUpdateOptions, callback?: (error: Error | null, items: AddressConfigurationInstance) => any): Promise<AddressConfigurationInstance>;
  url: string;
}


declare class AddressConfigurationPage extends Page<V1, AddressConfigurationPayload, AddressConfigurationResource, AddressConfigurationInstance> {
  /**
   * Initialize the AddressConfigurationPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: AddressConfigurationSolution);

  /**
   * Build an instance of AddressConfigurationInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: AddressConfigurationPayload): AddressConfigurationInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { AddressConfigurationAutoCreationType, AddressConfigurationContext, AddressConfigurationInstance, AddressConfigurationInstanceUpdateOptions, AddressConfigurationList, AddressConfigurationListInstance, AddressConfigurationListInstanceCreateOptions, AddressConfigurationListInstanceEachOptions, AddressConfigurationListInstanceOptions, AddressConfigurationListInstancePageOptions, AddressConfigurationMethod, AddressConfigurationPage, AddressConfigurationPayload, AddressConfigurationResource, AddressConfigurationSolution, AddressConfigurationType }
