/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

type UserStateType = 'active'|'deactivated';

/**
 * Initialize the UserList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 */
declare function UserList(version: V1): UserListInstance;

/**
 * Options to pass to update
 *
 * @property avatar - The avatar URL which will be shown in Frontline application
 * @property friendlyName - The string that you assigned to describe the User
 * @property isAvailable - Whether the User is available for new conversations
 * @property state - Current state of this user
 */
interface UserInstanceUpdateOptions {
  avatar?: string;
  friendlyName?: string;
  isAvailable?: boolean;
  state?: UserStateType;
}

interface UserListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): UserContext;
  /**
   * Constructs a user
   *
   * @param sid - The SID of the User resource to fetch
   */
  get(sid: string): UserContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface UserPayload extends UserResource, Page.TwilioResponsePayload {
}

interface UserResource {
  avatar: string;
  friendly_name: string;
  identity: string;
  is_available: boolean;
  sid: string;
  state: UserStateType;
  url: string;
}

interface UserSolution {
}


declare class UserContext {
  /**
   * Initialize the UserContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param sid - The SID of the User resource to fetch
   */
  constructor(version: V1, sid: string);

  /**
   * fetch a UserInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: UserInstance) => any): Promise<UserInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a UserInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: UserInstance) => any): Promise<UserInstance>;
  /**
   * update a UserInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: UserInstanceUpdateOptions, callback?: (error: Error | null, items: UserInstance) => any): Promise<UserInstance>;
}


declare class UserInstance extends SerializableClass {
  /**
   * Initialize the UserContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The SID of the User resource to fetch
   */
  constructor(version: V1, payload: UserPayload, sid: string);

  private _proxy: UserContext;
  avatar: string;
  /**
   * fetch a UserInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: UserInstance) => any): Promise<UserInstance>;
  friendlyName: string;
  identity: string;
  isAvailable: boolean;
  sid: string;
  state: UserStateType;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a UserInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: UserInstance) => any): Promise<UserInstance>;
  /**
   * update a UserInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: UserInstanceUpdateOptions, callback?: (error: Error | null, items: UserInstance) => any): Promise<UserInstance>;
  url: string;
}


declare class UserPage extends Page<V1, UserPayload, UserResource, UserInstance> {
  /**
   * Initialize the UserPage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: UserSolution);

  /**
   * Build an instance of UserInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: UserPayload): UserInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { UserContext, UserInstance, UserInstanceUpdateOptions, UserList, UserListInstance, UserPage, UserPayload, UserResource, UserSolution, UserStateType }
