'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../base/deserialize');  /* jshint ignore:line */
var serialize = require('../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var AnnotationList;
var AnnotationPage;
var AnnotationInstance;
var AnnotationContext;

/* jshint ignore:start */
/**
 * Initialize the AnnotationList
 *
 * @constructor Twilio.Insights.V1.AnnotationList
 *
 * @param {Twilio.Insights.V1} version - Version of the resource
 */
/* jshint ignore:end */
AnnotationList = function AnnotationList(version) {
  /* jshint ignore:start */
  /**
   * @function annotation
   * @memberof Twilio.Insights.V1#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Insights.V1.AnnotationContext}
   */
  /* jshint ignore:end */
  function AnnotationListInstance(sid) {
    return AnnotationListInstance.get(sid);
  }

  AnnotationListInstance._version = version;
  // Path Solution
  AnnotationListInstance._solution = {};
  /* jshint ignore:start */
  /**
   * Constructs a annotation
   *
   * @function get
   * @memberof Twilio.Insights.V1.AnnotationList#
   *
   * @param {string} callSid - The call_sid
   *
   * @returns {Twilio.Insights.V1.AnnotationContext}
   */
  /* jshint ignore:end */
  AnnotationListInstance.get = function get(callSid) {
    return new AnnotationContext(this._version, callSid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Insights.V1.AnnotationList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  AnnotationListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  AnnotationListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return AnnotationListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the AnnotationPage
 *
 * @constructor Twilio.Insights.V1.AnnotationPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {AnnotationSolution} solution - Path solution
 *
 * @returns AnnotationPage
 */
/* jshint ignore:end */
AnnotationPage = function AnnotationPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(AnnotationPage.prototype, Page.prototype);
AnnotationPage.prototype.constructor = AnnotationPage;

/* jshint ignore:start */
/**
 * Build an instance of AnnotationInstance
 *
 * @function getInstance
 * @memberof Twilio.Insights.V1.AnnotationPage#
 *
 * @param {AnnotationPayload} payload - Payload response from the API
 *
 * @returns AnnotationInstance
 */
/* jshint ignore:end */
AnnotationPage.prototype.getInstance = function getInstance(payload) {
  return new AnnotationInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Insights.V1.AnnotationPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
AnnotationPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

AnnotationPage.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the AnnotationContext
 *
 * @constructor Twilio.Insights.V1.AnnotationInstance
 *
 * @property {string} callSid - The call_sid
 * @property {string} accountSid - The account_sid
 * @property {annotation.answered_by} answeredBy - The answered_by
 * @property {annotation.connectivity_issue} connectivityIssue -
 *          The connectivity_issue
 * @property {string} qualityIssues - The quality_issues
 * @property {boolean} spam - The spam
 * @property {number} callScore - The call_score
 * @property {string} comment - The comment
 * @property {string} incident - The incident
 * @property {string} url - The url
 *
 * @param {V1} version - Version of the resource
 * @param {AnnotationPayload} payload - The instance payload
 * @param {sid} callSid - The call_sid
 */
/* jshint ignore:end */
AnnotationInstance = function AnnotationInstance(version, payload, callSid) {
  this._version = version;

  // Marshaled Properties
  this.callSid = payload.call_sid; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.answeredBy = payload.answered_by; // jshint ignore:line
  this.connectivityIssue = payload.connectivity_issue; // jshint ignore:line
  this.qualityIssues = payload.quality_issues; // jshint ignore:line
  this.spam = payload.spam; // jshint ignore:line
  this.callScore = deserialize.integer(payload.call_score); // jshint ignore:line
  this.comment = payload.comment; // jshint ignore:line
  this.incident = payload.incident; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {callSid: callSid || this.callSid, };
};

Object.defineProperty(AnnotationInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new AnnotationContext(this._version, this._solution.callSid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * update a AnnotationInstance
 *
 * @function update
 * @memberof Twilio.Insights.V1.AnnotationInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {annotation.answered_by} [opts.answeredBy] - The answered_by
 * @param {annotation.connectivity_issue} [opts.connectivityIssue] -
 *          The connectivity_issue
 * @param {string} [opts.qualityIssues] - The quality_issues
 * @param {boolean} [opts.spam] - The spam
 * @param {number} [opts.callScore] - The call_score
 * @param {string} [opts.comment] - The comment
 * @param {string} [opts.incident] - The incident
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AnnotationInstance
 */
/* jshint ignore:end */
AnnotationInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * fetch a AnnotationInstance
 *
 * @function fetch
 * @memberof Twilio.Insights.V1.AnnotationInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AnnotationInstance
 */
/* jshint ignore:end */
AnnotationInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Insights.V1.AnnotationInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
AnnotationInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

AnnotationInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the AnnotationContext
 *
 * @constructor Twilio.Insights.V1.AnnotationContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid} callSid - The call_sid
 */
/* jshint ignore:end */
AnnotationContext = function AnnotationContext(version, callSid) {
  this._version = version;

  // Path Solution
  this._solution = {callSid: callSid, };
  this._uri = `/Voice/${callSid}/Annotation`;
};

/* jshint ignore:start */
/**
 * update a AnnotationInstance
 *
 * @function update
 * @memberof Twilio.Insights.V1.AnnotationContext#
 *
 * @param {object} [opts] - Options for request
 * @param {annotation.answered_by} [opts.answeredBy] - The answered_by
 * @param {annotation.connectivity_issue} [opts.connectivityIssue] -
 *          The connectivity_issue
 * @param {string} [opts.qualityIssues] - The quality_issues
 * @param {boolean} [opts.spam] - The spam
 * @param {number} [opts.callScore] - The call_score
 * @param {string} [opts.comment] - The comment
 * @param {string} [opts.incident] - The incident
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AnnotationInstance
 */
/* jshint ignore:end */
AnnotationContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'AnsweredBy': _.get(opts, 'answeredBy'),
    'ConnectivityIssue': _.get(opts, 'connectivityIssue'),
    'QualityIssues': _.get(opts, 'qualityIssues'),
    'Spam': serialize.bool(_.get(opts, 'spam')),
    'CallScore': _.get(opts, 'callScore'),
    'Comment': _.get(opts, 'comment'),
    'Incident': _.get(opts, 'incident')
  });

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new AnnotationInstance(this._version, payload, this._solution.callSid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * fetch a AnnotationInstance
 *
 * @function fetch
 * @memberof Twilio.Insights.V1.AnnotationContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AnnotationInstance
 */
/* jshint ignore:end */
AnnotationContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new AnnotationInstance(this._version, payload, this._solution.callSid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Insights.V1.AnnotationContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
AnnotationContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

AnnotationContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  AnnotationList: AnnotationList,
  AnnotationPage: AnnotationPage,
  AnnotationInstance: AnnotationInstance,
  AnnotationContext: AnnotationContext
};
