/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import Wireless = require('../Wireless');
import { SerializableClass } from '../../../interfaces';
import { UsageList } from './sim/usage';
import { UsageListInstance } from './sim/usage';

/**
 * Initialize the SimList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 */
declare function SimList(version: Wireless): SimListInstance;

/**
 * Options to pass to update
 *
 * @property callbackMethod - The callback_method
 * @property callbackUrl - The callback_url
 * @property commandsCallbackMethod - The commands_callback_method
 * @property commandsCallbackUrl - The commands_callback_url
 * @property friendlyName - The friendly_name
 * @property ratePlan - The rate_plan
 * @property smsFallbackMethod - The sms_fallback_method
 * @property smsFallbackUrl - The sms_fallback_url
 * @property smsMethod - The sms_method
 * @property smsUrl - The sms_url
 * @property status - The status
 * @property uniqueName - The unique_name
 * @property voiceFallbackMethod - The voice_fallback_method
 * @property voiceFallbackUrl - The voice_fallback_url
 * @property voiceMethod - The voice_method
 * @property voiceUrl - The voice_url
 */
interface SimInstanceUpdateOptions {
  callbackMethod?: string;
  callbackUrl?: string;
  commandsCallbackMethod?: string;
  commandsCallbackUrl?: string;
  friendlyName?: string;
  ratePlan?: string;
  smsFallbackMethod?: string;
  smsFallbackUrl?: string;
  smsMethod?: string;
  smsUrl?: string;
  status?: string;
  uniqueName?: string;
  voiceFallbackMethod?: string;
  voiceFallbackUrl?: string;
  voiceMethod?: string;
  voiceUrl?: string;
}

interface SimListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): SimContext;
  /**
   * Streams SimInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: SimInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams SimInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: SimListInstanceEachOptions, callback?: (item: SimInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a sim
   *
   * @param sid - The sid
   */
  get(sid: string): SimContext;
  /**
   * Retrieve a single target page of SimInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: SimPage) => any): Promise<SimPage>;
  /**
   * Retrieve a single target page of SimInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: SimPage) => any): Promise<SimPage>;
  /**
   * Lists SimInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: SimInstance[]) => any): Promise<SimInstance[]>;
  /**
   * Lists SimInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: SimListInstanceOptions, callback?: (error: Error | null, items: SimInstance[]) => any): Promise<SimInstance[]>;
  /**
   * Retrieve a single page of SimInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: SimPage) => any): Promise<SimPage>;
  /**
   * Retrieve a single page of SimInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: SimListInstancePageOptions, callback?: (error: Error | null, items: SimPage) => any): Promise<SimPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property eId - The e_id
 * @property iccid - The iccid
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 * @property ratePlan - The rate_plan
 * @property simRegistrationCode - The sim_registration_code
 * @property status - The status
 */
interface SimListInstanceEachOptions {
  callback?: (item: SimInstance, done: (err?: Error) => void) => void;
  done?: Function;
  eId?: string;
  iccid?: string;
  limit?: number;
  pageSize?: number;
  ratePlan?: string;
  simRegistrationCode?: string;
  status?: string;
}

/**
 * Options to pass to list
 *
 * @property eId - The e_id
 * @property iccid - The iccid
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 * @property ratePlan - The rate_plan
 * @property simRegistrationCode - The sim_registration_code
 * @property status - The status
 */
interface SimListInstanceOptions {
  eId?: string;
  iccid?: string;
  limit?: number;
  pageSize?: number;
  ratePlan?: string;
  simRegistrationCode?: string;
  status?: string;
}

/**
 * Options to pass to page
 *
 * @property eId - The e_id
 * @property iccid - The iccid
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 * @property ratePlan - The rate_plan
 * @property simRegistrationCode - The sim_registration_code
 * @property status - The status
 */
interface SimListInstancePageOptions {
  eId?: string;
  iccid?: string;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
  ratePlan?: string;
  simRegistrationCode?: string;
  status?: string;
}

interface SimPayload extends SimResource, Page.TwilioResponsePayload {
}

interface SimResource {
  account_sid: string;
  commands_callback_method: string;
  commands_callback_url: string;
  date_created: Date;
  date_updated: Date;
  e_id: string;
  friendly_name: string;
  iccid: string;
  links: string;
  rate_plan_sid: string;
  sid: string;
  sms_fallback_method: string;
  sms_fallback_url: string;
  sms_method: string;
  sms_url: string;
  status: string;
  unique_name: string;
  url: string;
  voice_fallback_method: string;
  voice_fallback_url: string;
  voice_method: string;
  voice_url: string;
}

interface SimSolution {
}


declare class SimContext {
  /**
   * Initialize the SimContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param sid - The sid
   */
  constructor(version: Wireless, sid: string);

  /**
   * fetch a SimInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: SimInstance) => any): Promise<SimInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a SimInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: SimInstance) => any): Promise<SimInstance>;
  /**
   * update a SimInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: SimInstanceUpdateOptions, callback?: (error: Error | null, items: SimInstance) => any): Promise<SimInstance>;
  usage: UsageListInstance;
}


declare class SimInstance extends SerializableClass {
  /**
   * Initialize the SimContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The sid
   */
  constructor(version: Wireless, payload: SimPayload, sid: string);

  private _proxy: SimContext;
  accountSid: string;
  commandsCallbackMethod: string;
  commandsCallbackUrl: string;
  dateCreated: Date;
  dateUpdated: Date;
  eId: string;
  /**
   * fetch a SimInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: SimInstance) => any): Promise<SimInstance>;
  friendlyName: string;
  iccid: string;
  links: string;
  ratePlanSid: string;
  sid: string;
  smsFallbackMethod: string;
  smsFallbackUrl: string;
  smsMethod: string;
  smsUrl: string;
  status: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  uniqueName: string;
  /**
   * update a SimInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: SimInstance) => any): Promise<SimInstance>;
  /**
   * update a SimInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: SimInstanceUpdateOptions, callback?: (error: Error | null, items: SimInstance) => any): Promise<SimInstance>;
  url: string;
  /**
   * Access the usage
   */
  usage(): UsageListInstance;
  voiceFallbackMethod: string;
  voiceFallbackUrl: string;
  voiceMethod: string;
  voiceUrl: string;
}


declare class SimPage extends Page<Wireless, SimPayload, SimResource, SimInstance> {
  /**
   * Initialize the SimPage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: Wireless, response: Response<string>, solution: SimSolution);

  /**
   * Build an instance of SimInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: SimPayload): SimInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { SimContext, SimInstance, SimInstanceUpdateOptions, SimList, SimListInstance, SimListInstanceEachOptions, SimListInstanceOptions, SimListInstancePageOptions, SimPage, SimPayload, SimResource, SimSolution }
