'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../../base/Page');  /* jshint ignore:line */
var serialize = require(
    '../../../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../../../base/values');  /* jshint ignore:line */

var WorkflowStatisticsList;
var WorkflowStatisticsPage;
var WorkflowStatisticsInstance;
var WorkflowStatisticsContext;

/* jshint ignore:start */
/**
 * Initialize the WorkflowStatisticsList
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowStatisticsList
 *
 * @param {Twilio.Taskrouter.V1} version - Version of the resource
 * @param {string} workspaceSid -
 *          The SID of the Workspace that contains the Workflow
 * @param {string} workflowSid -
 *          Returns the list of Tasks that are being controlled by the Workflow with the specified SID value
 */
/* jshint ignore:end */
WorkflowStatisticsList = function WorkflowStatisticsList(version, workspaceSid,
                                                          workflowSid) {
  /* jshint ignore:start */
  /**
   * @function statistics
   * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowStatisticsContext}
   */
  /* jshint ignore:end */
  function WorkflowStatisticsListInstance(sid) {
    return WorkflowStatisticsListInstance.get(sid);
  }

  WorkflowStatisticsListInstance._version = version;
  // Path Solution
  WorkflowStatisticsListInstance._solution = {workspaceSid: workspaceSid, workflowSid: workflowSid};
  /* jshint ignore:start */
  /**
   * Constructs a workflow_statistics
   *
   * @function get
   * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowStatisticsList#
   *
   * @returns {Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowStatisticsContext}
   */
  /* jshint ignore:end */
  WorkflowStatisticsListInstance.get = function get() {
    return new WorkflowStatisticsContext(
      this._version,
      this._solution.workspaceSid,
      this._solution.workflowSid
    );
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowStatisticsList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  WorkflowStatisticsListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  WorkflowStatisticsListInstance[util.inspect.custom] = function inspect(depth,
      options) {
    return util.inspect(this.toJSON(), options);
  };

  return WorkflowStatisticsListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the WorkflowStatisticsPage
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowStatisticsPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {WorkflowStatisticsSolution} solution - Path solution
 *
 * @returns WorkflowStatisticsPage
 */
/* jshint ignore:end */
WorkflowStatisticsPage = function WorkflowStatisticsPage(version, response,
                                                          solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(WorkflowStatisticsPage.prototype, Page.prototype);
WorkflowStatisticsPage.prototype.constructor = WorkflowStatisticsPage;

/* jshint ignore:start */
/**
 * Build an instance of WorkflowStatisticsInstance
 *
 * @function getInstance
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowStatisticsPage#
 *
 * @param {WorkflowStatisticsPayload} payload - Payload response from the API
 *
 * @returns WorkflowStatisticsInstance
 */
/* jshint ignore:end */
WorkflowStatisticsPage.prototype.getInstance = function getInstance(payload) {
  return new WorkflowStatisticsInstance(
    this._version,
    payload,
    this._solution.workspaceSid,
    this._solution.workflowSid
  );
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowStatisticsPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
WorkflowStatisticsPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

WorkflowStatisticsPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the WorkflowStatisticsContext
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowStatisticsInstance
 *
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {object} cumulative -
 *          An object that contains the cumulative statistics for the Workflow
 * @property {object} realtime -
 *          An object that contains the real-time statistics for the Workflow
 * @property {string} workflowSid -
 *          Returns the list of Tasks that are being controlled by the Workflow with the specified SID value
 * @property {string} workspaceSid -
 *          The SID of the Workspace that contains the Workflow
 * @property {string} url - The absolute URL of the Workflow statistics resource
 *
 * @param {V1} version - Version of the resource
 * @param {WorkflowStatisticsPayload} payload - The instance payload
 * @param {sid} workspaceSid - The SID of the Workspace that contains the Workflow
 * @param {sid} workflowSid -
 *          Returns the list of Tasks that are being controlled by the Workflow with the specified SID value
 */
/* jshint ignore:end */
WorkflowStatisticsInstance = function WorkflowStatisticsInstance(version,
    payload, workspaceSid, workflowSid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.cumulative = payload.cumulative; // jshint ignore:line
  this.realtime = payload.realtime; // jshint ignore:line
  this.workflowSid = payload.workflow_sid; // jshint ignore:line
  this.workspaceSid = payload.workspace_sid; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {workspaceSid: workspaceSid, workflowSid: workflowSid, };
};

Object.defineProperty(WorkflowStatisticsInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new WorkflowStatisticsContext(
          this._version,
          this._solution.workspaceSid,
          this._solution.workflowSid
        );
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a WorkflowStatisticsInstance
 *
 * @function fetch
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowStatisticsInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {number} [opts.minutes] -
 *          Only calculate statistics since this many minutes in the past
 * @param {Date} [opts.startDate] -
 *          Only calculate statistics from on or after this date
 * @param {Date} [opts.endDate] -
 *          Only calculate statistics from this date and time and earlier
 * @param {string} [opts.taskChannel] -
 *          Only calculate real-time statistics on this TaskChannel.
 * @param {string} [opts.splitByWaitTime] -
 *          A comma separated list of values that describes the thresholds to calculate statistics on
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed WorkflowStatisticsInstance
 */
/* jshint ignore:end */
WorkflowStatisticsInstance.prototype.fetch = function fetch(opts, callback) {
  return this._proxy.fetch(opts, callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowStatisticsInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
WorkflowStatisticsInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

WorkflowStatisticsInstance.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the WorkflowStatisticsContext
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowStatisticsContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid} workspaceSid - The SID of the Workspace with the Workflow to fetch
 * @param {sid} workflowSid -
 *          Returns the list of Tasks that are being controlled by the Workflow with the specified SID value
 */
/* jshint ignore:end */
WorkflowStatisticsContext = function WorkflowStatisticsContext(version,
    workspaceSid, workflowSid) {
  this._version = version;

  // Path Solution
  this._solution = {workspaceSid: workspaceSid, workflowSid: workflowSid, };
  this._uri = `/Workspaces/${workspaceSid}/Workflows/${workflowSid}/Statistics`;
};

/* jshint ignore:start */
/**
 * fetch a WorkflowStatisticsInstance
 *
 * @function fetch
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowStatisticsContext#
 *
 * @param {object} [opts] - Options for request
 * @param {number} [opts.minutes] -
 *          Only calculate statistics since this many minutes in the past
 * @param {Date} [opts.startDate] -
 *          Only calculate statistics from on or after this date
 * @param {Date} [opts.endDate] -
 *          Only calculate statistics from this date and time and earlier
 * @param {string} [opts.taskChannel] -
 *          Only calculate real-time statistics on this TaskChannel.
 * @param {string} [opts.splitByWaitTime] -
 *          A comma separated list of values that describes the thresholds to calculate statistics on
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed WorkflowStatisticsInstance
 */
/* jshint ignore:end */
WorkflowStatisticsContext.prototype.fetch = function fetch(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'Minutes': _.get(opts, 'minutes'),
    'StartDate': serialize.iso8601DateTime(_.get(opts, 'startDate')),
    'EndDate': serialize.iso8601DateTime(_.get(opts, 'endDate')),
    'TaskChannel': _.get(opts, 'taskChannel'),
    'SplitByWaitTime': _.get(opts, 'splitByWaitTime')
  });

  var promise = this._version.fetch({uri: this._uri, method: 'GET', params: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new WorkflowStatisticsInstance(
      this._version,
      payload,
      this._solution.workspaceSid,
      this._solution.workflowSid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.WorkflowContext.WorkflowStatisticsContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
WorkflowStatisticsContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

WorkflowStatisticsContext.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  WorkflowStatisticsList: WorkflowStatisticsList,
  WorkflowStatisticsPage: WorkflowStatisticsPage,
  WorkflowStatisticsInstance: WorkflowStatisticsInstance,
  WorkflowStatisticsContext: WorkflowStatisticsContext
};
