'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var _ = require('lodash');  /* jshint ignore:line */
var Domain = require('../base/Domain');  /* jshint ignore:line */
var V2010 = require('./api/V2010');  /* jshint ignore:line */


/* jshint ignore:start */
/**
 * Initialize api domain
 *
 * @constructor Twilio.Api
 *
 * @property {Twilio.Api.V2010} v2010 - v2010 version
 * @property {Twilio.Api.V2010.AccountContext} account - Main account resource
 * @property {Twilio.Api.V2010.AccountList} accounts - accounts resource
 * @property {Twilio.Api.V2010.AccountContext.AddressList} addresses -
 *          addresses resource
 * @property {Twilio.Api.V2010.AccountContext.ApplicationList} applications -
 *          applications resource
 * @property {Twilio.Api.V2010.AccountContext.AuthorizedConnectAppList} authorizedConnectApps -
 *          authorizedConnectApps resource
 * @property {Twilio.Api.V2010.AccountContext.AvailablePhoneNumberCountryList} availablePhoneNumbers -
 *          availablePhoneNumbers resource
 * @property {Twilio.Api.V2010.AccountContext.BalanceList} balance -
 *          balance resource
 * @property {Twilio.Api.V2010.AccountContext.CallList} calls - calls resource
 * @property {Twilio.Api.V2010.AccountContext.ConferenceList} conferences -
 *          conferences resource
 * @property {Twilio.Api.V2010.AccountContext.ConnectAppList} connectApps -
 *          connectApps resource
 * @property {Twilio.Api.V2010.AccountContext.IncomingPhoneNumberList} incomingPhoneNumbers -
 *          incomingPhoneNumbers resource
 * @property {Twilio.Api.V2010.AccountContext.KeyList} keys - keys resource
 * @property {Twilio.Api.V2010.AccountContext.MessageList} messages -
 *          messages resource
 * @property {Twilio.Api.V2010.AccountContext.NewKeyList} newKeys -
 *          newKeys resource
 * @property {Twilio.Api.V2010.AccountContext.NewSigningKeyList} newSigningKeys -
 *          newSigningKeys resource
 * @property {Twilio.Api.V2010.AccountContext.NotificationList} notifications -
 *          notifications resource
 * @property {Twilio.Api.V2010.AccountContext.OutgoingCallerIdList} outgoingCallerIds -
 *          outgoingCallerIds resource
 * @property {Twilio.Api.V2010.AccountContext.QueueList} queues - queues resource
 * @property {Twilio.Api.V2010.AccountContext.RecordingList} recordings -
 *          recordings resource
 * @property {Twilio.Api.V2010.AccountContext.SigningKeyList} signingKeys -
 *          signingKeys resource
 * @property {Twilio.Api.V2010.AccountContext.SipList} sip - sip resource
 * @property {Twilio.Api.V2010.AccountContext.ShortCodeList} shortCodes -
 *          shortCodes resource
 * @property {Twilio.Api.V2010.AccountContext.TokenList} tokens - tokens resource
 * @property {Twilio.Api.V2010.AccountContext.TranscriptionList} transcriptions -
 *          transcriptions resource
 * @property {Twilio.Api.V2010.AccountContext.UsageList} usage - usage resource
 * @property {Twilio.Api.V2010.AccountContext.ValidationRequestList} validationRequests -
 *          validationRequests resource
 *
 * @param {Twilio} twilio - The twilio client
 */
/* jshint ignore:end */
function Api(twilio) {
  Domain.prototype.constructor.call(this, twilio, 'https://api.twilio.com');

  // Versions
  this._v2010 = undefined;
}

_.extend(Api.prototype, Domain.prototype);
Api.prototype.constructor = Api;

Object.defineProperty(Api.prototype,
  'v2010', {
    get: function() {
      this._v2010 = this._v2010 || new V2010(this);
      return this._v2010;
    }
});

Object.defineProperty(Api.prototype,
  'account', {
    get: function() {
      return this.v2010.account;
    }
});

Object.defineProperty(Api.prototype,
  'accounts', {
    get: function() {
      return this.v2010.accounts;
    }
});

Object.defineProperty(Api.prototype,
  'addresses', {
    get: function() {
      return this.account.addresses;
    }
});

Object.defineProperty(Api.prototype,
  'applications', {
    get: function() {
      return this.account.applications;
    }
});

Object.defineProperty(Api.prototype,
  'authorizedConnectApps', {
    get: function() {
      return this.account.authorizedConnectApps;
    }
});

Object.defineProperty(Api.prototype,
  'availablePhoneNumbers', {
    get: function() {
      return this.account.availablePhoneNumbers;
    }
});

Object.defineProperty(Api.prototype,
  'balance', {
    get: function() {
      return this.account.balance;
    }
});

Object.defineProperty(Api.prototype,
  'calls', {
    get: function() {
      return this.account.calls;
    }
});

Object.defineProperty(Api.prototype,
  'conferences', {
    get: function() {
      return this.account.conferences;
    }
});

Object.defineProperty(Api.prototype,
  'connectApps', {
    get: function() {
      return this.account.connectApps;
    }
});

Object.defineProperty(Api.prototype,
  'incomingPhoneNumbers', {
    get: function() {
      return this.account.incomingPhoneNumbers;
    }
});

Object.defineProperty(Api.prototype,
  'keys', {
    get: function() {
      return this.account.keys;
    }
});

Object.defineProperty(Api.prototype,
  'messages', {
    get: function() {
      return this.account.messages;
    }
});

Object.defineProperty(Api.prototype,
  'newKeys', {
    get: function() {
      return this.account.newKeys;
    }
});

Object.defineProperty(Api.prototype,
  'newSigningKeys', {
    get: function() {
      return this.account.newSigningKeys;
    }
});

Object.defineProperty(Api.prototype,
  'notifications', {
    get: function() {
      return this.account.notifications;
    }
});

Object.defineProperty(Api.prototype,
  'outgoingCallerIds', {
    get: function() {
      return this.account.outgoingCallerIds;
    }
});

Object.defineProperty(Api.prototype,
  'queues', {
    get: function() {
      return this.account.queues;
    }
});

Object.defineProperty(Api.prototype,
  'recordings', {
    get: function() {
      return this.account.recordings;
    }
});

Object.defineProperty(Api.prototype,
  'signingKeys', {
    get: function() {
      return this.account.signingKeys;
    }
});

Object.defineProperty(Api.prototype,
  'sip', {
    get: function() {
      return this.account.sip;
    }
});

Object.defineProperty(Api.prototype,
  'shortCodes', {
    get: function() {
      return this.account.shortCodes;
    }
});

Object.defineProperty(Api.prototype,
  'tokens', {
    get: function() {
      return this.account.tokens;
    }
});

Object.defineProperty(Api.prototype,
  'transcriptions', {
    get: function() {
      return this.account.transcriptions;
    }
});

Object.defineProperty(Api.prototype,
  'usage', {
    get: function() {
      return this.account.usage;
    }
});

Object.defineProperty(Api.prototype,
  'validationRequests', {
    get: function() {
      return this.account.validationRequests;
    }
});

module.exports = Api;
