/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the PlaybackGrantList
 *
 * @param version - Version of the resource
 * @param sid - The unique string that identifies the PlayerStreamer associated with this PlaybackGrant.
 */
declare function PlaybackGrantList(version: V1, sid: string): PlaybackGrantListInstance;

/**
 * Options to pass to create
 *
 * @property accessControlAllowOrigin - The full URL that is authorized to play back the livestream
 * @property ttl - The time to live of the PlaybackGrant
 */
interface PlaybackGrantInstanceCreateOptions {
  accessControlAllowOrigin?: string;
  ttl?: number;
}

interface PlaybackGrantListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): PlaybackGrantContext;
  /**
   * Constructs a playback_grant
   */
  get(): PlaybackGrantContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface PlaybackGrantPayload extends PlaybackGrantResource, Page.TwilioResponsePayload {
}

interface PlaybackGrantResource {
  account_sid: string;
  date_created: Date;
  grant: object;
  sid: string;
  url: string;
}

interface PlaybackGrantSolution {
  sid?: string;
}


declare class PlaybackGrantContext {
  /**
   * Initialize the PlaybackGrantContext
   *
   * @param version - Version of the resource
   * @param sid - The SID that identifies the resource to fetch
   */
  constructor(version: V1, sid: string);

  /**
   * create a PlaybackGrantInstance
   *
   * @param callback - Callback to handle processed record
   */
  create(callback?: (error: Error | null, item: PlaybackGrantInstance) => any): Promise<PlaybackGrantInstance>;
  /**
   * create a PlaybackGrantInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts?: PlaybackGrantInstanceCreateOptions, callback?: (error: Error | null, item: PlaybackGrantInstance) => any): Promise<PlaybackGrantInstance>;
  /**
   * fetch a PlaybackGrantInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: PlaybackGrantInstance) => any): Promise<PlaybackGrantInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class PlaybackGrantInstance extends SerializableClass {
  /**
   * Initialize the PlaybackGrantContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The unique string that identifies the PlayerStreamer associated with this PlaybackGrant.
   */
  constructor(version: V1, payload: PlaybackGrantPayload, sid: string);

  private _proxy: PlaybackGrantContext;
  accountSid: string;
  /**
   * create a PlaybackGrantInstance
   *
   * @param callback - Callback to handle processed record
   */
  create(callback?: (error: Error | null, items: PlaybackGrantInstance) => any): Promise<PlaybackGrantInstance>;
  /**
   * create a PlaybackGrantInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts?: PlaybackGrantInstanceCreateOptions, callback?: (error: Error | null, items: PlaybackGrantInstance) => any): Promise<PlaybackGrantInstance>;
  dateCreated: Date;
  /**
   * fetch a PlaybackGrantInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: PlaybackGrantInstance) => any): Promise<PlaybackGrantInstance>;
  grant: any;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class PlaybackGrantPage extends Page<V1, PlaybackGrantPayload, PlaybackGrantResource, PlaybackGrantInstance> {
  /**
   * Initialize the PlaybackGrantPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: PlaybackGrantSolution);

  /**
   * Build an instance of PlaybackGrantInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: PlaybackGrantPayload): PlaybackGrantInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { PlaybackGrantContext, PlaybackGrantInstance, PlaybackGrantInstanceCreateOptions, PlaybackGrantList, PlaybackGrantListInstance, PlaybackGrantPage, PlaybackGrantPayload, PlaybackGrantResource, PlaybackGrantSolution }
