'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var AvailableAddOnExtensionList = require(
    './availableAddOn/availableAddOnExtension').AvailableAddOnExtensionList;
var Page = require('../../../base/Page');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var AvailableAddOnList;
var AvailableAddOnPage;
var AvailableAddOnInstance;
var AvailableAddOnContext;

/* jshint ignore:start */
/**
 * Initialize the AvailableAddOnList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Marketplace.AvailableAddOnList
 *
 * @param {Twilio.Preview.Marketplace} version - Version of the resource
 */
/* jshint ignore:end */
AvailableAddOnList = function AvailableAddOnList(version) {
  /* jshint ignore:start */
  /**
   * @function availableAddOns
   * @memberof Twilio.Preview.Marketplace#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Preview.Marketplace.AvailableAddOnContext}
   */
  /* jshint ignore:end */
  function AvailableAddOnListInstance(sid) {
    return AvailableAddOnListInstance.get(sid);
  }

  AvailableAddOnListInstance._version = version;
  // Path Solution
  AvailableAddOnListInstance._solution = {};
  AvailableAddOnListInstance._uri = `/AvailableAddOns`;
  /* jshint ignore:start */
  /**
   * Streams AvailableAddOnInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Preview.Marketplace.AvailableAddOnList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  AvailableAddOnListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        } else {
          onComplete();
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists AvailableAddOnInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Preview.Marketplace.AvailableAddOnList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  AvailableAddOnListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of AvailableAddOnInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Preview.Marketplace.AvailableAddOnList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  AvailableAddOnListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new AvailableAddOnPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of AvailableAddOnInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Preview.Marketplace.AvailableAddOnList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  AvailableAddOnListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new AvailableAddOnPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a available_add_on
   *
   * @function get
   * @memberof Twilio.Preview.Marketplace.AvailableAddOnList#
   *
   * @param {string} sid - The SID of the AvailableAddOn resource to fetch
   *
   * @returns {Twilio.Preview.Marketplace.AvailableAddOnContext}
   */
  /* jshint ignore:end */
  AvailableAddOnListInstance.get = function get(sid) {
    return new AvailableAddOnContext(this._version, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Preview.Marketplace.AvailableAddOnList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  AvailableAddOnListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  AvailableAddOnListInstance[util.inspect.custom] = function inspect(depth,
      options) {
    return util.inspect(this.toJSON(), options);
  };

  return AvailableAddOnListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the AvailableAddOnPage
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Marketplace.AvailableAddOnPage
 *
 * @param {Marketplace} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {AvailableAddOnSolution} solution - Path solution
 *
 * @returns AvailableAddOnPage
 */
/* jshint ignore:end */
AvailableAddOnPage = function AvailableAddOnPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(AvailableAddOnPage.prototype, Page.prototype);
AvailableAddOnPage.prototype.constructor = AvailableAddOnPage;

/* jshint ignore:start */
/**
 * Build an instance of AvailableAddOnInstance
 *
 * @function getInstance
 * @memberof Twilio.Preview.Marketplace.AvailableAddOnPage#
 *
 * @param {AvailableAddOnPayload} payload - Payload response from the API
 *
 * @returns AvailableAddOnInstance
 */
/* jshint ignore:end */
AvailableAddOnPage.prototype.getInstance = function getInstance(payload) {
  return new AvailableAddOnInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Marketplace.AvailableAddOnPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
AvailableAddOnPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

AvailableAddOnPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the AvailableAddOnContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Marketplace.AvailableAddOnInstance
 *
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} friendlyName -
 *          The string that you assigned to describe the resource
 * @property {string} description -
 *          A short description of the Add-on's functionality
 * @property {string} pricingType - How customers are charged for using this Add-on
 * @property {object} configurationSchema -
 *          The JSON object with the configuration that must be provided when installing a given Add-on
 * @property {string} url - The absolute URL of the resource
 * @property {string} links - The URLs of related resources
 *
 * @param {Marketplace} version - Version of the resource
 * @param {AvailableAddOnPayload} payload - The instance payload
 * @param {sid} sid - The SID of the AvailableAddOn resource to fetch
 */
/* jshint ignore:end */
AvailableAddOnInstance = function AvailableAddOnInstance(version, payload, sid)
                                                          {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.friendlyName = payload.friendly_name; // jshint ignore:line
  this.description = payload.description; // jshint ignore:line
  this.pricingType = payload.pricing_type; // jshint ignore:line
  this.configurationSchema = payload.configuration_schema; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.links = payload.links; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {sid: sid || this.sid, };
};

Object.defineProperty(AvailableAddOnInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new AvailableAddOnContext(this._version, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a AvailableAddOnInstance
 *
 * @function fetch
 * @memberof Twilio.Preview.Marketplace.AvailableAddOnInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AvailableAddOnInstance
 */
/* jshint ignore:end */
AvailableAddOnInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * Access the extensions
 *
 * @function extensions
 * @memberof Twilio.Preview.Marketplace.AvailableAddOnInstance#
 *
 * @returns {Twilio.Preview.Marketplace.AvailableAddOnContext.AvailableAddOnExtensionList}
 */
/* jshint ignore:end */
AvailableAddOnInstance.prototype.extensions = function extensions() {
  return this._proxy.extensions;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Marketplace.AvailableAddOnInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
AvailableAddOnInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

AvailableAddOnInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the AvailableAddOnContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Marketplace.AvailableAddOnContext
 *
 * @property {Twilio.Preview.Marketplace.AvailableAddOnContext.AvailableAddOnExtensionList} extensions -
 *          extensions resource
 *
 * @param {Marketplace} version - Version of the resource
 * @param {sid} sid - The SID of the AvailableAddOn resource to fetch
 */
/* jshint ignore:end */
AvailableAddOnContext = function AvailableAddOnContext(version, sid) {
  this._version = version;

  // Path Solution
  this._solution = {sid: sid, };
  this._uri = `/AvailableAddOns/${sid}`;

  // Dependents
  this._extensions = undefined;
};

/* jshint ignore:start */
/**
 * fetch a AvailableAddOnInstance
 *
 * @function fetch
 * @memberof Twilio.Preview.Marketplace.AvailableAddOnContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AvailableAddOnInstance
 */
/* jshint ignore:end */
AvailableAddOnContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new AvailableAddOnInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

Object.defineProperty(AvailableAddOnContext.prototype,
  'extensions', {
    get: function() {
      if (!this._extensions) {
        this._extensions = new AvailableAddOnExtensionList(this._version, this._solution.sid);
      }
      return this._extensions;
    }
});

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Marketplace.AvailableAddOnContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
AvailableAddOnContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

AvailableAddOnContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  AvailableAddOnList: AvailableAddOnList,
  AvailableAddOnPage: AvailableAddOnPage,
  AvailableAddOnInstance: AvailableAddOnInstance,
  AvailableAddOnContext: AvailableAddOnContext
};
