'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var _ = require('lodash');  /* jshint ignore:line */
var EsimProfileList = require('./v1/esimProfile').EsimProfileList;
var FleetList = require('./v1/fleet').FleetList;
var IpCommandList = require('./v1/ipCommand').IpCommandList;
var NetworkAccessProfileList = require(
    './v1/networkAccessProfile').NetworkAccessProfileList;
var NetworkList = require('./v1/network').NetworkList;
var SimList = require('./v1/sim').SimList;
var SmsCommandList = require('./v1/smsCommand').SmsCommandList;
var UsageRecordList = require('./v1/usageRecord').UsageRecordList;
var Version = require('../../base/Version');  /* jshint ignore:line */


/* jshint ignore:start */
/**
 * Initialize the V1 version of Supersim
 *
 * @constructor Twilio.Supersim.V1
 *
 * @property {Twilio.Supersim.V1.EsimProfileList} esimProfiles -
 *          esimProfiles resource
 * @property {Twilio.Supersim.V1.FleetList} fleets - fleets resource
 * @property {Twilio.Supersim.V1.IpCommandList} ipCommands - ipCommands resource
 * @property {Twilio.Supersim.V1.NetworkList} networks - networks resource
 * @property {Twilio.Supersim.V1.NetworkAccessProfileList} networkAccessProfiles -
 *          networkAccessProfiles resource
 * @property {Twilio.Supersim.V1.SimList} sims - sims resource
 * @property {Twilio.Supersim.V1.SmsCommandList} smsCommands - smsCommands resource
 * @property {Twilio.Supersim.V1.UsageRecordList} usageRecords -
 *          usageRecords resource
 *
 * @param {Twilio.Supersim} domain - The twilio domain
 */
/* jshint ignore:end */
function V1(domain) {
  Version.prototype.constructor.call(this, domain, 'v1');

  // Resources
  this._esimProfiles = undefined;
  this._fleets = undefined;
  this._ipCommands = undefined;
  this._networks = undefined;
  this._networkAccessProfiles = undefined;
  this._sims = undefined;
  this._smsCommands = undefined;
  this._usageRecords = undefined;
}

_.extend(V1.prototype, Version.prototype);
V1.prototype.constructor = V1;

Object.defineProperty(V1.prototype,
  'esimProfiles', {
    get: function() {
      this._esimProfiles = this._esimProfiles || new EsimProfileList(this);
      return this._esimProfiles;
    }
});

Object.defineProperty(V1.prototype,
  'fleets', {
    get: function() {
      this._fleets = this._fleets || new FleetList(this);
      return this._fleets;
    }
});

Object.defineProperty(V1.prototype,
  'ipCommands', {
    get: function() {
      this._ipCommands = this._ipCommands || new IpCommandList(this);
      return this._ipCommands;
    }
});

Object.defineProperty(V1.prototype,
  'networks', {
    get: function() {
      this._networks = this._networks || new NetworkList(this);
      return this._networks;
    }
});

Object.defineProperty(V1.prototype,
  'networkAccessProfiles', {
    get: function() {
      this._networkAccessProfiles = this._networkAccessProfiles || new NetworkAccessProfileList(this);
      return this._networkAccessProfiles;
    }
});

Object.defineProperty(V1.prototype,
  'sims', {
    get: function() {
      this._sims = this._sims || new SimList(this);
      return this._sims;
    }
});

Object.defineProperty(V1.prototype,
  'smsCommands', {
    get: function() {
      this._smsCommands = this._smsCommands || new SmsCommandList(this);
      return this._smsCommands;
    }
});

Object.defineProperty(V1.prototype,
  'usageRecords', {
    get: function() {
      this._usageRecords = this._usageRecords || new UsageRecordList(this);
      return this._usageRecords;
    }
});

module.exports = V1;
