/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V2 = require('../../V2');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the MessagingConfigurationList
 *
 * @param version - Version of the resource
 * @param serviceSid - The SID of the Service that the resource is associated with
 */
declare function MessagingConfigurationList(version: V2, serviceSid: string): MessagingConfigurationListInstance;

/**
 * Options to pass to update
 *
 * @property messagingServiceSid - The SID of the Messaging Service used for this configuration.
 */
interface MessagingConfigurationInstanceUpdateOptions {
  messagingServiceSid: string;
}

interface MessagingConfigurationListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): MessagingConfigurationContext;
  /**
   * create a MessagingConfigurationInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: MessagingConfigurationListInstanceCreateOptions, callback?: (error: Error | null, item: MessagingConfigurationInstance) => any): Promise<MessagingConfigurationInstance>;
  /**
   * Streams MessagingConfigurationInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: MessagingConfigurationInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams MessagingConfigurationInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: MessagingConfigurationListInstanceEachOptions, callback?: (item: MessagingConfigurationInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a messaging_configuration
   *
   * @param country - The ISO-3166-1 country code of the country or `all`.
   */
  get(country: string): MessagingConfigurationContext;
  /**
   * Retrieve a single target page of MessagingConfigurationInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: MessagingConfigurationPage) => any): Promise<MessagingConfigurationPage>;
  /**
   * Retrieve a single target page of MessagingConfigurationInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: MessagingConfigurationPage) => any): Promise<MessagingConfigurationPage>;
  /**
   * Lists MessagingConfigurationInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: MessagingConfigurationInstance[]) => any): Promise<MessagingConfigurationInstance[]>;
  /**
   * Lists MessagingConfigurationInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: MessagingConfigurationListInstanceOptions, callback?: (error: Error | null, items: MessagingConfigurationInstance[]) => any): Promise<MessagingConfigurationInstance[]>;
  /**
   * Retrieve a single page of MessagingConfigurationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: MessagingConfigurationPage) => any): Promise<MessagingConfigurationPage>;
  /**
   * Retrieve a single page of MessagingConfigurationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: MessagingConfigurationListInstancePageOptions, callback?: (error: Error | null, items: MessagingConfigurationPage) => any): Promise<MessagingConfigurationPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property country - The ISO-3166-1 country code of the country or `all`.
 * @property messagingServiceSid - The SID of the Messaging Service used for this configuration.
 */
interface MessagingConfigurationListInstanceCreateOptions {
  country: string;
  messagingServiceSid: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface MessagingConfigurationListInstanceEachOptions {
  callback?: (item: MessagingConfigurationInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface MessagingConfigurationListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface MessagingConfigurationListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface MessagingConfigurationPayload extends MessagingConfigurationResource, Page.TwilioResponsePayload {
}

interface MessagingConfigurationResource {
  account_sid: string;
  country: string;
  date_created: Date;
  date_updated: Date;
  messaging_service_sid: string;
  service_sid: string;
  url: string;
}

interface MessagingConfigurationSolution {
  serviceSid?: string;
}


declare class MessagingConfigurationContext {
  /**
   * Initialize the MessagingConfigurationContext
   *
   * @param version - Version of the resource
   * @param serviceSid - The SID of the Service that the resource is associated with
   * @param country - The ISO-3166-1 country code of the country or `all`.
   */
  constructor(version: V2, serviceSid: string, country: string);

  /**
   * fetch a MessagingConfigurationInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: MessagingConfigurationInstance) => any): Promise<MessagingConfigurationInstance>;
  /**
   * remove a MessagingConfigurationInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: MessagingConfigurationInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a MessagingConfigurationInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts: MessagingConfigurationInstanceUpdateOptions, callback?: (error: Error | null, items: MessagingConfigurationInstance) => any): Promise<MessagingConfigurationInstance>;
}


declare class MessagingConfigurationInstance extends SerializableClass {
  /**
   * Initialize the MessagingConfigurationContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param serviceSid - The SID of the Service that the resource is associated with
   * @param country - The ISO-3166-1 country code of the country or `all`.
   */
  constructor(version: V2, payload: MessagingConfigurationPayload, serviceSid: string, country: string);

  private _proxy: MessagingConfigurationContext;
  accountSid: string;
  country: string;
  dateCreated: Date;
  dateUpdated: Date;
  /**
   * fetch a MessagingConfigurationInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: MessagingConfigurationInstance) => any): Promise<MessagingConfigurationInstance>;
  messagingServiceSid: string;
  /**
   * remove a MessagingConfigurationInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: MessagingConfigurationInstance) => any): Promise<boolean>;
  serviceSid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a MessagingConfigurationInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts: MessagingConfigurationInstanceUpdateOptions, callback?: (error: Error | null, items: MessagingConfigurationInstance) => any): Promise<MessagingConfigurationInstance>;
  url: string;
}


declare class MessagingConfigurationPage extends Page<V2, MessagingConfigurationPayload, MessagingConfigurationResource, MessagingConfigurationInstance> {
  /**
   * Initialize the MessagingConfigurationPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2, response: Response<string>, solution: MessagingConfigurationSolution);

  /**
   * Build an instance of MessagingConfigurationInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: MessagingConfigurationPayload): MessagingConfigurationInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { MessagingConfigurationContext, MessagingConfigurationInstance, MessagingConfigurationInstanceUpdateOptions, MessagingConfigurationList, MessagingConfigurationListInstance, MessagingConfigurationListInstanceCreateOptions, MessagingConfigurationListInstanceEachOptions, MessagingConfigurationListInstanceOptions, MessagingConfigurationListInstancePageOptions, MessagingConfigurationPage, MessagingConfigurationPayload, MessagingConfigurationResource, MessagingConfigurationSolution }
