'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../base/deserialize');  /* jshint ignore:line */
var serialize = require('../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var VerificationAttemptList;
var VerificationAttemptPage;
var VerificationAttemptInstance;
var VerificationAttemptContext;

/* jshint ignore:start */
/**
 * Initialize the VerificationAttemptList
 *
 * @constructor Twilio.Verify.V2.VerificationAttemptList
 *
 * @param {Twilio.Verify.V2} version - Version of the resource
 */
/* jshint ignore:end */
VerificationAttemptList = function VerificationAttemptList(version) {
  /* jshint ignore:start */
  /**
   * @function verificationAttempts
   * @memberof Twilio.Verify.V2#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Verify.V2.VerificationAttemptContext}
   */
  /* jshint ignore:end */
  function VerificationAttemptListInstance(sid) {
    return VerificationAttemptListInstance.get(sid);
  }

  VerificationAttemptListInstance._version = version;
  // Path Solution
  VerificationAttemptListInstance._solution = {};
  VerificationAttemptListInstance._uri = `/Attempts`;
  /* jshint ignore:start */
  /**
   * Streams VerificationAttemptInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Verify.V2.VerificationAttemptList#
   *
   * @param {object} [opts] - Options for request
   * @param {Date} [opts.dateCreatedAfter] -
   *          Filter verification attempts after this date.
   * @param {Date} [opts.dateCreatedBefore] -
   *          Filter verification attempts before this date.
   * @param {string} [opts.channelData.to] -
   *          Filters by destination of the verification attempt.
   * @param {string} [opts.country] -
   *          Filter verification attempts by destination country.
   * @param {verification_attempt.channels} [opts.channel] -
   *          Filter verification attempts by communication channel.
   * @param {string} [opts.verifyServiceSid] -
   *          Filter verification attempts by verify service.
   * @param {string} [opts.verificationSid] - Filter attempts by verification.
   * @param {verification_attempt.conversion_status} [opts.status] -
   *          Filter verification attempts by conversion status.
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  VerificationAttemptListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        } else {
          onComplete();
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists VerificationAttemptInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Verify.V2.VerificationAttemptList#
   *
   * @param {object} [opts] - Options for request
   * @param {Date} [opts.dateCreatedAfter] -
   *          Filter verification attempts after this date.
   * @param {Date} [opts.dateCreatedBefore] -
   *          Filter verification attempts before this date.
   * @param {string} [opts.channelData.to] -
   *          Filters by destination of the verification attempt.
   * @param {string} [opts.country] -
   *          Filter verification attempts by destination country.
   * @param {verification_attempt.channels} [opts.channel] -
   *          Filter verification attempts by communication channel.
   * @param {string} [opts.verifyServiceSid] -
   *          Filter verification attempts by verify service.
   * @param {string} [opts.verificationSid] - Filter attempts by verification.
   * @param {verification_attempt.conversion_status} [opts.status] -
   *          Filter verification attempts by conversion status.
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  VerificationAttemptListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of VerificationAttemptInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Verify.V2.VerificationAttemptList#
   *
   * @param {object} [opts] - Options for request
   * @param {Date} [opts.dateCreatedAfter] -
   *          Filter verification attempts after this date.
   * @param {Date} [opts.dateCreatedBefore] -
   *          Filter verification attempts before this date.
   * @param {string} [opts.channelData.to] -
   *          Filters by destination of the verification attempt.
   * @param {string} [opts.country] -
   *          Filter verification attempts by destination country.
   * @param {verification_attempt.channels} [opts.channel] -
   *          Filter verification attempts by communication channel.
   * @param {string} [opts.verifyServiceSid] -
   *          Filter verification attempts by verify service.
   * @param {string} [opts.verificationSid] - Filter attempts by verification.
   * @param {verification_attempt.conversion_status} [opts.status] -
   *          Filter verification attempts by conversion status.
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  VerificationAttemptListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'DateCreatedAfter': serialize.iso8601DateTime(_.get(opts, 'dateCreatedAfter')),
      'DateCreatedBefore': serialize.iso8601DateTime(_.get(opts, 'dateCreatedBefore')),
      'ChannelData.To': _.get(opts, 'channelData.to'),
      'Country': _.get(opts, 'country'),
      'Channel': _.get(opts, 'channel'),
      'VerifyServiceSid': _.get(opts, 'verifyServiceSid'),
      'VerificationSid': _.get(opts, 'verificationSid'),
      'Status': _.get(opts, 'status'),
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new VerificationAttemptPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of VerificationAttemptInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Verify.V2.VerificationAttemptList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  VerificationAttemptListInstance.getPage = function getPage(targetUrl, callback)
                                                              {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new VerificationAttemptPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a verification_attempt
   *
   * @function get
   * @memberof Twilio.Verify.V2.VerificationAttemptList#
   *
   * @param {string} sid - Verification Attempt Sid.
   *
   * @returns {Twilio.Verify.V2.VerificationAttemptContext}
   */
  /* jshint ignore:end */
  VerificationAttemptListInstance.get = function get(sid) {
    return new VerificationAttemptContext(this._version, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Verify.V2.VerificationAttemptList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  VerificationAttemptListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  VerificationAttemptListInstance[util.inspect.custom] = function inspect(depth,
      options) {
    return util.inspect(this.toJSON(), options);
  };

  return VerificationAttemptListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the VerificationAttemptPage
 *
 * @constructor Twilio.Verify.V2.VerificationAttemptPage
 *
 * @param {V2} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {VerificationAttemptSolution} solution - Path solution
 *
 * @returns VerificationAttemptPage
 */
/* jshint ignore:end */
VerificationAttemptPage = function VerificationAttemptPage(version, response,
                                                            solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(VerificationAttemptPage.prototype, Page.prototype);
VerificationAttemptPage.prototype.constructor = VerificationAttemptPage;

/* jshint ignore:start */
/**
 * Build an instance of VerificationAttemptInstance
 *
 * @function getInstance
 * @memberof Twilio.Verify.V2.VerificationAttemptPage#
 *
 * @param {VerificationAttemptPayload} payload - Payload response from the API
 *
 * @returns VerificationAttemptInstance
 */
/* jshint ignore:end */
VerificationAttemptPage.prototype.getInstance = function getInstance(payload) {
  return new VerificationAttemptInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Verify.V2.VerificationAttemptPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
VerificationAttemptPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

VerificationAttemptPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the VerificationAttemptContext
 *
 * @constructor Twilio.Verify.V2.VerificationAttemptInstance
 *
 * @property {string} sid -
 *          The SID that uniquely identifies the verification attempt.
 * @property {string} accountSid -
 *          The SID of the Account that created the verification.
 * @property {string} serviceSid -
 *          The SID of the verify service that generated this attempt.
 * @property {string} verificationSid -
 *          The SID of the verification that generated this attempt.
 * @property {Date} dateCreated - The date this Attempt was created
 * @property {Date} dateUpdated - The date this Attempt was updated
 * @property {verification_attempt.conversion_status} conversionStatus -
 *          Status of the conversion for the verification.
 * @property {verification_attempt.channels} channel -
 *          Communication channel used for the attempt.
 * @property {object} price -
 *          An object containing the charge for this verification attempt.
 * @property {object} channelData -
 *          An object containing the channel specific information for an attempt.
 * @property {string} url - The url
 *
 * @param {V2} version - Version of the resource
 * @param {VerificationAttemptPayload} payload - The instance payload
 * @param {sid} sid - Verification Attempt Sid.
 */
/* jshint ignore:end */
VerificationAttemptInstance = function VerificationAttemptInstance(version,
    payload, sid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.serviceSid = payload.service_sid; // jshint ignore:line
  this.verificationSid = payload.verification_sid; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.conversionStatus = payload.conversion_status; // jshint ignore:line
  this.channel = payload.channel; // jshint ignore:line
  this.price = payload.price; // jshint ignore:line
  this.channelData = payload.channel_data; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {sid: sid || this.sid, };
};

Object.defineProperty(VerificationAttemptInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new VerificationAttemptContext(this._version, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a VerificationAttemptInstance
 *
 * @function fetch
 * @memberof Twilio.Verify.V2.VerificationAttemptInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed VerificationAttemptInstance
 */
/* jshint ignore:end */
VerificationAttemptInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Verify.V2.VerificationAttemptInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
VerificationAttemptInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

VerificationAttemptInstance.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the VerificationAttemptContext
 *
 * @constructor Twilio.Verify.V2.VerificationAttemptContext
 *
 * @param {V2} version - Version of the resource
 * @param {sid} sid - Verification Attempt Sid.
 */
/* jshint ignore:end */
VerificationAttemptContext = function VerificationAttemptContext(version, sid) {
  this._version = version;

  // Path Solution
  this._solution = {sid: sid, };
  this._uri = `/Attempts/${sid}`;
};

/* jshint ignore:start */
/**
 * fetch a VerificationAttemptInstance
 *
 * @function fetch
 * @memberof Twilio.Verify.V2.VerificationAttemptContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed VerificationAttemptInstance
 */
/* jshint ignore:end */
VerificationAttemptContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new VerificationAttemptInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Verify.V2.VerificationAttemptContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
VerificationAttemptContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

VerificationAttemptContext.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  VerificationAttemptList: VerificationAttemptList,
  VerificationAttemptPage: VerificationAttemptPage,
  VerificationAttemptInstance: VerificationAttemptInstance,
  VerificationAttemptContext: VerificationAttemptContext
};
