/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import DeployedDevices = require('./preview/DeployedDevices');
import Domain = require('../base/Domain');
import HostedNumbers = require('./preview/HostedNumbers');
import Marketplace = require('./preview/Marketplace');
import Sync = require('./preview/Sync');
import Twilio = require('./Twilio');
import Understand = require('./preview/Understand');
import Wireless = require('./preview/Wireless');
import { AssistantListInstance } from './preview/understand/assistant';
import { AuthorizationDocumentListInstance } from './preview/hosted_numbers/authorizationDocument';
import { AvailableAddOnListInstance } from './preview/marketplace/availableAddOn';
import { CommandListInstance } from './preview/wireless/command';
import { FleetListInstance } from './preview/deployed_devices/fleet';
import { HostedNumberOrderListInstance } from './preview/hosted_numbers/hostedNumberOrder';
import { InstalledAddOnListInstance } from './preview/marketplace/installedAddOn';
import { RatePlanListInstance } from './preview/wireless/ratePlan';
import { ServiceListInstance } from './preview/sync/service';
import { SimListInstance } from './preview/wireless/sim';


declare class Preview extends Domain {
  /**
   * Initialize preview domain
   *
   * @param twilio - The twilio client
   */
  constructor(twilio: Twilio);

  readonly assistants: AssistantListInstance;
  readonly authorizationDocuments: AuthorizationDocumentListInstance;
  readonly availableAddOns: AvailableAddOnListInstance;
  readonly commands: CommandListInstance;
  readonly deployed_devices: DeployedDevices;
  readonly fleets: FleetListInstance;
  readonly hostedNumberOrders: HostedNumberOrderListInstance;
  readonly hosted_numbers: HostedNumbers;
  readonly installedAddOns: InstalledAddOnListInstance;
  readonly marketplace: Marketplace;
  readonly ratePlans: RatePlanListInstance;
  readonly services: ServiceListInstance;
  readonly sims: SimListInstance;
  readonly sync: Sync;
  readonly understand: Understand;
  readonly wireless: Wireless;
}

export = Preview;
