'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var _ = require('lodash');  /* jshint ignore:line */
var DeployedDevices = require(
    './preview/DeployedDevices');  /* jshint ignore:line */
var Domain = require('../base/Domain');  /* jshint ignore:line */
var HostedNumbers = require(
    './preview/HostedNumbers');  /* jshint ignore:line */
var Marketplace = require('./preview/Marketplace');  /* jshint ignore:line */
var Sync = require('./preview/Sync');  /* jshint ignore:line */
var Understand = require('./preview/Understand');  /* jshint ignore:line */
var Wireless = require('./preview/Wireless');  /* jshint ignore:line */


/* jshint ignore:start */
/**
 * Initialize preview domain
 *
 * @constructor Twilio.Preview
 *
 * @property {Twilio.Preview.DeployedDevices} deployed_devices -
 *          deployed_devices version
 * @property {Twilio.Preview.HostedNumbers} hosted_numbers - hosted_numbers version
 * @property {Twilio.Preview.Marketplace} marketplace - marketplace version
 * @property {Twilio.Preview.Sync} sync - sync version
 * @property {Twilio.Preview.Understand} understand - understand version
 * @property {Twilio.Preview.Wireless} wireless - wireless version
 * @property {Twilio.Preview.DeployedDevices.FleetList} fleets - fleets resource
 * @property {Twilio.Preview.HostedNumbers.AuthorizationDocumentList} authorizationDocuments -
 *          authorizationDocuments resource
 * @property {Twilio.Preview.HostedNumbers.HostedNumberOrderList} hostedNumberOrders -
 *          hostedNumberOrders resource
 * @property {Twilio.Preview.Marketplace.AvailableAddOnList} availableAddOns -
 *          availableAddOns resource
 * @property {Twilio.Preview.Marketplace.InstalledAddOnList} installedAddOns -
 *          installedAddOns resource
 * @property {Twilio.Preview.Sync.ServiceList} services - services resource
 * @property {Twilio.Preview.Understand.AssistantList} assistants -
 *          assistants resource
 * @property {Twilio.Preview.Wireless.CommandList} commands - commands resource
 * @property {Twilio.Preview.Wireless.RatePlanList} ratePlans - ratePlans resource
 * @property {Twilio.Preview.Wireless.SimList} sims - sims resource
 *
 * @param {Twilio} twilio - The twilio client
 */
/* jshint ignore:end */
function Preview(twilio) {
  Domain.prototype.constructor.call(this, twilio, 'https://preview.twilio.com');

  // Versions
  this._deployed_devices = undefined;
  this._hosted_numbers = undefined;
  this._marketplace = undefined;
  this._sync = undefined;
  this._understand = undefined;
  this._wireless = undefined;
}

_.extend(Preview.prototype, Domain.prototype);
Preview.prototype.constructor = Preview;

Object.defineProperty(Preview.prototype,
  'deployed_devices', {
    get: function() {
      this._deployed_devices = this._deployed_devices || new DeployedDevices(this);
      return this._deployed_devices;
    }
});

Object.defineProperty(Preview.prototype,
  'hosted_numbers', {
    get: function() {
      this._hosted_numbers = this._hosted_numbers || new HostedNumbers(this);
      return this._hosted_numbers;
    }
});

Object.defineProperty(Preview.prototype,
  'marketplace', {
    get: function() {
      this._marketplace = this._marketplace || new Marketplace(this);
      return this._marketplace;
    }
});

Object.defineProperty(Preview.prototype,
  'sync', {
    get: function() {
      this._sync = this._sync || new Sync(this);
      return this._sync;
    }
});

Object.defineProperty(Preview.prototype,
  'understand', {
    get: function() {
      this._understand = this._understand || new Understand(this);
      return this._understand;
    }
});

Object.defineProperty(Preview.prototype,
  'wireless', {
    get: function() {
      this._wireless = this._wireless || new Wireless(this);
      return this._wireless;
    }
});

Object.defineProperty(Preview.prototype,
  'fleets', {
    get: function() {
      return this.deployed_devices.fleets;
    }
});

Object.defineProperty(Preview.prototype,
  'authorizationDocuments', {
    get: function() {
      return this.hosted_numbers.authorizationDocuments;
    }
});

Object.defineProperty(Preview.prototype,
  'hostedNumberOrders', {
    get: function() {
      return this.hosted_numbers.hostedNumberOrders;
    }
});

Object.defineProperty(Preview.prototype,
  'availableAddOns', {
    get: function() {
      return this.marketplace.availableAddOns;
    }
});

Object.defineProperty(Preview.prototype,
  'installedAddOns', {
    get: function() {
      return this.marketplace.installedAddOns;
    }
});

Object.defineProperty(Preview.prototype,
  'services', {
    get: function() {
      return this.sync.services;
    }
});

Object.defineProperty(Preview.prototype,
  'assistants', {
    get: function() {
      return this.understand.assistants;
    }
});

Object.defineProperty(Preview.prototype,
  'commands', {
    get: function() {
      return this.wireless.commands;
    }
});

Object.defineProperty(Preview.prototype,
  'ratePlans', {
    get: function() {
      return this.wireless.ratePlans;
    }
});

Object.defineProperty(Preview.prototype,
  'sims', {
    get: function() {
      return this.wireless.sims;
    }
});

module.exports = Preview;
