/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Domain = require('../base/Domain');
import Twilio = require('./Twilio');
import V1 = require('./supersim/V1');
import { EsimProfileListInstance } from './supersim/v1/esimProfile';
import { FleetListInstance } from './supersim/v1/fleet';
import { IpCommandListInstance } from './supersim/v1/ipCommand';
import { NetworkAccessProfileListInstance } from './supersim/v1/networkAccessProfile';
import { NetworkListInstance } from './supersim/v1/network';
import { SettingsUpdateListInstance } from './supersim/v1/settingsUpdate';
import { SimListInstance } from './supersim/v1/sim';
import { SmsCommandListInstance } from './supersim/v1/smsCommand';
import { UsageRecordListInstance } from './supersim/v1/usageRecord';


declare class Supersim extends Domain {
  /**
   * Initialize supersim domain
   *
   * @param twilio - The twilio client
   */
  constructor(twilio: Twilio);

  readonly esimProfiles: EsimProfileListInstance;
  readonly fleets: FleetListInstance;
  readonly ipCommands: IpCommandListInstance;
  readonly networkAccessProfiles: NetworkAccessProfileListInstance;
  readonly networks: NetworkListInstance;
  readonly settingsUpdates: SettingsUpdateListInstance;
  readonly sims: SimListInstance;
  readonly smsCommands: SmsCommandListInstance;
  readonly usageRecords: UsageRecordListInstance;
  readonly v1: V1;
}

export = Supersim;
