/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V2 = require('../V2');
import { SerializableClass } from '../../../interfaces';

type PhoneNumberType = 'landline'|'mobile'|'voip';

type PhoneNumberValidationError = 'TOO_SHORT'|'TOO_LONG'|'INVALID_BUT_POSSIBLE'|'INVALID_COUNTRY_CODE'|'INVALID_LENGTH'|'NOT_A_NUMBER';

/**
 * Initialize the PhoneNumberList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 */
declare function PhoneNumberList(version: V2): PhoneNumberListInstance;

/**
 * Options to pass to fetch
 *
 * @property addressCountryCode - User’s country, up to two characters.
 * @property addressLine1 - User’s first address line.
 * @property addressLine2 - User’s second address line.
 * @property city - User’s city.
 * @property countryCode - Country code for national phone number lookups
 * @property dateOfBirth - User’s date of birth, in YYYYMMDD format.
 * @property fields - Fields to return
 * @property firstName - User’s first name.
 * @property lastName - User’s last name.
 * @property nationalId - User’s national ID, such as SSN or Passport ID.
 * @property postalCode - User’s postal zip code.
 * @property state - User’s country subdivision, such as state, province, or locality.
 */
interface PhoneNumberInstanceFetchOptions {
  addressCountryCode?: string;
  addressLine1?: string;
  addressLine2?: string;
  city?: string;
  countryCode?: string;
  dateOfBirth?: string;
  fields?: string;
  firstName?: string;
  lastName?: string;
  nationalId?: string;
  postalCode?: string;
  state?: string;
}

interface PhoneNumberListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): PhoneNumberContext;
  /**
   * Constructs a phone_number
   *
   * @param phoneNumber - Phone number to lookup
   */
  get(phoneNumber: string): PhoneNumberContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface PhoneNumberPayload extends PhoneNumberResource, Page.TwilioResponsePayload {
}

interface PhoneNumberResource {
  call_forwarding: object;
  caller_name: object;
  calling_country_code: string;
  country_code: string;
  identity_match: object;
  line_type_intelligence: object;
  live_activity: object;
  national_format: string;
  phone_number: string;
  sim_swap: object;
  url: string;
  valid: boolean;
  validation_errors: PhoneNumberValidationError[];
}

interface PhoneNumberSolution {
}


declare class PhoneNumberContext {
  /**
   * Initialize the PhoneNumberContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param phoneNumber - Phone number to lookup
   */
  constructor(version: V2, phoneNumber: string);

  /**
   * fetch a PhoneNumberInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: PhoneNumberInstance) => any): Promise<PhoneNumberInstance>;
  /**
   * fetch a PhoneNumberInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: PhoneNumberInstanceFetchOptions, callback?: (error: Error | null, items: PhoneNumberInstance) => any): Promise<PhoneNumberInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class PhoneNumberInstance extends SerializableClass {
  /**
   * Initialize the PhoneNumberContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param phoneNumber - Phone number to lookup
   */
  constructor(version: V2, payload: PhoneNumberPayload, phoneNumber: string);

  private _proxy: PhoneNumberContext;
  callForwarding: any;
  callerName: any;
  callingCountryCode: string;
  countryCode: string;
  /**
   * fetch a PhoneNumberInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: PhoneNumberInstance) => any): Promise<PhoneNumberInstance>;
  /**
   * fetch a PhoneNumberInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: PhoneNumberInstanceFetchOptions, callback?: (error: Error | null, items: PhoneNumberInstance) => any): Promise<PhoneNumberInstance>;
  identityMatch: any;
  lineTypeIntelligence: any;
  liveActivity: any;
  nationalFormat: string;
  phoneNumber: string;
  simSwap: any;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
  valid: boolean;
  validationErrors: PhoneNumberValidationError[];
}


declare class PhoneNumberPage extends Page<V2, PhoneNumberPayload, PhoneNumberResource, PhoneNumberInstance> {
  /**
   * Initialize the PhoneNumberPage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2, response: Response<string>, solution: PhoneNumberSolution);

  /**
   * Build an instance of PhoneNumberInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: PhoneNumberPayload): PhoneNumberInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { PhoneNumberContext, PhoneNumberInstance, PhoneNumberInstanceFetchOptions, PhoneNumberList, PhoneNumberListInstance, PhoneNumberPage, PhoneNumberPayload, PhoneNumberResource, PhoneNumberSolution, PhoneNumberType, PhoneNumberValidationError }
