/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the OauthList
 *
 * @param version - Version of the resource
 */
declare function OauthList(version: V1): OauthListInstance;

interface OauthListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): OauthContext;
  /**
   * Constructs a oauth
   */
  get(): OauthContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface OauthPayload extends OauthResource, Page.TwilioResponsePayload {
}

interface OauthResource {
  keys: object;
  url: string;
}

interface OauthSolution {
}


declare class OauthContext {
  /**
   * Initialize the OauthContext
   *
   * @param version - Version of the resource
   */
  constructor(version: V1);

  /**
   * fetch a OauthInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: OauthInstance) => any): Promise<OauthInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class OauthInstance extends SerializableClass {
  /**
   * Initialize the OauthContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: V1, payload: OauthPayload);

  private _proxy: OauthContext;
  /**
   * fetch a OauthInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: OauthInstance) => any): Promise<OauthInstance>;
  keys: any;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class OauthPage extends Page<V1, OauthPayload, OauthResource, OauthInstance> {
  /**
   * Initialize the OauthPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: OauthSolution);

  /**
   * Build an instance of OauthInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: OauthPayload): OauthInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { OauthContext, OauthInstance, OauthList, OauthListInstance, OauthPage, OauthPayload, OauthResource, OauthSolution }
