/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V2 = require('../V2');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the SafelistList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 */
declare function SafelistList(version: V2): SafelistListInstance;

interface SafelistListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): SafelistContext;
  /**
   * create a SafelistInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: SafelistListInstanceCreateOptions, callback?: (error: Error | null, item: SafelistInstance) => any): Promise<SafelistInstance>;
  /**
   * Constructs a safelist
   *
   * @param phoneNumber - The phone number to be fetched from SafeList.
   */
  get(phoneNumber: string): SafelistContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property phoneNumber - The phone number to be added in SafeList.
 */
interface SafelistListInstanceCreateOptions {
  phoneNumber: string;
}

interface SafelistPayload extends SafelistResource, Page.TwilioResponsePayload {
}

interface SafelistResource {
  phone_number: string;
  sid: string;
  url: string;
}

interface SafelistSolution {
}


declare class SafelistContext {
  /**
   * Initialize the SafelistContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param phoneNumber - The phone number to be fetched from SafeList.
   */
  constructor(version: V2, phoneNumber: string);

  /**
   * fetch a SafelistInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: SafelistInstance) => any): Promise<SafelistInstance>;
  /**
   * remove a SafelistInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: SafelistInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class SafelistInstance extends SerializableClass {
  /**
   * Initialize the SafelistContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param phoneNumber - The phone number to be fetched from SafeList.
   */
  constructor(version: V2, payload: SafelistPayload, phoneNumber: string);

  private _proxy: SafelistContext;
  /**
   * fetch a SafelistInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: SafelistInstance) => any): Promise<SafelistInstance>;
  phoneNumber: string;
  /**
   * remove a SafelistInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: SafelistInstance) => any): Promise<boolean>;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class SafelistPage extends Page<V2, SafelistPayload, SafelistResource, SafelistInstance> {
  /**
   * Initialize the SafelistPage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2, response: Response<string>, solution: SafelistSolution);

  /**
   * Build an instance of SafelistInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: SafelistPayload): SafelistInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { SafelistContext, SafelistInstance, SafelistList, SafelistListInstance, SafelistListInstanceCreateOptions, SafelistPage, SafelistPayload, SafelistResource, SafelistSolution }
