/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V2 = require('../../V2');
import { SerializableClass } from '../../../../interfaces';

type AccessTokenFactorTypes = 'push';

/**
 * Initialize the AccessTokenList
 *
 * @param version - Version of the resource
 * @param serviceSid - Verify Service Sid.
 */
declare function AccessTokenList(version: V2, serviceSid: string): AccessTokenListInstance;

interface AccessTokenListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): AccessTokenContext;
  /**
   * create a AccessTokenInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: AccessTokenListInstanceCreateOptions, callback?: (error: Error | null, item: AccessTokenInstance) => any): Promise<AccessTokenInstance>;
  /**
   * Constructs a access_token
   *
   * @param sid - A string that uniquely identifies this Access Token.
   */
  get(sid: string): AccessTokenContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property factorFriendlyName - The factor friendly name
 * @property factorType - The Type of this Factor
 * @property identity - Unique external identifier of the Entity
 * @property ttl - How long, in seconds, the access token is valid.
 */
interface AccessTokenListInstanceCreateOptions {
  factorFriendlyName?: string;
  factorType: AccessTokenFactorTypes;
  identity: string;
  ttl?: number;
}

interface AccessTokenPayload extends AccessTokenResource, Page.TwilioResponsePayload {
}

interface AccessTokenResource {
  account_sid: string;
  date_created: Date;
  entity_identity: string;
  factor_friendly_name: string;
  factor_type: AccessTokenFactorTypes;
  service_sid: string;
  sid: string;
  token: string;
  ttl: number;
  url: string;
}

interface AccessTokenSolution {
  serviceSid?: string;
}


declare class AccessTokenContext {
  /**
   * Initialize the AccessTokenContext
   *
   * @param version - Version of the resource
   * @param serviceSid - Service Sid.
   * @param sid - A string that uniquely identifies this Access Token.
   */
  constructor(version: V2, serviceSid: string, sid: string);

  /**
   * fetch a AccessTokenInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: AccessTokenInstance) => any): Promise<AccessTokenInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class AccessTokenInstance extends SerializableClass {
  /**
   * Initialize the AccessTokenContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param serviceSid - Verify Service Sid.
   * @param sid - A string that uniquely identifies this Access Token.
   */
  constructor(version: V2, payload: AccessTokenPayload, serviceSid: string, sid: string);

  private _proxy: AccessTokenContext;
  accountSid: string;
  dateCreated: Date;
  entityIdentity: string;
  factorFriendlyName: string;
  factorType: AccessTokenFactorTypes;
  /**
   * fetch a AccessTokenInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: AccessTokenInstance) => any): Promise<AccessTokenInstance>;
  serviceSid: string;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  token: string;
  ttl: number;
  url: string;
}


declare class AccessTokenPage extends Page<V2, AccessTokenPayload, AccessTokenResource, AccessTokenInstance> {
  /**
   * Initialize the AccessTokenPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2, response: Response<string>, solution: AccessTokenSolution);

  /**
   * Build an instance of AccessTokenInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: AccessTokenPayload): AccessTokenInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { AccessTokenContext, AccessTokenFactorTypes, AccessTokenInstance, AccessTokenList, AccessTokenListInstance, AccessTokenListInstanceCreateOptions, AccessTokenPage, AccessTokenPayload, AccessTokenResource, AccessTokenSolution }
