"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Autopilot
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssistantPage = exports.AssistantListInstance = exports.AssistantInstance = exports.AssistantContextImpl = void 0;
const util_1 = require("util");
const Page_1 = __importDefault(require("../../../base/Page"));
const deserialize = require("../../../base/deserialize");
const serialize = require("../../../base/serialize");
const utility_1 = require("../../../base/utility");
const defaults_1 = require("./assistant/defaults");
const dialogue_1 = require("./assistant/dialogue");
const fieldType_1 = require("./assistant/fieldType");
const modelBuild_1 = require("./assistant/modelBuild");
const query_1 = require("./assistant/query");
const styleSheet_1 = require("./assistant/styleSheet");
const task_1 = require("./assistant/task");
const webhook_1 = require("./assistant/webhook");
class AssistantContextImpl {
    constructor(_version, sid) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(sid)) {
            throw new Error("Parameter 'sid' is not valid.");
        }
        this._solution = { sid };
        this._uri = `/Assistants/${sid}`;
    }
    get defaults() {
        this._defaults =
            this._defaults || (0, defaults_1.DefaultsListInstance)(this._version, this._solution.sid);
        return this._defaults;
    }
    get dialogues() {
        this._dialogues =
            this._dialogues ||
                (0, dialogue_1.DialogueListInstance)(this._version, this._solution.sid);
        return this._dialogues;
    }
    get fieldTypes() {
        this._fieldTypes =
            this._fieldTypes ||
                (0, fieldType_1.FieldTypeListInstance)(this._version, this._solution.sid);
        return this._fieldTypes;
    }
    get modelBuilds() {
        this._modelBuilds =
            this._modelBuilds ||
                (0, modelBuild_1.ModelBuildListInstance)(this._version, this._solution.sid);
        return this._modelBuilds;
    }
    get queries() {
        this._queries =
            this._queries || (0, query_1.QueryListInstance)(this._version, this._solution.sid);
        return this._queries;
    }
    get styleSheet() {
        this._styleSheet =
            this._styleSheet ||
                (0, styleSheet_1.StyleSheetListInstance)(this._version, this._solution.sid);
        return this._styleSheet;
    }
    get tasks() {
        this._tasks =
            this._tasks || (0, task_1.TaskListInstance)(this._version, this._solution.sid);
        return this._tasks;
    }
    get webhooks() {
        this._webhooks =
            this._webhooks || (0, webhook_1.WebhookListInstance)(this._version, this._solution.sid);
        return this._webhooks;
    }
    remove(callback) {
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.remove({
            uri: instance._uri,
            method: "delete",
        });
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    fetch(callback) {
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.fetch({
            uri: instance._uri,
            method: "get",
        });
        operationPromise = operationPromise.then((payload) => new AssistantInstance(operationVersion, payload, instance._solution.sid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    update(params, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        if (params["friendlyName"] !== undefined)
            data["FriendlyName"] = params["friendlyName"];
        if (params["logQueries"] !== undefined)
            data["LogQueries"] = serialize.bool(params["logQueries"]);
        if (params["uniqueName"] !== undefined)
            data["UniqueName"] = params["uniqueName"];
        if (params["callbackUrl"] !== undefined)
            data["CallbackUrl"] = params["callbackUrl"];
        if (params["callbackEvents"] !== undefined)
            data["CallbackEvents"] = params["callbackEvents"];
        if (params["styleSheet"] !== undefined)
            data["StyleSheet"] = serialize.object(params["styleSheet"]);
        if (params["defaults"] !== undefined)
            data["Defaults"] = serialize.object(params["defaults"]);
        if (params["developmentStage"] !== undefined)
            data["DevelopmentStage"] = params["developmentStage"];
        const headers = {};
        headers["Content-Type"] = "application/x-www-form-urlencoded";
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.update({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new AssistantInstance(operationVersion, payload, instance._solution.sid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.AssistantContextImpl = AssistantContextImpl;
class AssistantInstance {
    constructor(_version, payload, sid) {
        this._version = _version;
        this.accountSid = payload.account_sid;
        this.dateCreated = deserialize.iso8601DateTime(payload.date_created);
        this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated);
        this.friendlyName = payload.friendly_name;
        this.latestModelBuildSid = payload.latest_model_build_sid;
        this.links = payload.links;
        this.logQueries = payload.log_queries;
        this.developmentStage = payload.development_stage;
        this.needsModelBuild = payload.needs_model_build;
        this.sid = payload.sid;
        this.uniqueName = payload.unique_name;
        this.url = payload.url;
        this.callbackUrl = payload.callback_url;
        this.callbackEvents = payload.callback_events;
        this._solution = { sid: sid || this.sid };
    }
    get _proxy() {
        this._context =
            this._context ||
                new AssistantContextImpl(this._version, this._solution.sid);
        return this._context;
    }
    /**
     * Remove a AssistantInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed boolean
     */
    remove(callback) {
        return this._proxy.remove(callback);
    }
    /**
     * Fetch a AssistantInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed AssistantInstance
     */
    fetch(callback) {
        return this._proxy.fetch(callback);
    }
    update(params, callback) {
        return this._proxy.update(params, callback);
    }
    /**
     * Access the defaults.
     */
    defaults() {
        return this._proxy.defaults;
    }
    /**
     * Access the dialogues.
     */
    dialogues() {
        return this._proxy.dialogues;
    }
    /**
     * Access the fieldTypes.
     */
    fieldTypes() {
        return this._proxy.fieldTypes;
    }
    /**
     * Access the modelBuilds.
     */
    modelBuilds() {
        return this._proxy.modelBuilds;
    }
    /**
     * Access the queries.
     */
    queries() {
        return this._proxy.queries;
    }
    /**
     * Access the styleSheet.
     */
    styleSheet() {
        return this._proxy.styleSheet;
    }
    /**
     * Access the tasks.
     */
    tasks() {
        return this._proxy.tasks;
    }
    /**
     * Access the webhooks.
     */
    webhooks() {
        return this._proxy.webhooks;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            accountSid: this.accountSid,
            dateCreated: this.dateCreated,
            dateUpdated: this.dateUpdated,
            friendlyName: this.friendlyName,
            latestModelBuildSid: this.latestModelBuildSid,
            links: this.links,
            logQueries: this.logQueries,
            developmentStage: this.developmentStage,
            needsModelBuild: this.needsModelBuild,
            sid: this.sid,
            uniqueName: this.uniqueName,
            url: this.url,
            callbackUrl: this.callbackUrl,
            callbackEvents: this.callbackEvents,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.AssistantInstance = AssistantInstance;
function AssistantListInstance(version) {
    const instance = ((sid) => instance.get(sid));
    instance.get = function get(sid) {
        return new AssistantContextImpl(version, sid);
    };
    instance._version = version;
    instance._solution = {};
    instance._uri = `/Assistants`;
    instance.create = function create(params, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        if (params["friendlyName"] !== undefined)
            data["FriendlyName"] = params["friendlyName"];
        if (params["logQueries"] !== undefined)
            data["LogQueries"] = serialize.bool(params["logQueries"]);
        if (params["uniqueName"] !== undefined)
            data["UniqueName"] = params["uniqueName"];
        if (params["callbackUrl"] !== undefined)
            data["CallbackUrl"] = params["callbackUrl"];
        if (params["callbackEvents"] !== undefined)
            data["CallbackEvents"] = params["callbackEvents"];
        if (params["styleSheet"] !== undefined)
            data["StyleSheet"] = serialize.object(params["styleSheet"]);
        if (params["defaults"] !== undefined)
            data["Defaults"] = serialize.object(params["defaults"]);
        const headers = {};
        headers["Content-Type"] = "application/x-www-form-urlencoded";
        let operationVersion = version, operationPromise = operationVersion.create({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new AssistantInstance(operationVersion, payload));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.page = function page(params, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        if (params["pageSize"] !== undefined)
            data["PageSize"] = params["pageSize"];
        if (params.pageNumber !== undefined)
            data["Page"] = params.pageNumber;
        if (params.pageToken !== undefined)
            data["PageToken"] = params.pageToken;
        const headers = {};
        let operationVersion = version, operationPromise = operationVersion.page({
            uri: instance._uri,
            method: "get",
            params: data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new AssistantPage(operationVersion, payload, instance._solution));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.each = instance._version.each;
    instance.list = instance._version.list;
    instance.getPage = function getPage(targetUrl, callback) {
        const operationPromise = instance._version._domain.twilio.request({
            method: "get",
            uri: targetUrl,
        });
        let pagePromise = operationPromise.then((payload) => new AssistantPage(instance._version, payload, instance._solution));
        pagePromise = instance._version.setPromiseCallback(pagePromise, callback);
        return pagePromise;
    };
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.AssistantListInstance = AssistantListInstance;
class AssistantPage extends Page_1.default {
    /**
     * Initialize the AssistantPage
     *
     * @param version - Version of the resource
     * @param response - Response from the API
     * @param solution - Path solution
     */
    constructor(version, response, solution) {
        super(version, response, solution);
    }
    /**
     * Build an instance of AssistantInstance
     *
     * @param payload - Payload response from the API
     */
    getInstance(payload) {
        return new AssistantInstance(this._version, payload);
    }
    [util_1.inspect.custom](depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.AssistantPage = AssistantPage;
