"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Flex
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssessmentsListInstance = exports.AssessmentsInstance = exports.AssessmentsContextImpl = void 0;
const util_1 = require("util");
const deserialize = require("../../../base/deserialize");
const serialize = require("../../../base/serialize");
class AssessmentsContextImpl {
    constructor(_version) {
        this._version = _version;
        this._solution = {};
        this._uri = `/Accounts/Assessments`;
    }
    create(callback) {
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.create({
            uri: instance._uri,
            method: "post",
        });
        operationPromise = operationPromise.then((payload) => new AssessmentsInstance(operationVersion, payload));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.AssessmentsContextImpl = AssessmentsContextImpl;
class AssessmentsInstance {
    constructor(_version, payload) {
        this._version = _version;
        this.url = payload.url;
        this._solution = {};
    }
    get _proxy() {
        this._context = this._context || new AssessmentsContextImpl(this._version);
        return this._context;
    }
    /**
     * Create a AssessmentsInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed AssessmentsInstance
     */
    create(callback) {
        return this._proxy.create(callback);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            url: this.url,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.AssessmentsInstance = AssessmentsInstance;
function AssessmentsListInstance(version) {
    const instance = (() => instance.get());
    instance.get = function get() {
        return new AssessmentsContextImpl(version);
    };
    instance._version = version;
    instance._solution = {};
    instance._uri = ``;
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.AssessmentsListInstance = AssessmentsListInstance;
