"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Autopilot
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.RestoreAssistantInstance = exports.RestoreAssistantListInstance = void 0;
const util_1 = require("util");
const deserialize = require("../../../base/deserialize");
const serialize = require("../../../base/serialize");
function RestoreAssistantListInstance(version) {
    const instance = {};
    instance._version = version;
    instance._solution = {};
    instance._uri = `/Assistants/Restore`;
    instance.update = function update(params, callback) {
        if (params === null || params === undefined) {
            throw new Error('Required parameter "params" missing.');
        }
        if (params["assistant"] === null || params["assistant"] === undefined) {
            throw new Error("Required parameter \"params['assistant']\" missing.");
        }
        let data = {};
        data["Assistant"] = params["assistant"];
        const headers = {};
        headers["Content-Type"] = "application/x-www-form-urlencoded";
        let operationVersion = version, operationPromise = operationVersion.update({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new RestoreAssistantInstance(operationVersion, payload));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.RestoreAssistantListInstance = RestoreAssistantListInstance;
class RestoreAssistantInstance {
    constructor(_version, payload) {
        this._version = _version;
        this.accountSid = payload.account_sid;
        this.sid = payload.sid;
        this.dateCreated = deserialize.iso8601DateTime(payload.date_created);
        this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated);
        this.uniqueName = payload.unique_name;
        this.friendlyName = payload.friendly_name;
        this.needsModelBuild = payload.needs_model_build;
        this.latestModelBuildSid = payload.latest_model_build_sid;
        this.logQueries = payload.log_queries;
        this.developmentStage = payload.development_stage;
        this.callbackUrl = payload.callback_url;
        this.callbackEvents = payload.callback_events;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            accountSid: this.accountSid,
            sid: this.sid,
            dateCreated: this.dateCreated,
            dateUpdated: this.dateUpdated,
            uniqueName: this.uniqueName,
            friendlyName: this.friendlyName,
            needsModelBuild: this.needsModelBuild,
            latestModelBuildSid: this.latestModelBuildSid,
            logQueries: this.logQueries,
            developmentStage: this.developmentStage,
            callbackUrl: this.callbackUrl,
            callbackEvents: this.callbackEvents,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.RestoreAssistantInstance = RestoreAssistantInstance;
