"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Oauth
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.TokenInstance = exports.TokenListInstance = void 0;
const util_1 = require("util");
const deserialize = require("../../../base/deserialize");
const serialize = require("../../../base/serialize");
function TokenListInstance(version) {
    const instance = {};
    instance._version = version;
    instance._solution = {};
    instance._uri = `/token`;
    instance.create = function create(params, callback) {
        if (params === null || params === undefined) {
            throw new Error('Required parameter "params" missing.');
        }
        if (params["grantType"] === null || params["grantType"] === undefined) {
            throw new Error("Required parameter \"params['grantType']\" missing.");
        }
        if (params["clientSid"] === null || params["clientSid"] === undefined) {
            throw new Error("Required parameter \"params['clientSid']\" missing.");
        }
        let data = {};
        data["GrantType"] = params["grantType"];
        data["ClientSid"] = params["clientSid"];
        if (params["clientSecret"] !== undefined)
            data["ClientSecret"] = params["clientSecret"];
        if (params["code"] !== undefined)
            data["Code"] = params["code"];
        if (params["codeVerifier"] !== undefined)
            data["CodeVerifier"] = params["codeVerifier"];
        if (params["deviceCode"] !== undefined)
            data["DeviceCode"] = params["deviceCode"];
        if (params["refreshToken"] !== undefined)
            data["RefreshToken"] = params["refreshToken"];
        if (params["deviceId"] !== undefined)
            data["DeviceId"] = params["deviceId"];
        const headers = {};
        headers["Content-Type"] = "application/x-www-form-urlencoded";
        let operationVersion = version, operationPromise = operationVersion.create({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new TokenInstance(operationVersion, payload));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.TokenListInstance = TokenListInstance;
class TokenInstance {
    constructor(_version, payload) {
        this._version = _version;
        this.accessToken = payload.access_token;
        this.refreshToken = payload.refresh_token;
        this.idToken = payload.id_token;
        this.refreshTokenExpiresAt = deserialize.iso8601DateTime(payload.refresh_token_expires_at);
        this.accessTokenExpiresAt = deserialize.iso8601DateTime(payload.access_token_expires_at);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            accessToken: this.accessToken,
            refreshToken: this.refreshToken,
            idToken: this.idToken,
            refreshTokenExpiresAt: this.refreshTokenExpiresAt,
            accessTokenExpiresAt: this.accessTokenExpiresAt,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.TokenInstance = TokenInstance;
