/* amd64-win64.pep.h
   created from amd64-win64.pep.bin, 18665 (0x48e9) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2022 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2022 Laszlo Molnar
   Copyright (C) 2000-2022 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_AMD64_WIN64_PEP_SIZE    18665
#define STUB_AMD64_WIN64_PEP_ADLER32 0xdba68dba
#define STUB_AMD64_WIN64_PEP_CRC32   0xd0d78409

unsigned char stub_amd64_win64_pep[18665] = {
/* 0x0000 */ 127, 69, 76, 70,  2,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 62,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0,  0,  0,  0,  0,  0,  0,200, 17,  0,  0,  0,  0,  0,  0,
/* 0x0030 */   0,  0,  0,  0, 64,  0,  0,  0,  0,  0, 64,  0,  0,  0,  0,  0,
/* 0x0040 */  72,137, 76, 36,  8, 72,137, 84, 36, 16, 76,137, 68, 36, 24, 81,
/* 0x0050 */  82,128,250,  1, 15,133,  0,  0,  0,  0, 83, 86, 87, 85, 72,141,
/* 0x0060 */  53,  0,  0,  0,  0, 72,141,190,  0,  0,  0,  0,102,255,135,  0,
/* 0x0070 */   0,  0,  0,102,129,135,  0,  0,  0,  0,  0,128, 72,141,135,  0,
/* 0x0080 */   0,  0,  0,255, 48,199,  0,  0,  0,  0,128, 80, 87, 49,219, 49,
/* 0x0090 */ 201, 72,131,205,255,232, 80,  0,  0,  0,  1,219,116,  2,243,195,
/* 0x00a0 */ 139, 30, 72,131,238,252, 17,219,138, 22,243,195, 72,141,  4, 47,
/* 0x00b0 */ 131,249,  5,138, 16,118, 33, 72,131,253,252,119, 27,131,233,  4,
/* 0x00c0 */ 139, 16, 72,131,192,  4,131,233,  4,137, 23, 72,141,127,  4,115,
/* 0x00d0 */ 239,131,193,  4,138, 16,116, 16, 72,255,192,136, 23,131,233,  1,
/* 0x00e0 */ 138, 16, 72,141,127,  1,117,240,243,195,252, 65, 91,235,  8, 72,
/* 0x00f0 */ 255,198,136, 23, 72,255,199,138, 22,  1,219,117, 10,139, 30, 72,
/* 0x0100 */ 131,238,252, 17,219,138, 22,114,230,141, 65,  1, 65,255,211, 17,
/* 0x0110 */ 192,  1,219,117, 10,139, 30, 72,131,238,252, 17,219,138, 22,115,
/* 0x0120 */ 235,131,232,  3,114, 19,193,224,  8, 15,182,210,  9,208, 72,255,
/* 0x0130 */ 198,131,240,255,116, 58, 72, 99,232,141, 65,  1, 65,255,211, 17,
/* 0x0140 */ 201, 65,255,211, 17,201,117, 24,137,193,131,192,  2, 65,255,211,
/* 0x0150 */  17,201,  1,219,117,  8,139, 30, 72,131,238,252, 17,219,115,237,
/* 0x0160 */  72,129,253,  0,243,255,255, 17,193,232,  0,  0,  0,  0,235,135,
/* 0x0170 */ 235,  8, 72,255,198,136, 23, 72,255,199,138, 22,  1,219,117, 10,
/* 0x0180 */ 139, 30, 72,131,238,252, 17,219,138, 22,114,230,141, 65,  1,235,
/* 0x0190 */   7,255,200, 65,255,211, 17,192, 65,255,211, 17,192,  1,219,117,
/* 0x01a0 */  10,139, 30, 72,131,238,252, 17,219,138, 22,115,228,131,232,  3,
/* 0x01b0 */ 114, 23,193,224,  8, 15,182,210,  9,208, 72,255,198,131,240,255,
/* 0x01c0 */ 116, 63,209,248, 72, 99,232,235,  3, 65,255,211, 17,201, 65,255,
/* 0x01d0 */ 211, 17,201,117, 24,255,193, 65,255,211, 17,201,  1,219,117,  8,
/* 0x01e0 */ 139, 30, 72,131,238,252, 17,219,115,237,131,193,  2, 72,129,253,
/* 0x01f0 */   0,251,255,255,131,209,  1,232,  0,  0,  0,  0,233,121,255,255,
/* 0x0200 */ 255,235,  8, 72,255,198,136, 23, 72,255,199,138, 22,  1,219,117,
/* 0x0210 */  10,139, 30, 72,131,238,252, 17,219,138, 22,114,230,141, 65,  1,
/* 0x0220 */ 235,  7,255,200, 65,255,211, 17,192, 65,255,211, 17,192,  1,219,
/* 0x0230 */ 117, 10,139, 30, 72,131,238,252, 17,219,138, 22,115,228,131,232,
/* 0x0240 */   3,114, 25,193,224,  8, 15,182,210,  9,208, 72,255,198,131,240,
/* 0x0250 */ 255,116, 88,209,248, 72, 99,232,114, 56,235, 14,  1,219,117,  8,
/* 0x0260 */ 139, 30, 72,131,238,252, 17,219,114, 40,255,193,  1,219,117,  8,
/* 0x0270 */ 139, 30, 72,131,238,252, 17,219,114, 24, 65,255,211, 17,201,  1,
/* 0x0280 */ 219,117,  8,139, 30, 72,131,238,252, 17,219,115,237,131,193,  2,
/* 0x0290 */ 235,  5, 65,255,211, 17,201, 72,129,253,  0,251,255,255,131,209,
/* 0x02a0 */   2,232,  0,  0,  0,  0,233, 96,255,255,255,184,  0,  0,  0,128,
/* 0x02b0 */  80, 72,137,225, 72,137,250, 72,137,247,190,  0,  0,  0,128, 85,
/* 0x02c0 */  72,137,229, 68,139,  9, 73,137,208, 72,137,242, 72,141,119,  2,
/* 0x02d0 */  86,138,  7,255,202,136,193, 36,  7,192,233,  3, 72,199,195,  0,
/* 0x02e0 */ 253,255,255, 72,211,227,136,193, 72,141,156, 92,136,241,255,255,
/* 0x02f0 */  72,131,227,192,106,  0, 72, 57,220,117,249, 83, 72,141,123,  8,
/* 0x0300 */ 138, 78,255,255,202,136, 71,  2,136,200,192,233,  4,136, 79,  1,
/* 0x0310 */  36, 15,136,  7, 72,141, 79,252, 80, 65, 87, 72,141, 71,  4, 69,
/* 0x0320 */  49,255, 65, 86, 65,190,  1,  0,  0,  0, 65, 85, 69, 49,237, 65,
/* 0x0330 */  84, 85, 83, 72,131,236, 72, 72,137, 76, 36, 56, 72,137, 68, 36,
/* 0x0340 */  32,184,  1,  0,  0,  0, 72,137,116, 36, 64, 76,137, 68, 36, 48,
/* 0x0350 */ 137,195, 68,137, 76, 36, 44, 15,182, 79,  2,211,227,137,217, 72,
/* 0x0360 */ 139,156, 36,128,  0,  0,  0,255,201,137, 76, 36, 28, 15,182, 79,
/* 0x0370 */   1,211,224, 72,139, 76, 36, 56,255,200,137, 68, 36, 24, 15,182,
/* 0x0380 */   7,199,  1,  0,  0,  0,  0,199, 68, 36, 16,  0,  0,  0,  0,199,
/* 0x0390 */  68, 36, 12,  1,  0,  0,  0,199, 68, 36,  8,  1,  0,  0,  0,199,
/* 0x03a0 */  68, 36,  4,  1,  0,  0,  0,199,  3,  0,  0,  0,  0,137, 68, 36,
/* 0x03b0 */  20, 15,182, 79,  1,  1,193,184,  0,  3,  0,  0,211,224, 49,201,
/* 0x03c0 */ 141,184, 54,  7,  0,  0, 65, 57,255,115, 19, 72,139, 92, 36, 32,
/* 0x03d0 */ 137,200,255,193, 57,249,102,199,  4, 67,  0,  4,235,235, 72,139,
/* 0x03e0 */ 124, 36, 64,137,208, 69, 49,210, 65,131,203,255, 49,210, 73,137,
/* 0x03f0 */ 252, 73,  1,196, 76, 57,231, 15,132,235,  8,  0,  0, 15,182,  7,
/* 0x0400 */  65,193,226,  8,255,194, 72,255,199, 65,  9,194,131,250,  4,126,
/* 0x0410 */ 227, 68, 59,124, 36, 44, 15,131,214,  8,  0,  0,139, 68, 36, 28,
/* 0x0420 */  72, 99, 92, 36, 16, 72,139, 84, 36, 32, 68, 33,248,137,  4, 36,
/* 0x0430 */  72, 99, 44, 36, 72,137,216, 72,193,224,  4, 72,  1,232, 65,129,
/* 0x0440 */ 251,255,255,255,  0, 76,141, 12, 66,119, 26, 76, 57,231, 15,132,
/* 0x0450 */ 148,  8,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,
/* 0x0460 */ 255,199, 65,  9,194, 65, 15,183, 17, 68,137,216,193,232, 11, 15,
/* 0x0470 */ 183,202, 15,175,193, 65, 57,194, 15,131,197,  1,  0,  0, 65,137,
/* 0x0480 */ 195,184,  0,  8,  0,  0, 72,139, 92, 36, 32, 41,200, 15,182, 76,
/* 0x0490 */  36, 20,190,  1,  0,  0,  0,193,248,  5,141,  4,  2, 65, 15,182,
/* 0x04a0 */ 213,102, 65,137,  1,139, 68, 36, 24, 68, 33,248,211,224,185,  8,
/* 0x04b0 */   0,  0,  0, 43, 76, 36, 20,211,250,  1,208,105,192,  0,  3,  0,
/* 0x04c0 */   0,131,124, 36, 16,  6,137,192, 76,141,140, 67,108, 14,  0,  0,
/* 0x04d0 */  15,142,184,  0,  0,  0, 72,139, 84, 36, 48, 68,137,248, 68, 41,
/* 0x04e0 */ 240, 15,182, 44,  2,  1,237, 72, 99,214,137,235,129,227,  0,  1,
/* 0x04f0 */   0,  0, 65,129,251,255,255,255,  0, 72, 99,195, 73,141,  4, 65,
/* 0x0500 */  76,141,  4, 80,119, 26, 76, 57,231, 15,132,217,  7,  0,  0, 15,
/* 0x0510 */ 182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,
/* 0x0520 */  65, 15,183,144,  0,  2,  0,  0, 68,137,216,193,232, 11, 15,183,
/* 0x0530 */ 202, 15,175,193, 65, 57,194,115, 32, 65,137,195,184,  0,  8,  0,
/* 0x0540 */   0,  1,246, 41,200,193,248,  5,133,219,141,  4,  2,102, 65,137,
/* 0x0550 */ 128,  0,  2,  0,  0,116, 33,235, 45, 65, 41,195, 65, 41,194,137,
/* 0x0560 */ 208,102,193,232,  5,141,116, 54,  1,102, 41,194,133,219,102, 65,
/* 0x0570 */ 137,144,  0,  2,  0,  0,116, 14,129,254,255,  0,  0,  0, 15,142,
/* 0x0580 */  97,255,255,255,235,120,129,254,255,  0,  0,  0,127,112, 72, 99,
/* 0x0590 */ 198, 65,129,251,255,255,255,  0, 77,141,  4, 65,119, 26, 76, 57,
/* 0x05a0 */ 231, 15,132, 65,  7,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,
/* 0x05b0 */ 227,  8, 72,255,199, 65,  9,194, 65, 15,183, 16, 68,137,216,193,
/* 0x05c0 */ 232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 24, 65,137,195,
/* 0x05d0 */ 184,  0,  8,  0,  0,  1,246, 41,200,193,248,  5,141,  4,  2,102,
/* 0x05e0 */  65,137,  0,235,161, 65, 41,195, 65, 41,194,137,208,102,193,232,
/* 0x05f0 */   5,141,116, 54,  1,102, 41,194,102, 65,137, 16,235,136, 72,139,
/* 0x0600 */  76, 36, 48, 68,137,248, 65,255,199, 65,137,245, 64,136, 52,  1,
/* 0x0610 */ 131,124, 36, 16,  3,127, 13,199, 68, 36, 16,  0,  0,  0,  0,233,
/* 0x0620 */ 164,  6,  0,  0,139, 84, 36, 16,139, 68, 36, 16,131,234,  3,131,
/* 0x0630 */ 232,  6,131,124, 36, 16,  9, 15, 79,208,137, 84, 36, 16,233,133,
/* 0x0640 */   6,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102,
/* 0x0650 */  41,194, 72,139, 68, 36, 32, 65,129,251,255,255,255,  0,102, 65,
/* 0x0660 */ 137, 17, 72,141, 52, 88,119, 26, 76, 57,231, 15,132,119,  6,  0,
/* 0x0670 */   0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,
/* 0x0680 */   9,194, 15,183,150,128,  1,  0,  0, 68,137,216,193,232, 11, 15,
/* 0x0690 */ 183,202, 15,175,193, 65, 57,194,115, 78, 65,137,195,184,  0,  8,
/* 0x06a0 */   0,  0, 76,139, 76, 36, 32, 41,200,139, 76, 36, 12, 68,137,116,
/* 0x06b0 */  36, 12,193,248,  5,141,  4,  2,139, 84, 36,  8,137, 76, 36,  8,
/* 0x06c0 */ 102,137,134,128,  1,  0,  0, 49,192,131,124, 36, 16,  6,137, 84,
/* 0x06d0 */  36,  4, 15,159,192, 73,129,193,100,  6,  0,  0,141,  4, 64,137,
/* 0x06e0 */  68, 36, 16,233, 84,  2,  0,  0, 65, 41,195, 65, 41,194,137,208,
/* 0x06f0 */ 102,193,232,  5,102, 41,194, 65,129,251,255,255,255,  0,102,137,
/* 0x0700 */ 150,128,  1,  0,  0,119, 26, 76, 57,231, 15,132,216,  5,  0,  0,
/* 0x0710 */  15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,
/* 0x0720 */ 194, 15,183,150,152,  1,  0,  0, 68,137,216,193,232, 11, 15,183,
/* 0x0730 */ 202, 15,175,193, 65, 57,194, 15,131,208,  0,  0,  0, 65,184,  0,
/* 0x0740 */   8,  0,  0, 65,137,195, 72,193,227,  5, 68,137,192, 41,200,193,
/* 0x0750 */ 248,  5,141,  4,  2,102,137,134,152,  1,  0,  0, 72,139, 68, 36,
/* 0x0760 */  32, 72,  1,216, 65,129,251,255,255,255,  0, 72,141, 52,104,119,
/* 0x0770 */  26, 76, 57,231, 15,132,110,  5,  0,  0, 15,182,  7, 65,193,226,
/* 0x0780 */   8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,150,224,  1,
/* 0x0790 */   0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,
/* 0x07a0 */ 194,115, 79, 65, 41,200, 65,137,195, 65,193,248,  5, 69,133,255,
/* 0x07b0 */  66,141,  4,  2,102,137,134,224,  1,  0,  0, 15,132, 39,  5,  0,
/* 0x07c0 */   0, 49,192,131,124, 36, 16,  6, 72,139, 92, 36, 48, 15,159,192,
/* 0x07d0 */ 141, 68,  0,  9,137, 68, 36, 16, 68,137,248, 68, 41,240, 68, 15,
/* 0x07e0 */ 182, 44,  3, 68,137,248, 65,255,199, 68,136, 44,  3,233,214,  4,
/* 0x07f0 */   0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,
/* 0x0800 */ 194,102,137,150,224,  1,  0,  0,233, 17,  1,  0,  0, 65, 41,195,
/* 0x0810 */  65, 41,194,137,208,102,193,232,  5,102, 41,194, 65,129,251,255,
/* 0x0820 */ 255,255,  0,102,137,150,152,  1,  0,  0,119, 26, 76, 57,231, 15,
/* 0x0830 */ 132,179,  4,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8,
/* 0x0840 */  72,255,199, 65,  9,194, 15,183,150,176,  1,  0,  0, 68,137,216,
/* 0x0850 */ 193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 32, 65,137,
/* 0x0860 */ 195,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,
/* 0x0870 */ 134,176,  1,  0,  0,139, 68, 36, 12,233,152,  0,  0,  0, 65, 41,
/* 0x0880 */ 195, 65, 41,194,137,208,102,193,232,  5,102, 41,194, 65,129,251,
/* 0x0890 */ 255,255,255,  0,102,137,150,176,  1,  0,  0,119, 26, 76, 57,231,
/* 0x08a0 */  15,132, 66,  4,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,
/* 0x08b0 */   8, 72,255,199, 65,  9,194, 15,183,150,200,  1,  0,  0, 68,137,
/* 0x08c0 */ 216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 29, 65,
/* 0x08d0 */ 137,195,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,
/* 0x08e0 */ 137,134,200,  1,  0,  0,139, 68, 36,  8,235, 34, 65, 41,195, 65,
/* 0x08f0 */  41,194,137,208,102,193,232,  5,102, 41,194,139, 68, 36,  4,102,
/* 0x0900 */ 137,150,200,  1,  0,  0,139, 84, 36,  8,137, 84, 36,  4,139, 76,
/* 0x0910 */  36, 12,137, 76, 36,  8, 68,137,116, 36, 12, 65,137,198, 49,192,
/* 0x0920 */ 131,124, 36, 16,  6, 76,139, 76, 36, 32, 15,159,192, 73,129,193,
/* 0x0930 */ 104, 10,  0,  0,141, 68, 64,  8,137, 68, 36, 16, 65,129,251,255,
/* 0x0940 */ 255,255,  0,119, 26, 76, 57,231, 15,132,154,  3,  0,  0, 15,182,
/* 0x0950 */   7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65,
/* 0x0960 */  15,183, 17, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65,
/* 0x0970 */  57,194,115, 38, 65,137,195,184,  0,  8,  0,  0, 69, 49,237, 41,
/* 0x0980 */ 200,193,248,  5,141,  4,  2,102, 65,137,  1, 72, 99,  4, 36, 72,
/* 0x0990 */ 193,224,  4, 77,141, 68,  1,  4,235,119, 65, 41,195, 65, 41,194,
/* 0x09a0 */ 137,208,102,193,232,  5,102, 41,194, 65,129,251,255,255,255,  0,
/* 0x09b0 */ 102, 65,137, 17,119, 26, 76, 57,231, 15,132, 41,  3,  0,  0, 15,
/* 0x09c0 */ 182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,
/* 0x09d0 */  65, 15,183, 81,  2, 68,137,216,193,232, 11, 15,183,202, 15,175,
/* 0x09e0 */ 193, 65, 57,194,115, 51, 65,137,195,184,  0,  8,  0,  0, 65,189,
/* 0x09f0 */   8,  0,  0,  0, 41,200,193,248,  5,141,  4,  2,102, 65,137, 65,
/* 0x0a00 */   2, 72, 99,  4, 36, 72,193,224,  4, 77,141,132,  1,  4,  1,  0,
/* 0x0a10 */   0, 65,185,  3,  0,  0,  0,235, 39, 65, 41,195, 65, 41,194,137,
/* 0x0a20 */ 208,102,193,232,  5, 77,141,129,  4,  2,  0,  0, 65,189, 16,  0,
/* 0x0a30 */   0,  0,102, 41,194,102, 65,137, 81,  2, 65,185,  8,  0,  0,  0,
/* 0x0a40 */  68,137,203,189,  1,  0,  0,  0, 72, 99,197, 65,129,251,255,255,
/* 0x0a50 */ 255,  0, 73,141, 52, 64,119, 26, 76, 57,231, 15,132,135,  2,  0,
/* 0x0a60 */   0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,
/* 0x0a70 */   9,194, 15,183, 14, 68,137,216,193,232, 11, 15,183,209, 15,175,
/* 0x0a80 */ 194, 65, 57,194,115, 23, 65,137,195,184,  0,  8,  0,  0,  1,237,
/* 0x0a90 */  41,208,193,248,  5,141,  4,  1,102,137,  6,235, 22, 65, 41,195,
/* 0x0aa0 */  65, 41,194,137,200,102,193,232,  5,141,108, 45,  1,102, 41,193,
/* 0x0ab0 */ 102,137, 14,255,203,117,145,184,  1,  0,  0,  0, 68,137,201,211,
/* 0x0ac0 */ 224, 41,197, 68,  1,237,131,124, 36, 16,  3, 15,143,194,  1,  0,
/* 0x0ad0 */   0,131, 68, 36, 16,  7,184,  3,  0,  0,  0,131,253,  4, 15, 76,
/* 0x0ae0 */ 197, 72,139, 92, 36, 32, 65,184,  1,  0,  0,  0, 72,152, 72,193,
/* 0x0af0 */ 224,  7, 76,141,140,  3, 96,  3,  0,  0,187,  6,  0,  0,  0, 73,
/* 0x0b00 */  99,192, 65,129,251,255,255,255,  0, 73,141, 52, 65,119, 26, 76,
/* 0x0b10 */  57,231, 15,132,208,  1,  0,  0, 15,182,  7, 65,193,226,  8, 65,
/* 0x0b20 */ 193,227,  8, 72,255,199, 65,  9,194, 15,183, 22, 68,137,216,193,
/* 0x0b30 */ 232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 24, 65,137,195,
/* 0x0b40 */ 184,  0,  8,  0,  0, 69,  1,192, 41,200,193,248,  5,141,  4,  2,
/* 0x0b50 */ 102,137,  6,235, 23, 65, 41,195, 65, 41,194,137,208,102,193,232,
/* 0x0b60 */   5, 71,141, 68,  0,  1,102, 41,194,102,137, 22,255,203,117,143,
/* 0x0b70 */  65,131,232, 64, 65,131,248,  3, 69,137,198, 15,142, 13,  1,  0,
/* 0x0b80 */   0, 65,131,230,  1, 68,137,192,209,248, 65,131,206,  2, 65,131,
/* 0x0b90 */ 248, 13,141,112,255,127, 35,137,241, 72,139, 92, 36, 32, 73, 99,
/* 0x0ba0 */ 192, 65,211,230, 72,  1,192, 68,137,242, 72,141, 20, 83, 72, 41,
/* 0x0bb0 */ 194, 76,141,138, 94,  5,  0,  0,235, 81,141,112,251, 65,129,251,
/* 0x0bc0 */ 255,255,255,  0,119, 26, 76, 57,231, 15,132, 25,  1,  0,  0, 15,
/* 0x0bd0 */ 182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,
/* 0x0be0 */  65,209,235, 69,  1,246, 69, 57,218,114,  7, 69, 41,218, 65,131,
/* 0x0bf0 */ 206,  1,255,206,117,199, 76,139, 76, 36, 32, 65,193,230,  4,190,
/* 0x0c00 */   4,  0,  0,  0, 73,129,193, 68,  6,  0,  0, 65,189,  1,  0,  0,
/* 0x0c10 */   0,187,  1,  0,  0,  0, 72, 99,195, 65,129,251,255,255,255,  0,
/* 0x0c20 */  77,141,  4, 65,119, 26, 76, 57,231, 15,132,185,  0,  0,  0, 15,
/* 0x0c30 */ 182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,
/* 0x0c40 */  65, 15,183, 16, 68,137,216,193,232, 11, 15,183,202, 15,175,193,
/* 0x0c50 */  65, 57,194,115, 24, 65,137,195,184,  0,  8,  0,  0,  1,219, 41,
/* 0x0c60 */ 200,193,248,  5,141,  4,  2,102, 65,137,  0,235, 26, 65, 41,195,
/* 0x0c70 */  65, 41,194,137,208,102,193,232,  5,141, 92, 27,  1, 69,  9,238,
/* 0x0c80 */ 102, 41,194,102, 65,137, 16, 69,  1,237,255,206,117,136, 65,255,
/* 0x0c90 */ 198,116, 64,131,197,  2, 69, 57,254,119, 77, 72,139, 84, 36, 48,
/* 0x0ca0 */  68,137,248, 68, 41,240, 68, 15,182, 44,  2, 68,137,248, 65,255,
/* 0x0cb0 */ 199,255,205, 68,136, 44,  2, 15,149,194, 49,192, 68, 59,124, 36,
/* 0x0cc0 */  44, 15,146,192,133,194,117,211, 68, 59,124, 36, 44, 15,130, 73,
/* 0x0cd0 */ 247,255,255, 65,129,251,255,255,255,  0,119, 22, 76, 57,231,184,
/* 0x0ce0 */   1,  0,  0,  0,116, 38,235,  7,184,  1,  0,  0,  0,235, 29, 72,
/* 0x0cf0 */ 255,199,137,248, 43, 68, 36, 64, 72,139, 76, 36, 56, 72,139,156,
/* 0x0d00 */  36,128,  0,  0,  0,137,  1, 68,137, 59, 49,192, 72,131,196, 72,
/* 0x0d10 */  91, 93, 65, 92, 65, 93, 65, 94, 65, 95, 72,139,117,248, 72,139,
/* 0x0d20 */ 125, 16,139, 75,  4, 72,  1,206,139, 19, 72,  1,215,201,201, 88,
/* 0x0d30 */  94, 95, 88,137,  7, 72,141,190,  0,  0,  0,  0, 72,137,247, 86,
/* 0x0d40 */  72,137,247, 72,199,198,  0,  0,  0,  0,178,  0, 83, 87, 72,141,
/* 0x0d50 */  76, 55,253, 94, 86, 91,235, 47, 72, 57,206,115, 50, 86, 94,172,
/* 0x0d60 */  60,128,114, 10, 60,143,119,  6,128,126,254, 15,116,  6, 44,232,
/* 0x0d70 */  60,  1,119,228, 72, 57,206,115, 22, 86,173, 40,208,117,223, 95,
/* 0x0d80 */  15,200, 41,248,  1,216,171, 72, 57,206,115,  3,172,235,223, 91,
/* 0x0d90 */  94, 72,131,236, 40, 72,141,190,  0,  0,  0,  0,139,  7,  9,192,
/* 0x0da0 */ 116,255,139, 95,  4, 72,141,140, 48,  0,  0,  0,  0, 72,  1,243,
/* 0x0db0 */  72,131,199,  8,255, 21,  0,  0,  0,  0, 72,149,138,  7, 72,255,
/* 0x0dc0 */ 199,  8,192,116,215,121,255,122, 16,139,  7, 72,131,199,  4, 72,
/* 0x0dd0 */ 139,132, 48,  0,  0,  0,  0,235,255, 72, 15,183, 23, 72,131,199,
/* 0x0de0 */   2,235,255, 72,137,249, 72,137,250,255,200,242,174, 72,137,233,
/* 0x0df0 */ 255, 21,  0,  0,  0,  0, 72,  9,192,116,  9, 72,137,  3, 72,131,
/* 0x0e00 */ 195,  8,235,255, 72,131,196, 40, 93, 95, 94, 91, 49,192,195,255,
/* 0x0e10 */  37,  0,  0,  0,  0, 72,131,196, 40, 72,141,190,  0,  0,  0,  0,
/* 0x0e20 */  72,131,199,  4, 72,141, 94,252, 49,192,138,  7, 72,255,199,  9,
/* 0x0e30 */ 192,116,255, 60,239,119, 17, 72,  1,195, 72,139,  3, 72, 15,200,
/* 0x0e40 */  72,  1,240, 72,137,  3,235,224, 36, 15,193,224, 16,102,139,  7,
/* 0x0e50 */  72,131,199,  2,  9,192,117,255,139,  7, 72,131,199,  4,235,255,
/* 0x0e60 */  72,135,247, 72,141,143,  0,  0,  0,  0,235,  4,102,  1, 12,  7,
/* 0x0e70 */ 173,  9,192,117,247,193,233, 16,235,  4,102,  1, 12,  7,173,  9,
/* 0x0e80 */ 192,117,247, 72,139, 45,  0,  0,  0,  0, 72,141,190,  0,  0,  0,
/* 0x0e90 */   0,187,  0,  0,  0,128, 80, 73,137,225, 65,184,  4,  0,  0,  0,
/* 0x0ea0 */  72,137,218, 72,137,249, 72,131,236, 32,255,213, 72,141,135,  0,
/* 0x0eb0 */   0,  0,  0,128, 32,127,128, 96, 40,127, 76,141, 76, 36, 32, 77,
/* 0x0ec0 */ 139,  1, 72,137,218, 72,137,249,255,213, 72,131,196, 40,198,  5,
/* 0x0ed0 */   0,  0,  0,  0,252, 72,141,142,  0,  0,  0,  0,106,  1, 90, 77,
/* 0x0ee0 */  49,192, 80,232,  0,  0,  0,  0, 88, 93, 95, 94, 91, 72,141, 68,
/* 0x0ef0 */  36,128,106,  0, 72, 57,196,117,249, 72,131,236,128, 76,139, 68,
/* 0x0f00 */  36, 24, 72,139, 84, 36, 16, 72,139, 76, 36,  8, 90, 89,106,  1,
/* 0x0f10 */  88,195,233,  0,  0,  0,  0,195, 86, 72,141, 53,  0,  0,  0,  0,
/* 0x0f20 */  72,173, 72,133,192,116, 20, 81, 82, 65, 80, 72,131,236, 40,255,
/* 0x0f30 */ 208, 72,131,196, 40, 65, 88, 90, 89,235,229, 94,195, 85, 80, 88,
/* 0x0f40 */  33,161,216,208,213,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 45,102,105,108,
/* 0x0f60 */ 101, 32,102,111,114,109, 97,116, 32,101,108,102, 54, 52, 45,120,
/* 0x0f70 */  56, 54, 45, 54, 52, 10, 10, 83,101, 99,116,105,111,110,115, 58,
/* 0x0f80 */  10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32, 32, 32,
/* 0x0f90 */  32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86, 77, 65,
/* 0x0fa0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x0fb0 */  77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x0fc0 */  32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,103,110, 32,
/* 0x0fd0 */  32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 83, 84, 65, 82, 84,
/* 0x0fe0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x0ff0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1000 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1010 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 52, 48, 32,
/* 0x1020 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x1030 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 49, 32, 80, 69,
/* 0x1040 */  73, 83, 68, 76, 76, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x1050 */  48, 48, 48,102, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1060 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1070 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1080 */  52, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1090 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 50,
/* 0x10a0 */  32, 80, 69, 73, 83, 69, 70, 73, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x10b0 */  48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x10c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x10d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x10e0 */  48, 48, 48, 52,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x10f0 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x1100 */  32, 32, 51, 32, 80, 69, 73, 83, 68, 76, 76, 49, 32, 32, 32, 32,
/* 0x1110 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48,
/* 0x1120 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1130 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1140 */  48, 48, 48, 48, 48, 48, 53, 49, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1150 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x1160 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 52, 32, 80, 69,
/* 0x1170 */  77, 65, 73, 78, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x1180 */  48, 48, 49, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1190 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x11a0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x11b0 */  53, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x11c0 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x11d0 */  78, 76, 89, 10, 32, 32, 53, 32, 80, 69, 73, 67, 79, 78, 83, 49,
/* 0x11e0 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 55, 32, 32,
/* 0x11f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1200 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1210 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 54, 99, 32, 32, 50, 42,
/* 0x1220 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x1230 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32,
/* 0x1240 */  54, 32, 80, 69, 73, 67, 79, 78, 83, 50, 32, 32, 32, 32, 32, 32,
/* 0x1250 */  48, 48, 48, 48, 48, 48, 48, 57, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1260 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1270 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1280 */  48, 48, 48, 48, 55, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1290 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x12a0 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 55, 32, 80, 69, 84, 76,
/* 0x12b0 */  83, 72, 65, 75, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x12c0 */  49, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x12d0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x12e0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 55, 99,
/* 0x12f0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x1300 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x1310 */  89, 10, 32, 32, 56, 32, 80, 69, 77, 65, 73, 78, 48, 50, 32, 32,
/* 0x1320 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 49, 32, 32, 48, 48,
/* 0x1330 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1340 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1350 */  32, 32, 48, 48, 48, 48, 48, 48, 56, 99, 32, 32, 50, 42, 42, 48,
/* 0x1360 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x1370 */  79, 78, 76, 89, 10, 32, 32, 57, 32, 80, 69, 77, 65, 73, 78, 48,
/* 0x1380 */  51, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1390 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x13a0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x13b0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 56,100, 32, 32, 50,
/* 0x13c0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x13d0 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 48, 32, 78, 82, 86, 95,
/* 0x13e0 */  72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x13f0 */  54, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1400 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1410 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 56,100,
/* 0x1420 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x1430 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 49, 32, 78,
/* 0x1440 */  82, 86, 50, 66, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x1450 */  48, 48, 48, 56, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1460 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1470 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1480 */  48,101,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1490 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x14a0 */  79, 78, 76, 89, 10, 32, 49, 50, 32, 78, 82, 86, 50, 68, 32, 32,
/* 0x14b0 */  32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 57, 49, 32,
/* 0x14c0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x14d0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x14e0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 55, 48, 32, 32, 50,
/* 0x14f0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x1500 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x1510 */  49, 51, 32, 78, 82, 86, 50, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1520 */  32, 48, 48, 48, 48, 48, 48, 97, 97, 32, 32, 48, 48, 48, 48, 48,
/* 0x1530 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1540 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1550 */  48, 48, 48, 48, 50, 48, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x1560 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x1570 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 52, 32, 76, 90, 77,
/* 0x1580 */  65, 95, 72, 69, 65, 68, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x1590 */  48, 49, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x15a0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x15b0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 97,
/* 0x15c0 */  98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x15d0 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x15e0 */  76, 89, 10, 32, 49, 53, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48,
/* 0x15f0 */  48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 53, 97, 32, 32, 48,
/* 0x1600 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1610 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1620 */  48, 32, 32, 48, 48, 48, 48, 48, 50, 98,102, 32, 32, 50, 42, 42,
/* 0x1630 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x1640 */  68, 79, 78, 76, 89, 10, 32, 49, 54, 32, 76, 90, 77, 65, 95, 68,
/* 0x1650 */  69, 67, 50, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 97, 48, 49,
/* 0x1660 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1670 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1680 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 49, 57, 32, 32,
/* 0x1690 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x16a0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 55, 32, 76, 90, 77,
/* 0x16b0 */  65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x16c0 */  48, 49, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x16d0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x16e0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,100, 49,
/* 0x16f0 */  97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1700 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 56, 32,
/* 0x1710 */  76, 90, 77, 65, 95, 84, 65, 73, 76, 32, 32, 32, 32, 32, 48, 48,
/* 0x1720 */  48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1730 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1740 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1750 */  48,100, 50,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1760 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x1770 */  49, 57, 32, 80, 69, 77, 65, 73, 78, 49, 48, 32, 32, 32, 32, 32,
/* 0x1780 */  32, 48, 48, 48, 48, 48, 48, 48, 49, 32, 32, 48, 48, 48, 48, 48,
/* 0x1790 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x17a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x17b0 */  48, 48, 48, 48,100, 51, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x17c0 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x17d0 */  89, 10, 32, 50, 48, 32, 80, 69, 84, 76, 83, 72, 65, 75, 50, 32,
/* 0x17e0 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48,
/* 0x17f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1800 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1810 */  32, 32, 48, 48, 48, 48, 48,100, 51, 49, 32, 32, 50, 42, 42, 48,
/* 0x1820 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x1830 */  79, 78, 76, 89, 10, 32, 50, 49, 32, 80, 69, 67, 84, 84, 80, 79,
/* 0x1840 */  83, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 55, 32,
/* 0x1850 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1860 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1870 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48,100, 51, 53, 32, 32, 50,
/* 0x1880 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x1890 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x18a0 */  50, 50, 32, 80, 69, 67, 84, 84, 78, 85, 76, 32, 32, 32, 32, 32,
/* 0x18b0 */  32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48,
/* 0x18c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x18d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x18e0 */  48, 48, 48, 48,100, 51, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x18f0 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x1900 */  89, 10, 32, 50, 51, 32, 80, 69, 70, 73, 76, 84, 69, 82, 52, 57,
/* 0x1910 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 53, 50, 32, 32, 48, 48,
/* 0x1920 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1930 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1940 */  32, 32, 48, 48, 48, 48, 48,100, 51,102, 32, 32, 50, 42, 42, 48,
/* 0x1950 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x1960 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 52, 32,
/* 0x1970 */  80, 69, 73, 77, 80, 79, 82, 84, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x1980 */  48, 48, 48, 48, 51, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1990 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x19a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x19b0 */  48,100, 57, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x19c0 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x19d0 */  68, 79, 78, 76, 89, 10, 32, 50, 53, 32, 80, 69, 73, 66, 89, 79,
/* 0x19e0 */  82, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50,
/* 0x19f0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1a00 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1a10 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,100, 99, 53, 32, 32,
/* 0x1a20 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x1a30 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x1a40 */  32, 50, 54, 32, 80, 69, 75, 51, 50, 79, 82, 68, 32, 32, 32, 32,
/* 0x1a50 */  32, 32, 48, 48, 48, 48, 48, 48, 49, 50, 32, 32, 48, 48, 48, 48,
/* 0x1a60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1a70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1a80 */  48, 48, 48, 48, 48,100, 99, 55, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1a90 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x1aa0 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 55, 32, 80, 69,
/* 0x1ab0 */  73, 77, 79, 82, 68, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x1ac0 */  48, 48, 48, 97, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ad0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ae0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,100,
/* 0x1af0 */ 100, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1b00 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x1b10 */  78, 76, 89, 10, 32, 50, 56, 32, 80, 69, 73, 77, 80, 79, 82, 50,
/* 0x1b20 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50, 49, 32, 32,
/* 0x1b30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1b40 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1b50 */  48, 48, 32, 32, 48, 48, 48, 48, 48,100,101, 51, 32, 32, 50, 42,
/* 0x1b60 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x1b70 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50,
/* 0x1b80 */  57, 32, 80, 69, 73, 69, 82, 68, 76, 76, 32, 32, 32, 32, 32, 32,
/* 0x1b90 */  48, 48, 48, 48, 48, 48, 48, 98, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1ba0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1bb0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1bc0 */  48, 48, 48,101, 48, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1bd0 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x1be0 */  10, 32, 51, 48, 32, 80, 69, 73, 69, 82, 69, 88, 69, 32, 32, 32,
/* 0x1bf0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48, 48, 48,
/* 0x1c00 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1c10 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1c20 */  32, 48, 48, 48, 48, 48,101, 48,102, 32, 32, 50, 42, 42, 48, 32,
/* 0x1c30 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x1c40 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 49, 32, 80,
/* 0x1c50 */  69, 73, 77, 68, 79, 78, 69, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x1c60 */  48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1c70 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1c80 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1c90 */ 101, 49, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1ca0 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51,
/* 0x1cb0 */  50, 32, 80, 69, 82, 69, 76, 79, 67, 49, 32, 32, 32, 32, 32, 32,
/* 0x1cc0 */  48, 48, 48, 48, 48, 48, 48, 55, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1cd0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1ce0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1cf0 */  48, 48, 48,101, 49, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1d00 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x1d10 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 51, 32, 80, 69, 82, 69,
/* 0x1d20 */  76, 79, 67, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1d30 */  48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d40 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d50 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,101, 50, 48,
/* 0x1d60 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x1d70 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 52, 32, 80,
/* 0x1d80 */  69, 82, 69, 76, 79, 67, 51, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x1d90 */  48, 48, 48, 51, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1da0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1db0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1dc0 */ 101, 50, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1dd0 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x1de0 */  79, 78, 76, 89, 10, 32, 51, 53, 32, 82, 69, 76, 54, 52, 66, 73,
/* 0x1df0 */  71, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 97, 32,
/* 0x1e00 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e10 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e20 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48,101, 53, 52, 32, 32, 50,
/* 0x1e30 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x1e40 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x1e50 */  51, 54, 32, 82, 69, 76, 79, 67, 54, 52, 74, 32, 32, 32, 32, 32,
/* 0x1e60 */  32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48,
/* 0x1e70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1e80 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1e90 */  48, 48, 48, 48,101, 53,101, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x1ea0 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x1eb0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 55, 32, 80, 69, 82,
/* 0x1ec0 */  76, 79, 72, 73, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x1ed0 */  48, 48, 97, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ee0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ef0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,101, 54,
/* 0x1f00 */  48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1f10 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x1f20 */  76, 89, 10, 32, 51, 56, 32, 80, 69, 82, 69, 76, 76, 79, 48, 32,
/* 0x1f30 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 98, 32, 32, 48,
/* 0x1f40 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1f50 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1f60 */  48, 32, 32, 48, 48, 48, 48, 48,101, 54, 97, 32, 32, 50, 42, 42,
/* 0x1f70 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x1f80 */  68, 79, 78, 76, 89, 10, 32, 51, 57, 32, 80, 69, 82, 69, 76, 72,
/* 0x1f90 */  73, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,101,
/* 0x1fa0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1fb0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1fc0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,101, 55, 53, 32, 32,
/* 0x1fd0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x1fe0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 48, 32, 80, 69, 68,
/* 0x1ff0 */  69, 80, 72, 65, 75, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x2000 */  48, 52, 98, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2010 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2020 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,101, 56,
/* 0x2030 */  51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2040 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x2050 */  76, 89, 10, 32, 52, 49, 32, 80, 69, 84, 76, 83, 67, 32, 32, 32,
/* 0x2060 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 98, 32, 32, 48,
/* 0x2070 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2080 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2090 */  48, 32, 32, 48, 48, 48, 48, 48,101, 99,101, 32, 32, 50, 42, 42,
/* 0x20a0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x20b0 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 50,
/* 0x20c0 */  32, 80, 69, 77, 65, 73, 78, 50, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x20d0 */  48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x20e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x20f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2100 */  48, 48,101,101, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2110 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x2120 */  32, 52, 51, 32, 67, 76, 69, 65, 82, 83, 84, 65, 67, 75, 32, 32,
/* 0x2130 */  32, 32, 48, 48, 48, 48, 48, 48, 49, 48, 32, 32, 48, 48, 48, 48,
/* 0x2140 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2150 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2160 */  48, 48, 48, 48, 48,101,101,100, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2170 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x2180 */  76, 89, 10, 32, 52, 52, 32, 80, 69, 77, 65, 73, 78, 50, 49, 32,
/* 0x2190 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x21a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x21b0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x21c0 */  48, 32, 32, 48, 48, 48, 48, 48,101,102,100, 32, 32, 50, 42, 42,
/* 0x21d0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x21e0 */  68, 79, 78, 76, 89, 10, 32, 52, 53, 32, 80, 69, 73, 83, 68, 76,
/* 0x21f0 */  76, 57, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102,
/* 0x2200 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2210 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2220 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,101,102,100, 32, 32,
/* 0x2230 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x2240 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 54, 32, 80, 69, 73,
/* 0x2250 */  83, 69, 70, 73, 57, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x2260 */  48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2270 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2280 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,102, 48,
/* 0x2290 */  99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x22a0 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 55, 32,
/* 0x22b0 */  80, 69, 82, 69, 84, 85, 82, 78, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x22c0 */  48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x22d0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x22e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x22f0 */  48,102, 48,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2300 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x2310 */  52, 56, 32, 80, 69, 68, 79, 74, 85, 77, 80, 32, 32, 32, 32, 32,
/* 0x2320 */  32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48,
/* 0x2330 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2340 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2350 */  48, 48, 48, 48,102, 49, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2360 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x2370 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 57, 32, 80, 69, 84,
/* 0x2380 */  76, 83, 67, 50, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x2390 */  48, 50, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x23a0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x23b0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,102, 49,
/* 0x23c0 */  55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x23d0 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x23e0 */  76, 89, 10, 32, 53, 48, 32, 85, 80, 88, 49, 72, 69, 65, 68, 32,
/* 0x23f0 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50, 48, 32, 32, 48,
/* 0x2400 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2410 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2420 */  48, 32, 32, 48, 48, 48, 48, 48,102, 51,100, 32, 32, 50, 42, 42,
/* 0x2430 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x2440 */  68, 79, 78, 76, 89, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66,
/* 0x2450 */  76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2460 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86,
/* 0x2470 */  95, 72, 69, 65, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2480 */  48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 95, 72, 69, 65, 68, 10,
/* 0x2490 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x24a0 */  32,108, 32, 32, 32, 32, 32, 32, 32, 80, 69, 73, 77, 68, 79, 78,
/* 0x24b0 */  69,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x24c0 */  48, 48, 32,105,109,112,111,114,116,115, 95,100,111,110,101, 10,
/* 0x24d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 98,
/* 0x24e0 */  32,108, 32, 32, 32, 32, 32, 32, 32, 80, 69, 73, 77, 80, 79, 82,
/* 0x24f0 */  84,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2500 */  48, 48, 32,110,101,120,116, 95,102,117,110, 99, 10, 48, 48, 48,
/* 0x2510 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 97, 32,108, 32,
/* 0x2520 */  32, 32, 32, 32, 32, 32, 80, 69, 73, 77, 79, 82, 68, 49,  9, 48,
/* 0x2530 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2540 */  98,121,110, 97,109,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2550 */  48, 48, 48, 48, 48, 49, 56, 32,108, 32, 32, 32, 32, 32, 32, 32,
/* 0x2560 */  80, 69, 73, 77, 80, 79, 82, 50,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x2570 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,110,101,120,116, 95,105,
/* 0x2580 */ 109,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2590 */  48, 48, 97, 32,108, 32, 32, 32, 32, 32, 32, 32, 80, 69, 73, 77,
/* 0x25a0 */  80, 79, 82, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x25b0 */  48, 48, 48, 48, 48, 32,102,105,114,115,116, 95,105,109,112, 10,
/* 0x25c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50,
/* 0x25d0 */  32,108, 32, 32, 32, 32, 32, 32, 32, 82, 69, 76, 79, 67, 54, 52,
/* 0x25e0 */  74,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x25f0 */  48, 48, 32,114,101,108,111, 99, 95,101,110,100,120, 10, 48, 48,
/* 0x2600 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 51, 32,108,
/* 0x2610 */  32, 32, 32, 32, 32, 32, 32, 80, 69, 82, 69, 76, 79, 67, 51,  9,
/* 0x2620 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2630 */  32,114,101,108,111, 99, 95, 97,100,100, 10, 48, 48, 48, 48, 48,
/* 0x2640 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x2650 */  32,100, 32, 32, 80, 69, 84, 76, 83, 67, 50,  9, 48, 48, 48, 48,
/* 0x2660 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 84,
/* 0x2670 */  76, 83, 67, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2680 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69,
/* 0x2690 */  77, 65, 73, 78, 50, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x26a0 */  48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 77, 65, 73, 78, 50, 49,
/* 0x26b0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x26c0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 83, 84, 65, 82, 84,  9,
/* 0x26d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x26e0 */  32, 83, 84, 65, 82, 84, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x26f0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x2700 */  80, 69, 73, 83, 68, 76, 76, 48,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x2710 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 73, 83, 68, 76,
/* 0x2720 */  76, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2730 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 83,
/* 0x2740 */  69, 70, 73, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2750 */  48, 48, 48, 48, 48, 32, 80, 69, 73, 83, 69, 70, 73, 48, 10, 48,
/* 0x2760 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2770 */ 108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 83, 68, 76, 76, 49,
/* 0x2780 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2790 */  48, 32, 80, 69, 73, 83, 68, 76, 76, 49, 10, 48, 48, 48, 48, 48,
/* 0x27a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x27b0 */  32,100, 32, 32, 80, 69, 77, 65, 73, 78, 48, 49,  9, 48, 48, 48,
/* 0x27c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69,
/* 0x27d0 */  77, 65, 73, 78, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x27e0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x27f0 */  80, 69, 73, 67, 79, 78, 83, 49,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x2800 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 73, 67, 79, 78,
/* 0x2810 */  83, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2820 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 67,
/* 0x2830 */  79, 78, 83, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2840 */  48, 48, 48, 48, 48, 32, 80, 69, 73, 67, 79, 78, 83, 50, 10, 48,
/* 0x2850 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2860 */ 108, 32, 32, 32, 32,100, 32, 32, 80, 69, 84, 76, 83, 72, 65, 75,
/* 0x2870 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2880 */  48, 32, 80, 69, 84, 76, 83, 72, 65, 75, 10, 48, 48, 48, 48, 48,
/* 0x2890 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x28a0 */  32,100, 32, 32, 80, 69, 77, 65, 73, 78, 48, 50,  9, 48, 48, 48,
/* 0x28b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69,
/* 0x28c0 */  77, 65, 73, 78, 48, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x28d0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x28e0 */  80, 69, 77, 65, 73, 78, 48, 51,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x28f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 77, 65, 73, 78,
/* 0x2900 */  48, 51, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2910 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50,
/* 0x2920 */  66,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2930 */  48, 48, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x2940 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x2950 */  32, 32, 78, 82, 86, 50, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2960 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 68, 10, 48,
/* 0x2970 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2980 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69,  9, 48, 48,
/* 0x2990 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x29a0 */  82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x29b0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90,
/* 0x29c0 */  77, 65, 95, 72, 69, 65, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x29d0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 72, 69,
/* 0x29e0 */  65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x29f0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65,
/* 0x2a00 */  95, 69, 76, 70, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2a10 */  48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70,
/* 0x2a20 */  48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2a30 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65,
/* 0x2a40 */  95, 68, 69, 67, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2a50 */  48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2a60 */  50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2a70 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65,
/* 0x2a80 */  95, 68, 69, 67, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2a90 */  48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2aa0 */  51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2ab0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65,
/* 0x2ac0 */  95, 84, 65, 73, 76,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2ad0 */  48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 84, 65, 73, 76,
/* 0x2ae0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2af0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 77, 65, 73, 78,
/* 0x2b00 */  49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2b10 */  48, 48, 48, 32, 80, 69, 77, 65, 73, 78, 49, 48, 10, 48, 48, 48,
/* 0x2b20 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x2b30 */  32, 32, 32,100, 32, 32, 80, 69, 84, 76, 83, 72, 65, 75, 50,  9,
/* 0x2b40 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2b50 */  32, 80, 69, 84, 76, 83, 72, 65, 75, 50, 10, 48, 48, 48, 48, 48,
/* 0x2b60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x2b70 */  32,100, 32, 32, 80, 69, 67, 84, 84, 80, 79, 83,  9, 48, 48, 48,
/* 0x2b80 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69,
/* 0x2b90 */  67, 84, 84, 80, 79, 83, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2ba0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x2bb0 */  80, 69, 67, 84, 84, 78, 85, 76,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x2bc0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 67, 84, 84, 78,
/* 0x2bd0 */  85, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2be0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 70, 73,
/* 0x2bf0 */  76, 84, 69, 82, 52, 57,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2c00 */  48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 70, 73, 76, 84, 69, 82,
/* 0x2c10 */  52, 57, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2c20 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 77,
/* 0x2c30 */  80, 79, 82, 84,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2c40 */  48, 48, 48, 48, 48, 32, 80, 69, 73, 77, 80, 79, 82, 84, 10, 48,
/* 0x2c50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2c60 */ 108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 66, 89, 79, 82, 68,
/* 0x2c70 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2c80 */  48, 32, 80, 69, 73, 66, 89, 79, 82, 68, 10, 48, 48, 48, 48, 48,
/* 0x2c90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x2ca0 */  32,100, 32, 32, 80, 69, 75, 51, 50, 79, 82, 68,  9, 48, 48, 48,
/* 0x2cb0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69,
/* 0x2cc0 */  75, 51, 50, 79, 82, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2cd0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x2ce0 */  80, 69, 73, 77, 79, 82, 68, 49,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x2cf0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 73, 77, 79, 82,
/* 0x2d00 */  68, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2d10 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 77,
/* 0x2d20 */  80, 79, 82, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2d30 */  48, 48, 48, 48, 48, 32, 80, 69, 73, 77, 80, 79, 82, 50, 10, 48,
/* 0x2d40 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2d50 */ 108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 69, 82, 68, 76, 76,
/* 0x2d60 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2d70 */  48, 32, 80, 69, 73, 69, 82, 68, 76, 76, 10, 48, 48, 48, 48, 48,
/* 0x2d80 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x2d90 */  32,100, 32, 32, 80, 69, 73, 69, 82, 69, 88, 69,  9, 48, 48, 48,
/* 0x2da0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69,
/* 0x2db0 */  73, 69, 82, 69, 88, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2dc0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x2dd0 */  80, 69, 73, 77, 68, 79, 78, 69,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x2de0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 73, 77, 68, 79,
/* 0x2df0 */  78, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2e00 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 82, 69,
/* 0x2e10 */  76, 79, 67, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2e20 */  48, 48, 48, 48, 48, 32, 80, 69, 82, 69, 76, 79, 67, 49, 10, 48,
/* 0x2e30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2e40 */ 108, 32, 32, 32, 32,100, 32, 32, 80, 69, 82, 69, 76, 79, 67, 50,
/* 0x2e50 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2e60 */  48, 32, 80, 69, 82, 69, 76, 79, 67, 50, 10, 48, 48, 48, 48, 48,
/* 0x2e70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x2e80 */  32,100, 32, 32, 80, 69, 82, 69, 76, 79, 67, 51,  9, 48, 48, 48,
/* 0x2e90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69,
/* 0x2ea0 */  82, 69, 76, 79, 67, 51, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2eb0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x2ec0 */  82, 69, 76, 54, 52, 66, 73, 71,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x2ed0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 69, 76, 54, 52, 66,
/* 0x2ee0 */  73, 71, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2ef0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 82, 69, 76, 79,
/* 0x2f00 */  67, 54, 52, 74,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2f10 */  48, 48, 48, 48, 48, 32, 82, 69, 76, 79, 67, 54, 52, 74, 10, 48,
/* 0x2f20 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2f30 */ 108, 32, 32, 32, 32,100, 32, 32, 80, 69, 82, 76, 79, 72, 73, 48,
/* 0x2f40 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2f50 */  48, 32, 80, 69, 82, 76, 79, 72, 73, 48, 10, 48, 48, 48, 48, 48,
/* 0x2f60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x2f70 */  32,100, 32, 32, 80, 69, 82, 69, 76, 76, 79, 48,  9, 48, 48, 48,
/* 0x2f80 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69,
/* 0x2f90 */  82, 69, 76, 76, 79, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2fa0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x2fb0 */  80, 69, 82, 69, 76, 72, 73, 48,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x2fc0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 82, 69, 76, 72,
/* 0x2fd0 */  73, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2fe0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 68, 69,
/* 0x2ff0 */  80, 72, 65, 75,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3000 */  48, 48, 48, 48, 48, 32, 80, 69, 68, 69, 80, 72, 65, 75, 10, 48,
/* 0x3010 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3020 */ 108, 32, 32, 32, 32,100, 32, 32, 80, 69, 84, 76, 83, 67,  9, 48,
/* 0x3030 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3040 */  80, 69, 84, 76, 83, 67, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3050 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3060 */  80, 69, 77, 65, 73, 78, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x3070 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 77, 65, 73, 78,
/* 0x3080 */  50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3090 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 76, 69, 65,
/* 0x30a0 */  82, 83, 84, 65, 67, 75,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x30b0 */  48, 48, 48, 48, 48, 48, 48, 32, 67, 76, 69, 65, 82, 83, 84, 65,
/* 0x30c0 */  67, 75, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x30d0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 83,
/* 0x30e0 */  68, 76, 76, 57,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x30f0 */  48, 48, 48, 48, 48, 32, 80, 69, 73, 83, 68, 76, 76, 57, 10, 48,
/* 0x3100 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3110 */ 108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 83, 69, 70, 73, 57,
/* 0x3120 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3130 */  48, 32, 80, 69, 73, 83, 69, 70, 73, 57, 10, 48, 48, 48, 48, 48,
/* 0x3140 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3150 */  32,100, 32, 32, 80, 69, 82, 69, 84, 85, 82, 78,  9, 48, 48, 48,
/* 0x3160 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69,
/* 0x3170 */  82, 69, 84, 85, 82, 78, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3180 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3190 */  80, 69, 68, 79, 74, 85, 77, 80,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x31a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 68, 79, 74, 85,
/* 0x31b0 */  77, 80, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x31c0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 85, 80, 88, 49,
/* 0x31d0 */  72, 69, 65, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x31e0 */  48, 48, 48, 48, 48, 32, 85, 80, 88, 49, 72, 69, 65, 68, 10, 48,
/* 0x31f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3200 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48,
/* 0x3210 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,115,
/* 0x3220 */ 116, 97,114,116, 95,111,102, 95, 99,111,109,112,114,101,115,115,
/* 0x3230 */ 101,100, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3240 */  48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,
/* 0x3250 */  42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3260 */  48, 48, 32,115,116, 97,114,116, 95,111,102, 95,117,110, 99,111,
/* 0x3270 */ 109,112,114,101,115,115,101,100, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3280 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,
/* 0x3290 */  32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x32a0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,105, 99,111,110, 95,111,102,
/* 0x32b0 */ 102,115,101,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x32c0 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x32d0 */  78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x32e0 */  48, 48, 48, 48, 32,105, 99,111,110, 95,100,101,108,116, 97, 10,
/* 0x32f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3300 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48,
/* 0x3310 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3320 */ 116,108,115, 95, 97,100,100,114,101,115,115, 10, 48, 48, 48, 48,
/* 0x3330 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x3340 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48,
/* 0x3350 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,116,108,115, 95,
/* 0x3360 */ 118, 97,108,117,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3370 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x3380 */  85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3390 */  48, 48, 48, 48, 48, 32,108,122,109, 97, 95,117, 95,108,101,110,
/* 0x33a0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x33b0 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,
/* 0x33c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x33d0 */  32,108,122,109, 97, 95, 99, 95,108,101,110, 10, 48, 48, 48, 48,
/* 0x33e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x33f0 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48,
/* 0x3400 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,108,116,
/* 0x3410 */ 101,114, 95, 98,117,102,102,101,114, 95,115,116, 97,114,116, 10,
/* 0x3420 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3430 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48,
/* 0x3440 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3450 */ 102,105,108,116,101,114, 95,108,101,110,103,116,104, 10, 48, 48,
/* 0x3460 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3470 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48,
/* 0x3480 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,
/* 0x3490 */ 108,116,101,114, 95, 99,116,111, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x34a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,
/* 0x34b0 */  32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x34c0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 99,111,109,112,114,101,115,
/* 0x34d0 */ 115,101,100, 95,105,109,112,111,114,116,115, 10, 48, 48, 48, 48,
/* 0x34e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x34f0 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48,
/* 0x3500 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,115,116, 97,114,
/* 0x3510 */ 116, 95,111,102, 95,105,109,112,111,114,116,115, 10, 48, 48, 48,
/* 0x3520 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,
/* 0x3530 */  32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48,
/* 0x3540 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,111, 97,
/* 0x3550 */ 100, 76,105, 98,114, 97,114,121, 65, 10, 48, 48, 48, 48, 48, 48,
/* 0x3560 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x3570 */  32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x3580 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,107,101,114,110,101,108,
/* 0x3590 */  51, 50, 95,111,114,100,105,110, 97,108,115, 10, 48, 48, 48, 48,
/* 0x35a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x35b0 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48,
/* 0x35c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 71,101,116, 80,
/* 0x35d0 */ 114,111, 99, 65,100,100,114,101,115,115, 10, 48, 48, 48, 48, 48,
/* 0x35e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x35f0 */  32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48,
/* 0x3600 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69,120,105,116, 80,
/* 0x3610 */ 114,111, 99,101,115,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3620 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3630 */  42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3640 */  48, 48, 48, 48, 48, 48, 32,115,116, 97,114,116, 95,111,102, 95,
/* 0x3650 */ 114,101,108,111, 99,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3660 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3670 */  42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3680 */  48, 48, 48, 48, 48, 48, 32,114,101,108,111, 99, 95,100,101,108,
/* 0x3690 */ 116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x36a0 */  48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,
/* 0x36b0 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x36c0 */  48, 32, 86,105,114,116,117, 97,108, 80,114,111,116,101, 99,116,
/* 0x36d0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x36e0 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,
/* 0x36f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3700 */  32,118,112, 95, 98, 97,115,101, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3710 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,
/* 0x3720 */  32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3730 */  48, 48, 48, 48, 48, 48, 48, 48, 32,118,112, 95,115,105,122,101,
/* 0x3740 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3750 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,
/* 0x3760 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3770 */  32,115,119,114,105, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3780 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x3790 */  85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x37a0 */  48, 48, 48, 48, 48, 32,116,108,115, 95,109,111,100,117,108,101,
/* 0x37b0 */  95, 98, 97,115,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x37c0 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x37d0 */  85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x37e0 */  48, 48, 48, 48, 48, 32,111,114,105,103,105,110, 97,108, 95,101,
/* 0x37f0 */ 110,116,114,121, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3800 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x3810 */  78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3820 */  48, 48, 48, 48, 32,116,108,115, 95, 99, 97,108,108, 98, 97, 99,
/* 0x3830 */ 107,115, 95,112,116,114, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x3840 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x3850 */  80, 69, 73, 83, 68, 76, 76, 49, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x3860 */  84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69,
/* 0x3870 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x3880 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3890 */  48, 48, 48, 53, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67,
/* 0x38a0 */  51, 50, 32, 32, 32, 32, 32, 80, 69, 77, 65, 73, 78, 50, 49, 45,
/* 0x38b0 */  48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x38c0 */  48, 52, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x38d0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 77, 65,
/* 0x38e0 */  73, 78, 48, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x38f0 */  32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x3900 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x3910 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55,
/* 0x3920 */  32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32,
/* 0x3930 */  32, 32, 32,115,116, 97,114,116, 95,111,102, 95, 99,111,109,112,
/* 0x3940 */ 114,101,115,115,101,100, 45, 48,120, 48, 48, 48, 48, 48, 48, 48,
/* 0x3950 */  48, 48, 48, 48, 48, 48, 48, 48, 52, 10, 48, 48, 48, 48, 48, 48,
/* 0x3960 */  48, 48, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 88, 56, 54,
/* 0x3970 */  95, 54, 52, 95, 51, 50, 83, 32, 32, 32, 32, 32, 32,115,116, 97,
/* 0x3980 */ 114,116, 95,111,102, 95,117,110, 99,111,109,112,114,101,115,115,
/* 0x3990 */ 101,100, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x39a0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 73, 67,
/* 0x39b0 */  79, 78, 83, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x39c0 */  32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x39d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x39e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51,
/* 0x39f0 */  32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 83, 32, 32, 32,
/* 0x3a00 */  32, 32, 32,105, 99,111,110, 95,111,102,102,115,101,116, 10, 10,
/* 0x3a10 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x3a20 */  68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 73, 67, 79, 78, 83, 50,
/* 0x3a30 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32,
/* 0x3a40 */  32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3a50 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x3a60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 88,
/* 0x3a70 */  56, 54, 95, 54, 52, 95, 51, 50, 83, 32, 32, 32, 32, 32, 32,105,
/* 0x3a80 */  99,111,110, 95,111,102,102,115,101,116, 10, 48, 48, 48, 48, 48,
/* 0x3a90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 32, 82, 95, 88, 56,
/* 0x3aa0 */  54, 95, 54, 52, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32,105, 99,
/* 0x3ab0 */ 111,110, 95,100,101,108,116, 97, 43, 48,120, 48, 48, 48, 48, 48,
/* 0x3ac0 */  48, 48, 48, 48, 48, 48, 48, 56, 48, 48, 48, 10, 10, 82, 69, 76,
/* 0x3ad0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x3ae0 */  70, 79, 82, 32, 91, 80, 69, 84, 76, 83, 72, 65, 75, 93, 58, 10,
/* 0x3af0 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3b00 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3b10 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b20 */  48, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 88, 56, 54, 95,
/* 0x3b30 */  54, 52, 95, 51, 50, 83, 32, 32, 32, 32, 32, 32,116,108,115, 95,
/* 0x3b40 */  97,100,100,114,101,115,115, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b50 */  48, 48, 48, 48, 48, 48, 48, 98, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x3b60 */  52, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,116,108,115, 95,118,
/* 0x3b70 */  97,108,117,101, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 56,
/* 0x3b80 */  48, 48, 48, 48, 48, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x3b90 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x3ba0 */  91, 78, 82, 86, 50, 66, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x3bb0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x3bc0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x3bd0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3be0 */  55,100, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50,
/* 0x3bf0 */  32, 32, 32, 32, 32, 78, 82, 86, 95, 72, 69, 65, 68, 43, 48,120,
/* 0x3c00 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 98,
/* 0x3c10 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x3c20 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 68, 93,
/* 0x3c30 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3c40 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3c50 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x3c60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 56, 56, 32, 82, 95, 88, 56,
/* 0x3c70 */  54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 78, 82,
/* 0x3c80 */  86, 95, 72, 69, 65, 68, 43, 48,120, 48, 48, 48, 48, 48, 48, 48,
/* 0x3c90 */  48, 48, 48, 48, 48, 48, 48, 49, 98, 10, 10, 82, 69, 76, 79, 67,
/* 0x3ca0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x3cb0 */  82, 32, 91, 78, 82, 86, 50, 69, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x3cc0 */  84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69,
/* 0x3cd0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x3ce0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3cf0 */  48, 48, 97, 49, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67,
/* 0x3d00 */  51, 50, 32, 32, 32, 32, 32, 78, 82, 86, 95, 72, 69, 65, 68, 43,
/* 0x3d10 */  48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d20 */  49, 98, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x3d30 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65,
/* 0x3d40 */  95, 72, 69, 65, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x3d50 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x3d60 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x3d70 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d80 */  49, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 32, 32, 32,
/* 0x3d90 */  32, 32, 32, 32,108,122,109, 97, 95,117, 95,108,101,110, 43, 48,
/* 0x3da0 */ 120, 48, 48, 48, 48, 48, 48, 48, 48, 56, 48, 48, 48, 48, 48, 48,
/* 0x3db0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3dc0 */  49, 48, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 32, 32,
/* 0x3dd0 */  32, 32, 32, 32, 32,108,122,109, 97, 95, 99, 95,108,101,110, 43,
/* 0x3de0 */  48,120, 48, 48, 48, 48, 48, 48, 48, 48, 56, 48, 48, 48, 48, 48,
/* 0x3df0 */  48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x3e00 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 67, 84,
/* 0x3e10 */  84, 80, 79, 83, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x3e20 */  32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x3e30 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x3e40 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51,
/* 0x3e50 */  32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 83, 32, 32, 32,
/* 0x3e60 */  32, 32, 32,102,105,108,116,101,114, 95, 98,117,102,102,101,114,
/* 0x3e70 */  95,115,116, 97,114,116, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x3e80 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x3e90 */  80, 69, 70, 73, 76, 84, 69, 82, 52, 57, 93, 58, 10, 79, 70, 70,
/* 0x3ea0 */  83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89,
/* 0x3eb0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3ec0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ed0 */  48, 48, 48, 48, 48, 55, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x3ee0 */  51, 50, 83, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95,
/* 0x3ef0 */ 108,101,110,103,116,104, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f00 */  48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 88, 56, 54, 95, 54, 52,
/* 0x3f10 */  95, 56, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114,
/* 0x3f20 */  95, 99,116,111, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x3f30 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69,
/* 0x3f40 */  73, 77, 80, 79, 82, 84, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x3f50 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x3f60 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x3f70 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f80 */  48, 55, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 83, 32,
/* 0x3f90 */  32, 32, 32, 32, 32, 99,111,109,112,114,101,115,115,101,100, 95,
/* 0x3fa0 */ 105,109,112,111,114,116,115, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3fb0 */  48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x3fc0 */  52, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,105,109,112,111,114,
/* 0x3fd0 */ 116,115, 95,100,111,110,101, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3fe0 */  48, 48, 48, 48, 48, 48, 49, 56, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x3ff0 */  52, 95, 51, 50, 83, 32, 32, 32, 32, 32, 32,115,116, 97,114,116,
/* 0x4000 */  95,111,102, 95,105,109,112,111,114,116,115, 10, 48, 48, 48, 48,
/* 0x4010 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 53, 32, 82, 95, 88,
/* 0x4020 */  56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 76,
/* 0x4030 */ 111, 97,100, 76,105, 98,114, 97,114,121, 65, 45, 48,120, 48, 48,
/* 0x4040 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 10, 10,
/* 0x4050 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4060 */  68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 73, 66, 89, 79, 82, 68,
/* 0x4070 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32,
/* 0x4080 */  32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4090 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x40a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 88,
/* 0x40b0 */  56, 54, 95, 54, 52, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 98,
/* 0x40c0 */ 121,110, 97,109,101, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x40d0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80,
/* 0x40e0 */  69, 75, 51, 50, 79, 82, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x40f0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x4100 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x4110 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4120 */  48, 48, 99, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 83,
/* 0x4130 */  32, 32, 32, 32, 32, 32,107,101,114,110,101,108, 51, 50, 95,111,
/* 0x4140 */ 114,100,105,110, 97,108,115, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4150 */  48, 48, 48, 48, 48, 48, 49, 49, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x4160 */  52, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,110,101,120,116, 95,
/* 0x4170 */ 105,109,112, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x4180 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 73,
/* 0x4190 */  77, 79, 82, 68, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x41a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x41b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x41c0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x41d0 */  57, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 56, 32, 32,
/* 0x41e0 */  32, 32, 32, 32,102,105,114,115,116, 95,105,109,112, 10, 10, 82,
/* 0x41f0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x4200 */  83, 32, 70, 79, 82, 32, 91, 80, 69, 73, 77, 80, 79, 82, 50, 93,
/* 0x4210 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4220 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4230 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x4240 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95, 88, 56,
/* 0x4250 */  54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 71,101,
/* 0x4260 */ 116, 80,114,111, 99, 65,100,100,114,101,115,115, 45, 48,120, 48,
/* 0x4270 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 10,
/* 0x4280 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 48,
/* 0x4290 */  32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 56, 32, 32, 32,
/* 0x42a0 */  32, 32, 32,110,101,120,116, 95,102,117,110, 99, 10, 10, 82, 69,
/* 0x42b0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x42c0 */  32, 70, 79, 82, 32, 91, 80, 69, 73, 69, 82, 69, 88, 69, 93, 58,
/* 0x42d0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x42e0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x42f0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x4300 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 88, 56, 54,
/* 0x4310 */  95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 69,120,105,
/* 0x4320 */ 116, 80,114,111, 99,101,115,115, 45, 48,120, 48, 48, 48, 48, 48,
/* 0x4330 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 10, 10, 82, 69, 76,
/* 0x4340 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x4350 */  70, 79, 82, 32, 91, 80, 69, 82, 69, 76, 79, 67, 49, 93, 58, 10,
/* 0x4360 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4370 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4380 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4390 */  48, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 88, 56, 54, 95,
/* 0x43a0 */  54, 52, 95, 51, 50, 83, 32, 32, 32, 32, 32, 32,115,116, 97,114,
/* 0x43b0 */ 116, 95,111,102, 95,114,101,108,111, 99,115, 10, 10, 82, 69, 76,
/* 0x43c0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x43d0 */  70, 79, 82, 32, 91, 80, 69, 82, 69, 76, 79, 67, 51, 93, 58, 10,
/* 0x43e0 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x43f0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4400 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4410 */  48, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 88, 56, 54, 95,
/* 0x4420 */  54, 52, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,114,101,108,111,
/* 0x4430 */  99, 95,101,110,100,120, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x4440 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x4450 */  82, 69, 76, 54, 52, 66, 73, 71, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x4460 */  84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69,
/* 0x4470 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x4480 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4490 */  48, 48, 48, 51, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67,
/* 0x44a0 */  56, 32, 32, 32, 32, 32, 32,114,101,108,111, 99, 95, 97,100,100,
/* 0x44b0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x44c0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 82, 69, 76, 79, 67, 54,
/* 0x44d0 */  52, 74, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32,
/* 0x44e0 */  32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x44f0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x4500 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82,
/* 0x4510 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x4520 */  32,114,101,108,111, 99, 95, 97,100,100, 10, 10, 82, 69, 76, 79,
/* 0x4530 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x4540 */  79, 82, 32, 91, 80, 69, 82, 76, 79, 72, 73, 48, 93, 58, 10, 79,
/* 0x4550 */  70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4560 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4570 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4580 */  48, 48, 48, 48, 48, 48, 48, 54, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x4590 */  52, 95, 51, 50, 83, 32, 32, 32, 32, 32, 32,114,101,108,111, 99,
/* 0x45a0 */  95,100,101,108,116, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x45b0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80,
/* 0x45c0 */  69, 68, 69, 80, 72, 65, 75, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x45d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x45e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x45f0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4600 */  48, 48, 51, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51,
/* 0x4610 */  50, 32, 32, 32, 32, 32, 86,105,114,116,117, 97,108, 80,114,111,
/* 0x4620 */ 116,101, 99,116, 45, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4630 */  48, 48, 48, 48, 48, 48, 52, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4640 */  48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x4650 */  52, 95, 51, 50, 83, 32, 32, 32, 32, 32, 32,118,112, 95, 98, 97,
/* 0x4660 */ 115,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4670 */  48, 48,102, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 32,
/* 0x4680 */  32, 32, 32, 32, 32, 32,118,112, 95,115,105,122,101, 43, 48,120,
/* 0x4690 */  48, 48, 48, 48, 48, 48, 48, 48, 56, 48, 48, 48, 48, 48, 48, 48,
/* 0x46a0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50,
/* 0x46b0 */  99, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 83, 32, 32,
/* 0x46c0 */  32, 32, 32, 32,115,119,114,105, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x46d0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x46e0 */  32, 91, 80, 69, 84, 76, 83, 67, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x46f0 */  84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69,
/* 0x4700 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x4710 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4720 */  48, 48, 48, 50, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67,
/* 0x4730 */  51, 50, 32, 32, 32, 32, 32, 80, 69, 84, 76, 83, 67, 50, 45, 48,
/* 0x4740 */ 120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4750 */  53, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4760 */  48, 97, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 83, 32,
/* 0x4770 */  32, 32, 32, 32, 32,116,108,115, 95,109,111,100,117,108,101, 95,
/* 0x4780 */  98, 97,115,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4790 */  48, 48, 48, 49, 54, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x47a0 */  67, 51, 50, 32, 32, 32, 32, 32, 80, 69, 84, 76, 83, 67, 50, 45,
/* 0x47b0 */  48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x47c0 */  48, 52, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x47d0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 68, 79,
/* 0x47e0 */  74, 85, 77, 80, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x47f0 */  32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x4800 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x4810 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x4820 */  32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32,
/* 0x4830 */  32, 32, 32,111,114,105,103,105,110, 97,108, 95,101,110,116,114,
/* 0x4840 */ 121, 45, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4850 */  48, 48, 48, 52, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x4860 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69,
/* 0x4870 */  84, 76, 83, 67, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x4880 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x4890 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x48a0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x48b0 */  53, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32,
/* 0x48c0 */  32, 32, 32, 32,116,108,115, 95, 99, 97,108,108, 98, 97, 99,107,
/* 0x48d0 */ 115, 95,112,116,114, 45, 48,120, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x48e0 */  48, 48, 48, 48, 48, 48, 48, 52, 10
};
