/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractMessageLite$Builder;
import com.google.protobuf.ByteString;
import com.google.protobuf.ByteString$CodedBuilder;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.MessageLite;
import com.google.protobuf.UninitializedMessageException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;

public abstract class AbstractMessageLite<MessageType extends AbstractMessageLite<MessageType, BuilderType>, BuilderType extends AbstractMessageLite$Builder<MessageType, BuilderType>>
implements MessageLite {
    protected int memoizedHashCode = 0;

    @Override
    public ByteString toByteString() {
        try {
            ByteString$CodedBuilder byteString$CodedBuilder = ByteString.newCodedBuilder(this.getSerializedSize());
            this.writeTo(byteString$CodedBuilder.getCodedOutput());
            return byteString$CodedBuilder.build();
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getSerializingExceptionMessage("ByteString"), iOException);
        }
    }

    @Override
    public byte[] toByteArray() {
        try {
            byte[] byArray = new byte[this.getSerializedSize()];
            CodedOutputStream codedOutputStream = CodedOutputStream.newInstance(byArray);
            this.writeTo(codedOutputStream);
            codedOutputStream.checkNoSpaceLeft();
            return byArray;
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.getSerializingExceptionMessage("byte array"), iOException);
        }
    }

    @Override
    public void writeTo(OutputStream outputStream) {
        int n = CodedOutputStream.computePreferredBufferSize(this.getSerializedSize());
        CodedOutputStream codedOutputStream = CodedOutputStream.newInstance(outputStream, n);
        this.writeTo(codedOutputStream);
        codedOutputStream.flush();
    }

    @Override
    public void writeDelimitedTo(OutputStream outputStream) {
        int n = this.getSerializedSize();
        int n2 = CodedOutputStream.computePreferredBufferSize(CodedOutputStream.computeRawVarint32Size(n) + n);
        CodedOutputStream codedOutputStream = CodedOutputStream.newInstance(outputStream, n2);
        codedOutputStream.writeRawVarint32(n);
        this.writeTo(codedOutputStream);
        codedOutputStream.flush();
    }

    int getMemoizedSerializedSize() {
        throw new UnsupportedOperationException();
    }

    void setMemoizedSerializedSize(int n) {
        throw new UnsupportedOperationException();
    }

    UninitializedMessageException newUninitializedMessageException() {
        return new UninitializedMessageException(this);
    }

    private String getSerializingExceptionMessage(String string) {
        String string2 = String.valueOf(String.valueOf(this.getClass().getName()));
        String string3 = String.valueOf(String.valueOf(string));
        return new StringBuilder(62 + string2.length() + string3.length()).append("Serializing ").append(string2).append(" to a ").append(string3).append(" threw an IOException (should never happen).").toString();
    }

    protected static void checkByteStringIsUtf8(ByteString byteString) {
        if (!byteString.isValidUtf8()) {
            throw new IllegalArgumentException("Byte string is not UTF-8.");
        }
    }

    @Deprecated
    protected static <T> void addAll(Iterable<T> iterable, Collection<? super T> collection) {
        AbstractMessageLite$Builder.addAll(iterable, (List)collection);
    }

    protected static <T> void addAll(Iterable<T> iterable, List<? super T> list) {
        AbstractMessageLite$Builder.addAll(iterable, list);
    }
}

