/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.ByteString$LiteralByteString;
import java.io.OutputStream;
import java.util.ArrayList;

public final class ByteString$Output
extends OutputStream {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final int initialCapacity;
    private final ArrayList<ByteString> flushedBuffers;
    private int flushedBuffersTotalBytes;
    private byte[] buffer;
    private int bufferPos;

    ByteString$Output(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Buffer size < 0");
        }
        this.initialCapacity = n;
        this.flushedBuffers = new ArrayList();
        this.buffer = new byte[n];
    }

    @Override
    public synchronized void write(int n) {
        if (this.bufferPos == this.buffer.length) {
            this.flushFullBuffer(1);
        }
        this.buffer[this.bufferPos++] = (byte)n;
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) {
        if (n2 <= this.buffer.length - this.bufferPos) {
            System.arraycopy(byArray, n, this.buffer, this.bufferPos, n2);
            this.bufferPos += n2;
        } else {
            int n3 = this.buffer.length - this.bufferPos;
            System.arraycopy(byArray, n, this.buffer, this.bufferPos, n3);
            this.flushFullBuffer(n2 -= n3);
            System.arraycopy(byArray, n += n3, this.buffer, 0, n2);
            this.bufferPos = n2;
        }
    }

    public synchronized ByteString toByteString() {
        this.flushLastBuffer();
        return ByteString.copyFrom(this.flushedBuffers);
    }

    private byte[] copyArray(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, n));
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outputStream) {
        ByteString[] byteStringArray = this;
        synchronized (this) {
            ByteString[] byteStringArray2 = this.flushedBuffers.toArray(new ByteString[this.flushedBuffers.size()]);
            byte[] byArray = this.buffer;
            int n = this.bufferPos;
            // ** MonitorExit[var5_2] (shouldn't be in output)
            for (ByteString byteString : byteStringArray2) {
                byteString.writeTo(outputStream);
            }
            outputStream.write(super.copyArray(byArray, n));
            return;
        }
    }

    public synchronized int size() {
        return this.flushedBuffersTotalBytes + this.bufferPos;
    }

    public synchronized void reset() {
        this.flushedBuffers.clear();
        this.flushedBuffersTotalBytes = 0;
        this.bufferPos = 0;
    }

    public String toString() {
        return String.format("<ByteString.Output@%s size=%d>", Integer.toHexString(System.identityHashCode(this)), this.size());
    }

    private void flushFullBuffer(int n) {
        this.flushedBuffers.add(new ByteString$LiteralByteString(this.buffer));
        this.flushedBuffersTotalBytes += this.buffer.length;
        int n2 = Math.max(this.initialCapacity, Math.max(n, this.flushedBuffersTotalBytes >>> 1));
        this.buffer = new byte[n2];
        this.bufferPos = 0;
    }

    private void flushLastBuffer() {
        if (this.bufferPos < this.buffer.length) {
            if (this.bufferPos > 0) {
                byte[] byArray = this.copyArray(this.buffer, this.bufferPos);
                this.flushedBuffers.add(new ByteString$LiteralByteString(byArray));
            }
        } else {
            this.flushedBuffers.add(new ByteString$LiteralByteString(this.buffer));
            this.buffer = EMPTY_BYTE_ARRAY;
        }
        this.flushedBuffersTotalBytes += this.bufferPos;
        this.bufferPos = 0;
    }
}

