/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedInputStream$1;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageLite$Builder;
import com.google.protobuf.Parser;
import com.google.protobuf.Utf8;
import com.google.protobuf.WireFormat;
import java.nio.ByteBuffer;
import java.util.Arrays;

final class CodedInputStream$ArrayDecoder
extends CodedInputStream {
    private final byte[] buffer;
    private final boolean immutable;
    private int limit;
    private int bufferSizeAfterLimit;
    private int pos;
    private int startPos;
    private int lastTag;
    private boolean enableAliasing;
    private int currentLimit = Integer.MAX_VALUE;

    private CodedInputStream$ArrayDecoder(byte[] byArray, int n, int n2, boolean bl) {
        super(null);
        this.buffer = byArray;
        this.limit = n + n2;
        this.startPos = this.pos = n;
        this.immutable = bl;
    }

    @Override
    public int readTag() {
        if (this.isAtEnd()) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = this.readRawVarint32();
        if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
            throw InvalidProtocolBufferException.invalidTag();
        }
        return this.lastTag;
    }

    @Override
    public void checkLastTagWas(int n) {
        if (this.lastTag != n) {
            throw InvalidProtocolBufferException.invalidEndTag();
        }
    }

    @Override
    public int getLastTag() {
        return this.lastTag;
    }

    @Override
    public boolean skipField(int n) {
        switch (WireFormat.getTagWireType(n)) {
            case 0: {
                this.skipRawVarint();
                return true;
            }
            case 1: {
                this.skipRawBytes(8);
                return true;
            }
            case 2: {
                this.skipRawBytes(this.readRawVarint32());
                return true;
            }
            case 3: {
                this.skipMessage();
                this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(n), 4));
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                this.skipRawBytes(4);
                return true;
            }
        }
        throw InvalidProtocolBufferException.invalidWireType();
    }

    @Override
    public boolean skipField(int n, CodedOutputStream codedOutputStream) {
        switch (WireFormat.getTagWireType(n)) {
            case 0: {
                long l = this.readInt64();
                codedOutputStream.writeRawVarint32(n);
                codedOutputStream.writeUInt64NoTag(l);
                return true;
            }
            case 1: {
                long l = this.readRawLittleEndian64();
                codedOutputStream.writeRawVarint32(n);
                codedOutputStream.writeFixed64NoTag(l);
                return true;
            }
            case 2: {
                ByteString byteString = this.readBytes();
                codedOutputStream.writeRawVarint32(n);
                codedOutputStream.writeBytesNoTag(byteString);
                return true;
            }
            case 3: {
                codedOutputStream.writeRawVarint32(n);
                this.skipMessage(codedOutputStream);
                int n2 = WireFormat.makeTag(WireFormat.getTagFieldNumber(n), 4);
                this.checkLastTagWas(n2);
                codedOutputStream.writeRawVarint32(n2);
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                int n3 = this.readRawLittleEndian32();
                codedOutputStream.writeRawVarint32(n);
                codedOutputStream.writeFixed32NoTag(n3);
                return true;
            }
        }
        throw InvalidProtocolBufferException.invalidWireType();
    }

    @Override
    public void skipMessage() {
        int n;
        while ((n = this.readTag()) != 0 && this.skipField(n)) {
        }
    }

    @Override
    public void skipMessage(CodedOutputStream codedOutputStream) {
        int n;
        while ((n = this.readTag()) != 0 && this.skipField(n, codedOutputStream)) {
        }
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readRawLittleEndian32());
    }

    @Override
    public long readUInt64() {
        return this.readRawVarint64();
    }

    @Override
    public long readInt64() {
        return this.readRawVarint64();
    }

    @Override
    public int readInt32() {
        return this.readRawVarint32();
    }

    @Override
    public long readFixed64() {
        return this.readRawLittleEndian64();
    }

    @Override
    public int readFixed32() {
        return this.readRawLittleEndian32();
    }

    @Override
    public boolean readBool() {
        return this.readRawVarint64() != 0L;
    }

    @Override
    public String readString() {
        int n = this.readRawVarint32();
        if (n > 0 && n <= this.limit - this.pos) {
            String string = new String(this.buffer, this.pos, n, Internal.UTF_8);
            this.pos += n;
            return string;
        }
        if (n == 0) {
            return "";
        }
        if (n < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        throw InvalidProtocolBufferException.truncatedMessage();
    }

    @Override
    public String readStringRequireUtf8() {
        int n = this.readRawVarint32();
        if (n > 0 && n <= this.limit - this.pos) {
            String string = Utf8.decodeUtf8(this.buffer, this.pos, n);
            this.pos += n;
            return string;
        }
        if (n == 0) {
            return "";
        }
        if (n <= 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        throw InvalidProtocolBufferException.truncatedMessage();
    }

    @Override
    public void readGroup(int n, MessageLite$Builder messageLite$Builder, ExtensionRegistryLite extensionRegistryLite) {
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        ++this.recursionDepth;
        messageLite$Builder.mergeFrom(this, extensionRegistryLite);
        this.checkLastTagWas(WireFormat.makeTag(n, 4));
        --this.recursionDepth;
    }

    @Override
    public <T extends MessageLite> T readGroup(int n, Parser<T> parser, ExtensionRegistryLite extensionRegistryLite) {
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        ++this.recursionDepth;
        MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistryLite);
        this.checkLastTagWas(WireFormat.makeTag(n, 4));
        --this.recursionDepth;
        return (T)messageLite;
    }

    @Override
    @Deprecated
    public void readUnknownGroup(int n, MessageLite$Builder messageLite$Builder) {
        this.readGroup(n, messageLite$Builder, ExtensionRegistryLite.getEmptyRegistry());
    }

    @Override
    public void readMessage(MessageLite$Builder messageLite$Builder, ExtensionRegistryLite extensionRegistryLite) {
        int n = this.readRawVarint32();
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        int n2 = this.pushLimit(n);
        ++this.recursionDepth;
        messageLite$Builder.mergeFrom(this, extensionRegistryLite);
        this.checkLastTagWas(0);
        --this.recursionDepth;
        this.popLimit(n2);
    }

    @Override
    public <T extends MessageLite> T readMessage(Parser<T> parser, ExtensionRegistryLite extensionRegistryLite) {
        int n = this.readRawVarint32();
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        int n2 = this.pushLimit(n);
        ++this.recursionDepth;
        MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistryLite);
        this.checkLastTagWas(0);
        --this.recursionDepth;
        this.popLimit(n2);
        return (T)messageLite;
    }

    @Override
    public ByteString readBytes() {
        int n = this.readRawVarint32();
        if (n > 0 && n <= this.limit - this.pos) {
            ByteString byteString = this.immutable && this.enableAliasing ? ByteString.wrap(this.buffer, this.pos, n) : ByteString.copyFrom(this.buffer, this.pos, n);
            this.pos += n;
            return byteString;
        }
        if (n == 0) {
            return ByteString.EMPTY;
        }
        return ByteString.wrap(this.readRawBytes(n));
    }

    @Override
    public byte[] readByteArray() {
        int n = this.readRawVarint32();
        return this.readRawBytes(n);
    }

    @Override
    public ByteBuffer readByteBuffer() {
        int n = this.readRawVarint32();
        if (n > 0 && n <= this.limit - this.pos) {
            ByteBuffer byteBuffer = !this.immutable && this.enableAliasing ? ByteBuffer.wrap(this.buffer, this.pos, n).slice() : ByteBuffer.wrap(Arrays.copyOfRange(this.buffer, this.pos, this.pos + n));
            this.pos += n;
            return byteBuffer;
        }
        if (n == 0) {
            return Internal.EMPTY_BYTE_BUFFER;
        }
        if (n < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        throw InvalidProtocolBufferException.truncatedMessage();
    }

    @Override
    public int readUInt32() {
        return this.readRawVarint32();
    }

    @Override
    public int readEnum() {
        return this.readRawVarint32();
    }

    @Override
    public int readSFixed32() {
        return this.readRawLittleEndian32();
    }

    @Override
    public long readSFixed64() {
        return this.readRawLittleEndian64();
    }

    @Override
    public int readSInt32() {
        return CodedInputStream$ArrayDecoder.decodeZigZag32(this.readRawVarint32());
    }

    @Override
    public long readSInt64() {
        return CodedInputStream$ArrayDecoder.decodeZigZag64(this.readRawVarint64());
    }

    @Override
    public int readRawVarint32() {
        block4: {
            int n;
            int n2;
            block6: {
                byte[] byArray;
                block8: {
                    block7: {
                        block5: {
                            n2 = this.pos;
                            if (this.limit == n2) break block4;
                            byArray = this.buffer;
                            if ((n = byArray[n2++]) >= 0) {
                                this.pos = n2;
                                return n;
                            }
                            if (this.limit - n2 < 9) break block4;
                            if ((n ^= byArray[n2++] << 7) >= 0) break block5;
                            n ^= 0xFFFFFF80;
                            break block6;
                        }
                        if ((n ^= byArray[n2++] << 14) < 0) break block7;
                        n ^= 0x3F80;
                        break block6;
                    }
                    if ((n ^= byArray[n2++] << 21) >= 0) break block8;
                    n ^= 0xFFE03F80;
                    break block6;
                }
                byte by = byArray[n2++];
                n ^= by << 28;
                n ^= 0xFE03F80;
                if (by < 0 && byArray[n2++] < 0 && byArray[n2++] < 0 && byArray[n2++] < 0 && byArray[n2++] < 0 && byArray[n2++] < 0) break block4;
            }
            this.pos = n2;
            return n;
        }
        return (int)this.readRawVarint64SlowPath();
    }

    private void skipRawVarint() {
        if (this.limit - this.pos >= 10) {
            this.skipRawVarintFastPath();
        } else {
            this.skipRawVarintSlowPath();
        }
    }

    private void skipRawVarintFastPath() {
        for (int i = 0; i < 10; ++i) {
            if (this.buffer[this.pos++] < 0) continue;
            return;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    private void skipRawVarintSlowPath() {
        for (int i = 0; i < 10; ++i) {
            if (this.readRawByte() < 0) continue;
            return;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    @Override
    public long readRawVarint64() {
        block4: {
            long l;
            int n;
            block6: {
                byte[] byArray;
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                int n2;
                                block8: {
                                    block7: {
                                        block5: {
                                            n = this.pos;
                                            if (this.limit == n) break block4;
                                            byArray = this.buffer;
                                            if ((n2 = byArray[n++]) >= 0) {
                                                this.pos = n;
                                                return n2;
                                            }
                                            if (this.limit - n < 9) break block4;
                                            if ((n2 ^= byArray[n++] << 7) >= 0) break block5;
                                            l = n2 ^ 0xFFFFFF80;
                                            break block6;
                                        }
                                        if ((n2 ^= byArray[n++] << 14) < 0) break block7;
                                        l = n2 ^ 0x3F80;
                                        break block6;
                                    }
                                    if ((n2 ^= byArray[n++] << 21) >= 0) break block8;
                                    l = n2 ^ 0xFFE03F80;
                                    break block6;
                                }
                                if ((l = (long)n2 ^ (long)byArray[n++] << 28) < 0L) break block9;
                                l ^= 0xFE03F80L;
                                break block6;
                            }
                            if ((l ^= (long)byArray[n++] << 35) >= 0L) break block10;
                            l ^= 0xFFFFFFF80FE03F80L;
                            break block6;
                        }
                        if ((l ^= (long)byArray[n++] << 42) < 0L) break block11;
                        l ^= 0x3F80FE03F80L;
                        break block6;
                    }
                    if ((l ^= (long)byArray[n++] << 49) >= 0L) break block12;
                    l ^= 0xFFFE03F80FE03F80L;
                    break block6;
                }
                l ^= (long)byArray[n++] << 56;
                if ((l ^= 0xFE03F80FE03F80L) < 0L && (long)byArray[n++] < 0L) break block4;
            }
            this.pos = n;
            return l;
        }
        return this.readRawVarint64SlowPath();
    }

    @Override
    long readRawVarint64SlowPath() {
        long l = 0L;
        for (int i = 0; i < 64; i += 7) {
            byte by = this.readRawByte();
            l |= (long)(by & 0x7F) << i;
            if ((by & 0x80) != 0) continue;
            return l;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    @Override
    public int readRawLittleEndian32() {
        int n = this.pos;
        if (this.limit - n < 4) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        byte[] byArray = this.buffer;
        this.pos = n + 4;
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    @Override
    public long readRawLittleEndian64() {
        int n = this.pos;
        if (this.limit - n < 8) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        byte[] byArray = this.buffer;
        this.pos = n + 8;
        return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 7] & 0xFFL) << 56;
    }

    @Override
    public void enableAliasing(boolean bl) {
        this.enableAliasing = bl;
    }

    @Override
    public void resetSizeCounter() {
        this.startPos = this.pos;
    }

    @Override
    public int pushLimit(int n) {
        int n2;
        if (n < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if ((n += this.getTotalBytesRead()) > (n2 = this.currentLimit)) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        this.currentLimit = n;
        this.recomputeBufferSizeAfterLimit();
        return n2;
    }

    private void recomputeBufferSizeAfterLimit() {
        this.limit += this.bufferSizeAfterLimit;
        int n = this.limit - this.startPos;
        if (n > this.currentLimit) {
            this.bufferSizeAfterLimit = n - this.currentLimit;
            this.limit -= this.bufferSizeAfterLimit;
        } else {
            this.bufferSizeAfterLimit = 0;
        }
    }

    @Override
    public void popLimit(int n) {
        this.currentLimit = n;
        this.recomputeBufferSizeAfterLimit();
    }

    @Override
    public int getBytesUntilLimit() {
        if (this.currentLimit == Integer.MAX_VALUE) {
            return -1;
        }
        return this.currentLimit - this.getTotalBytesRead();
    }

    @Override
    public boolean isAtEnd() {
        return this.pos == this.limit;
    }

    @Override
    public int getTotalBytesRead() {
        return this.pos - this.startPos;
    }

    @Override
    public byte readRawByte() {
        if (this.pos == this.limit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return this.buffer[this.pos++];
    }

    @Override
    public byte[] readRawBytes(int n) {
        if (n > 0 && n <= this.limit - this.pos) {
            int n2 = this.pos;
            this.pos += n;
            return Arrays.copyOfRange(this.buffer, n2, this.pos);
        }
        if (n <= 0) {
            if (n == 0) {
                return Internal.EMPTY_BYTE_ARRAY;
            }
            throw InvalidProtocolBufferException.negativeSize();
        }
        throw InvalidProtocolBufferException.truncatedMessage();
    }

    @Override
    public void skipRawBytes(int n) {
        if (n >= 0 && n <= this.limit - this.pos) {
            this.pos += n;
            return;
        }
        if (n < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        throw InvalidProtocolBufferException.truncatedMessage();
    }

    /* synthetic */ CodedInputStream$ArrayDecoder(byte[] byArray, int n, int n2, boolean bl, CodedInputStream$1 codedInputStream$1) {
        this(byArray, n, n2, bl);
    }
}

