/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedInputStream$1;
import com.google.protobuf.CodedInputStream$StreamDecoder$RefillCallback;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageLite$Builder;
import com.google.protobuf.Parser;
import com.google.protobuf.Utf8;
import com.google.protobuf.WireFormat;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class CodedInputStream$StreamDecoder
extends CodedInputStream {
    private final InputStream input;
    private final byte[] buffer;
    private int bufferSize;
    private int bufferSizeAfterLimit;
    private int pos;
    private int lastTag;
    private int totalBytesRetired;
    private int currentLimit = Integer.MAX_VALUE;
    private CodedInputStream$StreamDecoder$RefillCallback refillCallback = null;

    private CodedInputStream$StreamDecoder(InputStream inputStream, int n) {
        super(null);
        Internal.checkNotNull(inputStream, "input");
        this.input = inputStream;
        this.buffer = new byte[n];
        this.bufferSize = 0;
        this.pos = 0;
        this.totalBytesRetired = 0;
    }

    @Override
    public int readTag() {
        if (this.isAtEnd()) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = this.readRawVarint32();
        if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
            throw InvalidProtocolBufferException.invalidTag();
        }
        return this.lastTag;
    }

    @Override
    public void checkLastTagWas(int n) {
        if (this.lastTag != n) {
            throw InvalidProtocolBufferException.invalidEndTag();
        }
    }

    @Override
    public int getLastTag() {
        return this.lastTag;
    }

    @Override
    public boolean skipField(int n) {
        switch (WireFormat.getTagWireType(n)) {
            case 0: {
                this.skipRawVarint();
                return true;
            }
            case 1: {
                this.skipRawBytes(8);
                return true;
            }
            case 2: {
                this.skipRawBytes(this.readRawVarint32());
                return true;
            }
            case 3: {
                this.skipMessage();
                this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(n), 4));
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                this.skipRawBytes(4);
                return true;
            }
        }
        throw InvalidProtocolBufferException.invalidWireType();
    }

    @Override
    public boolean skipField(int n, CodedOutputStream codedOutputStream) {
        switch (WireFormat.getTagWireType(n)) {
            case 0: {
                long l = this.readInt64();
                codedOutputStream.writeRawVarint32(n);
                codedOutputStream.writeUInt64NoTag(l);
                return true;
            }
            case 1: {
                long l = this.readRawLittleEndian64();
                codedOutputStream.writeRawVarint32(n);
                codedOutputStream.writeFixed64NoTag(l);
                return true;
            }
            case 2: {
                ByteString byteString = this.readBytes();
                codedOutputStream.writeRawVarint32(n);
                codedOutputStream.writeBytesNoTag(byteString);
                return true;
            }
            case 3: {
                codedOutputStream.writeRawVarint32(n);
                this.skipMessage(codedOutputStream);
                int n2 = WireFormat.makeTag(WireFormat.getTagFieldNumber(n), 4);
                this.checkLastTagWas(n2);
                codedOutputStream.writeRawVarint32(n2);
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                int n3 = this.readRawLittleEndian32();
                codedOutputStream.writeRawVarint32(n);
                codedOutputStream.writeFixed32NoTag(n3);
                return true;
            }
        }
        throw InvalidProtocolBufferException.invalidWireType();
    }

    @Override
    public void skipMessage() {
        int n;
        while ((n = this.readTag()) != 0 && this.skipField(n)) {
        }
    }

    @Override
    public void skipMessage(CodedOutputStream codedOutputStream) {
        int n;
        while ((n = this.readTag()) != 0 && this.skipField(n, codedOutputStream)) {
        }
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readRawLittleEndian32());
    }

    @Override
    public long readUInt64() {
        return this.readRawVarint64();
    }

    @Override
    public long readInt64() {
        return this.readRawVarint64();
    }

    @Override
    public int readInt32() {
        return this.readRawVarint32();
    }

    @Override
    public long readFixed64() {
        return this.readRawLittleEndian64();
    }

    @Override
    public int readFixed32() {
        return this.readRawLittleEndian32();
    }

    @Override
    public boolean readBool() {
        return this.readRawVarint64() != 0L;
    }

    @Override
    public String readString() {
        int n = this.readRawVarint32();
        if (n > 0 && n <= this.bufferSize - this.pos) {
            String string = new String(this.buffer, this.pos, n, Internal.UTF_8);
            this.pos += n;
            return string;
        }
        if (n == 0) {
            return "";
        }
        if (n <= this.bufferSize) {
            this.refillBuffer(n);
            String string = new String(this.buffer, this.pos, n, Internal.UTF_8);
            this.pos += n;
            return string;
        }
        return new String(this.readRawBytesSlowPath(n), Internal.UTF_8);
    }

    @Override
    public String readStringRequireUtf8() {
        int n;
        byte[] byArray;
        int n2;
        int n3 = this.readRawVarint32();
        if (n3 <= this.bufferSize - (n2 = this.pos) && n3 > 0) {
            byArray = this.buffer;
            this.pos = n2 + n3;
            n = n2;
        } else {
            if (n3 == 0) {
                return "";
            }
            if (n3 <= this.bufferSize) {
                this.refillBuffer(n3);
                byArray = this.buffer;
                n = 0;
                this.pos = n + n3;
            } else {
                byArray = this.readRawBytesSlowPath(n3);
                n = 0;
            }
        }
        return Utf8.decodeUtf8(byArray, n, n3);
    }

    @Override
    public void readGroup(int n, MessageLite$Builder messageLite$Builder, ExtensionRegistryLite extensionRegistryLite) {
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        ++this.recursionDepth;
        messageLite$Builder.mergeFrom(this, extensionRegistryLite);
        this.checkLastTagWas(WireFormat.makeTag(n, 4));
        --this.recursionDepth;
    }

    @Override
    public <T extends MessageLite> T readGroup(int n, Parser<T> parser, ExtensionRegistryLite extensionRegistryLite) {
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        ++this.recursionDepth;
        MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistryLite);
        this.checkLastTagWas(WireFormat.makeTag(n, 4));
        --this.recursionDepth;
        return (T)messageLite;
    }

    @Override
    @Deprecated
    public void readUnknownGroup(int n, MessageLite$Builder messageLite$Builder) {
        this.readGroup(n, messageLite$Builder, ExtensionRegistryLite.getEmptyRegistry());
    }

    @Override
    public void readMessage(MessageLite$Builder messageLite$Builder, ExtensionRegistryLite extensionRegistryLite) {
        int n = this.readRawVarint32();
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        int n2 = this.pushLimit(n);
        ++this.recursionDepth;
        messageLite$Builder.mergeFrom(this, extensionRegistryLite);
        this.checkLastTagWas(0);
        --this.recursionDepth;
        this.popLimit(n2);
    }

    @Override
    public <T extends MessageLite> T readMessage(Parser<T> parser, ExtensionRegistryLite extensionRegistryLite) {
        int n = this.readRawVarint32();
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        int n2 = this.pushLimit(n);
        ++this.recursionDepth;
        MessageLite messageLite = (MessageLite)parser.parsePartialFrom(this, extensionRegistryLite);
        this.checkLastTagWas(0);
        --this.recursionDepth;
        this.popLimit(n2);
        return (T)messageLite;
    }

    @Override
    public ByteString readBytes() {
        int n = this.readRawVarint32();
        if (n <= this.bufferSize - this.pos && n > 0) {
            ByteString byteString = ByteString.copyFrom(this.buffer, this.pos, n);
            this.pos += n;
            return byteString;
        }
        if (n == 0) {
            return ByteString.EMPTY;
        }
        return this.readBytesSlowPath(n);
    }

    @Override
    public byte[] readByteArray() {
        int n = this.readRawVarint32();
        if (n <= this.bufferSize - this.pos && n > 0) {
            byte[] byArray = Arrays.copyOfRange(this.buffer, this.pos, this.pos + n);
            this.pos += n;
            return byArray;
        }
        return this.readRawBytesSlowPath(n);
    }

    @Override
    public ByteBuffer readByteBuffer() {
        int n = this.readRawVarint32();
        if (n <= this.bufferSize - this.pos && n > 0) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(Arrays.copyOfRange(this.buffer, this.pos, this.pos + n));
            this.pos += n;
            return byteBuffer;
        }
        if (n == 0) {
            return Internal.EMPTY_BYTE_BUFFER;
        }
        return ByteBuffer.wrap(this.readRawBytesSlowPath(n));
    }

    @Override
    public int readUInt32() {
        return this.readRawVarint32();
    }

    @Override
    public int readEnum() {
        return this.readRawVarint32();
    }

    @Override
    public int readSFixed32() {
        return this.readRawLittleEndian32();
    }

    @Override
    public long readSFixed64() {
        return this.readRawLittleEndian64();
    }

    @Override
    public int readSInt32() {
        return CodedInputStream$StreamDecoder.decodeZigZag32(this.readRawVarint32());
    }

    @Override
    public long readSInt64() {
        return CodedInputStream$StreamDecoder.decodeZigZag64(this.readRawVarint64());
    }

    @Override
    public int readRawVarint32() {
        block4: {
            int n;
            int n2;
            block6: {
                byte[] byArray;
                block8: {
                    block7: {
                        block5: {
                            n2 = this.pos;
                            if (this.bufferSize == n2) break block4;
                            byArray = this.buffer;
                            if ((n = byArray[n2++]) >= 0) {
                                this.pos = n2;
                                return n;
                            }
                            if (this.bufferSize - n2 < 9) break block4;
                            if ((n ^= byArray[n2++] << 7) >= 0) break block5;
                            n ^= 0xFFFFFF80;
                            break block6;
                        }
                        if ((n ^= byArray[n2++] << 14) < 0) break block7;
                        n ^= 0x3F80;
                        break block6;
                    }
                    if ((n ^= byArray[n2++] << 21) >= 0) break block8;
                    n ^= 0xFFE03F80;
                    break block6;
                }
                byte by = byArray[n2++];
                n ^= by << 28;
                n ^= 0xFE03F80;
                if (by < 0 && byArray[n2++] < 0 && byArray[n2++] < 0 && byArray[n2++] < 0 && byArray[n2++] < 0 && byArray[n2++] < 0) break block4;
            }
            this.pos = n2;
            return n;
        }
        return (int)this.readRawVarint64SlowPath();
    }

    private void skipRawVarint() {
        if (this.bufferSize - this.pos >= 10) {
            this.skipRawVarintFastPath();
        } else {
            this.skipRawVarintSlowPath();
        }
    }

    private void skipRawVarintFastPath() {
        for (int i = 0; i < 10; ++i) {
            if (this.buffer[this.pos++] < 0) continue;
            return;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    private void skipRawVarintSlowPath() {
        for (int i = 0; i < 10; ++i) {
            if (this.readRawByte() < 0) continue;
            return;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    @Override
    public long readRawVarint64() {
        block4: {
            long l;
            int n;
            block6: {
                byte[] byArray;
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                int n2;
                                block8: {
                                    block7: {
                                        block5: {
                                            n = this.pos;
                                            if (this.bufferSize == n) break block4;
                                            byArray = this.buffer;
                                            if ((n2 = byArray[n++]) >= 0) {
                                                this.pos = n;
                                                return n2;
                                            }
                                            if (this.bufferSize - n < 9) break block4;
                                            if ((n2 ^= byArray[n++] << 7) >= 0) break block5;
                                            l = n2 ^ 0xFFFFFF80;
                                            break block6;
                                        }
                                        if ((n2 ^= byArray[n++] << 14) < 0) break block7;
                                        l = n2 ^ 0x3F80;
                                        break block6;
                                    }
                                    if ((n2 ^= byArray[n++] << 21) >= 0) break block8;
                                    l = n2 ^ 0xFFE03F80;
                                    break block6;
                                }
                                if ((l = (long)n2 ^ (long)byArray[n++] << 28) < 0L) break block9;
                                l ^= 0xFE03F80L;
                                break block6;
                            }
                            if ((l ^= (long)byArray[n++] << 35) >= 0L) break block10;
                            l ^= 0xFFFFFFF80FE03F80L;
                            break block6;
                        }
                        if ((l ^= (long)byArray[n++] << 42) < 0L) break block11;
                        l ^= 0x3F80FE03F80L;
                        break block6;
                    }
                    if ((l ^= (long)byArray[n++] << 49) >= 0L) break block12;
                    l ^= 0xFFFE03F80FE03F80L;
                    break block6;
                }
                l ^= (long)byArray[n++] << 56;
                if ((l ^= 0xFE03F80FE03F80L) < 0L && (long)byArray[n++] < 0L) break block4;
            }
            this.pos = n;
            return l;
        }
        return this.readRawVarint64SlowPath();
    }

    @Override
    long readRawVarint64SlowPath() {
        long l = 0L;
        for (int i = 0; i < 64; i += 7) {
            byte by = this.readRawByte();
            l |= (long)(by & 0x7F) << i;
            if ((by & 0x80) != 0) continue;
            return l;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    @Override
    public int readRawLittleEndian32() {
        int n = this.pos;
        if (this.bufferSize - n < 4) {
            this.refillBuffer(4);
            n = this.pos;
        }
        byte[] byArray = this.buffer;
        this.pos = n + 4;
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    @Override
    public long readRawLittleEndian64() {
        int n = this.pos;
        if (this.bufferSize - n < 8) {
            this.refillBuffer(8);
            n = this.pos;
        }
        byte[] byArray = this.buffer;
        this.pos = n + 8;
        return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 7] & 0xFFL) << 56;
    }

    @Override
    public void enableAliasing(boolean bl) {
    }

    @Override
    public void resetSizeCounter() {
        this.totalBytesRetired = -this.pos;
    }

    @Override
    public int pushLimit(int n) {
        if (n < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        int n2 = this.currentLimit;
        if ((n += this.totalBytesRetired + this.pos) > n2) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        this.currentLimit = n;
        this.recomputeBufferSizeAfterLimit();
        return n2;
    }

    private void recomputeBufferSizeAfterLimit() {
        this.bufferSize += this.bufferSizeAfterLimit;
        int n = this.totalBytesRetired + this.bufferSize;
        if (n > this.currentLimit) {
            this.bufferSizeAfterLimit = n - this.currentLimit;
            this.bufferSize -= this.bufferSizeAfterLimit;
        } else {
            this.bufferSizeAfterLimit = 0;
        }
    }

    @Override
    public void popLimit(int n) {
        this.currentLimit = n;
        this.recomputeBufferSizeAfterLimit();
    }

    @Override
    public int getBytesUntilLimit() {
        if (this.currentLimit == Integer.MAX_VALUE) {
            return -1;
        }
        int n = this.totalBytesRetired + this.pos;
        return this.currentLimit - n;
    }

    @Override
    public boolean isAtEnd() {
        return this.pos == this.bufferSize && !this.tryRefillBuffer(1);
    }

    @Override
    public int getTotalBytesRead() {
        return this.totalBytesRetired + this.pos;
    }

    private void refillBuffer(int n) {
        if (!this.tryRefillBuffer(n)) {
            if (n > this.sizeLimit - this.totalBytesRetired - this.pos) {
                throw InvalidProtocolBufferException.sizeLimitExceeded();
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }
    }

    private boolean tryRefillBuffer(int n) {
        int n2;
        int n3;
        if (this.pos + n <= this.bufferSize) {
            int n4 = n;
            throw new IllegalStateException(new StringBuilder(77).append("refillBuffer() called when ").append(n4).append(" bytes were already available in buffer").toString());
        }
        if (n > this.sizeLimit - this.totalBytesRetired - this.pos) {
            return false;
        }
        if (this.totalBytesRetired + this.pos + n > this.currentLimit) {
            return false;
        }
        if (this.refillCallback != null) {
            this.refillCallback.onRefill();
        }
        if ((n3 = this.pos) > 0) {
            if (this.bufferSize > n3) {
                System.arraycopy(this.buffer, n3, this.buffer, 0, this.bufferSize - n3);
            }
            this.totalBytesRetired += n3;
            this.bufferSize -= n3;
            this.pos = 0;
        }
        if ((n2 = this.input.read(this.buffer, this.bufferSize, Math.min(this.buffer.length - this.bufferSize, this.sizeLimit - this.totalBytesRetired - this.bufferSize))) == 0 || n2 < -1 || n2 > this.buffer.length) {
            String string = String.valueOf(String.valueOf(this.input.getClass()));
            int n5 = n2;
            throw new IllegalStateException(new StringBuilder(91 + string.length()).append(string).append("#read(byte[]) returned invalid result: ").append(n5).append("\nThe InputStream implementation is buggy.").toString());
        }
        if (n2 > 0) {
            this.bufferSize += n2;
            this.recomputeBufferSizeAfterLimit();
            return this.bufferSize >= n ? true : this.tryRefillBuffer(n);
        }
        return false;
    }

    @Override
    public byte readRawByte() {
        if (this.pos == this.bufferSize) {
            this.refillBuffer(1);
        }
        return this.buffer[this.pos++];
    }

    @Override
    public byte[] readRawBytes(int n) {
        int n2 = this.pos;
        if (n <= this.bufferSize - n2 && n > 0) {
            this.pos = n2 + n;
            return Arrays.copyOfRange(this.buffer, n2, n2 + n);
        }
        return this.readRawBytesSlowPath(n);
    }

    private byte[] readRawBytesSlowPath(int n) {
        byte[] byArray = this.readRawBytesSlowPathOneChunk(n);
        if (byArray != null) {
            return byArray;
        }
        int n2 = this.pos;
        int n3 = this.bufferSize - this.pos;
        this.totalBytesRetired += this.bufferSize;
        this.pos = 0;
        this.bufferSize = 0;
        int n4 = n - n3;
        List<byte[]> list = this.readRawBytesSlowPathRemainingChunks(n4);
        byte[] byArray2 = new byte[n];
        System.arraycopy(this.buffer, n2, byArray2, 0, n3);
        int n5 = n3;
        for (byte[] byArray3 : list) {
            System.arraycopy(byArray3, 0, byArray2, n5, byArray3.length);
            n5 += byArray3.length;
        }
        return byArray2;
    }

    private byte[] readRawBytesSlowPathOneChunk(int n) {
        if (n == 0) {
            return Internal.EMPTY_BYTE_ARRAY;
        }
        if (n < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        int n2 = this.totalBytesRetired + this.pos + n;
        if (n2 - this.sizeLimit > 0) {
            throw InvalidProtocolBufferException.sizeLimitExceeded();
        }
        if (n2 > this.currentLimit) {
            this.skipRawBytes(this.currentLimit - this.totalBytesRetired - this.pos);
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        int n3 = this.bufferSize - this.pos;
        int n4 = n - n3;
        if (n4 < 4096 || n4 <= this.input.available()) {
            int n5;
            byte[] byArray = new byte[n];
            System.arraycopy(this.buffer, this.pos, byArray, 0, n3);
            this.totalBytesRetired += this.bufferSize;
            this.pos = 0;
            this.bufferSize = 0;
            for (int i = n3; i < byArray.length; i += n5) {
                n5 = this.input.read(byArray, i, n - i);
                if (n5 == -1) {
                    throw InvalidProtocolBufferException.truncatedMessage();
                }
                this.totalBytesRetired += n5;
            }
            return byArray;
        }
        return null;
    }

    private List<byte[]> readRawBytesSlowPathRemainingChunks(int n) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        while (n > 0) {
            int n2;
            byte[] byArray = new byte[Math.min(n, 4096)];
            for (int i = 0; i < byArray.length; i += n2) {
                n2 = this.input.read(byArray, i, byArray.length - i);
                if (n2 == -1) {
                    throw InvalidProtocolBufferException.truncatedMessage();
                }
                this.totalBytesRetired += n2;
            }
            n -= byArray.length;
            arrayList.add(byArray);
        }
        return arrayList;
    }

    private ByteString readBytesSlowPath(int n) {
        byte[] byArray = this.readRawBytesSlowPathOneChunk(n);
        if (byArray != null) {
            return ByteString.wrap(byArray);
        }
        int n2 = this.pos;
        int n3 = this.bufferSize - this.pos;
        this.totalBytesRetired += this.bufferSize;
        this.pos = 0;
        this.bufferSize = 0;
        int n4 = n - n3;
        List<byte[]> list = this.readRawBytesSlowPathRemainingChunks(n4);
        ArrayList<ByteString> arrayList = new ArrayList<ByteString>(1 + list.size());
        arrayList.add(ByteString.copyFrom(this.buffer, n2, n3));
        for (byte[] byArray2 : list) {
            arrayList.add(ByteString.wrap(byArray2));
        }
        return ByteString.copyFrom(arrayList);
    }

    @Override
    public void skipRawBytes(int n) {
        if (n <= this.bufferSize - this.pos && n >= 0) {
            this.pos += n;
        } else {
            this.skipRawBytesSlowPath(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void skipRawBytesSlowPath(int n) {
        int n2;
        if (n < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (this.totalBytesRetired + this.pos + n > this.currentLimit) {
            this.skipRawBytes(this.currentLimit - this.totalBytesRetired - this.pos);
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        int n3 = 0;
        if (this.refillCallback == null) {
            this.totalBytesRetired += this.pos;
            this.bufferSize = 0;
            this.pos = 0;
            try {
                long l;
                for (n3 = this.bufferSize - this.pos; n3 < n; n3 += (int)l) {
                    n2 = n - n3;
                    l = this.input.skip(n2);
                    if (l < 0L || l > (long)n2) {
                        String string = String.valueOf(String.valueOf(this.input.getClass()));
                        long l2 = l;
                        throw new IllegalStateException(new StringBuilder(92 + string.length()).append(string).append("#skip returned invalid result: ").append(l2).append("\nThe InputStream implementation is buggy.").toString());
                    }
                    if (l != 0L) continue;
                    break;
                }
            }
            finally {
                this.totalBytesRetired += n3;
                this.recomputeBufferSizeAfterLimit();
            }
        }
        if (n3 < n) {
            n2 = this.bufferSize - this.pos;
            this.pos = this.bufferSize;
            this.refillBuffer(1);
            while (n - n2 > this.bufferSize) {
                n2 += this.bufferSize;
                this.pos = this.bufferSize;
                this.refillBuffer(1);
            }
            this.pos = n - n2;
        }
    }

    /* synthetic */ CodedInputStream$StreamDecoder(InputStream inputStream, int n, CodedInputStream$1 codedInputStream$1) {
        this(inputStream, n);
    }

    static /* synthetic */ int access$500(CodedInputStream$StreamDecoder codedInputStream$StreamDecoder) {
        return codedInputStream$StreamDecoder.pos;
    }

    static /* synthetic */ byte[] access$600(CodedInputStream$StreamDecoder codedInputStream$StreamDecoder) {
        return codedInputStream$StreamDecoder.buffer;
    }
}

