/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteOutput;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream$AbstractBufferedEncoder;
import com.google.protobuf.CodedOutputStream$OutOfSpaceException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Utf8;
import com.google.protobuf.Utf8$UnpairedSurrogateException;
import com.google.protobuf.WireFormat;
import java.nio.ByteBuffer;

final class CodedOutputStream$ByteOutputEncoder
extends CodedOutputStream$AbstractBufferedEncoder {
    private final ByteOutput out;

    CodedOutputStream$ByteOutputEncoder(ByteOutput byteOutput, int n) {
        super(n);
        if (byteOutput == null) {
            throw new NullPointerException("out");
        }
        this.out = byteOutput;
    }

    @Override
    public void writeTag(int n, int n2) {
        this.writeUInt32NoTag(WireFormat.makeTag(n, n2));
    }

    @Override
    public void writeInt32(int n, int n2) {
        this.flushIfNotAvailable(20);
        this.bufferTag(n, 0);
        this.bufferInt32NoTag(n2);
    }

    @Override
    public void writeUInt32(int n, int n2) {
        this.flushIfNotAvailable(20);
        this.bufferTag(n, 0);
        this.bufferUInt32NoTag(n2);
    }

    @Override
    public void writeFixed32(int n, int n2) {
        this.flushIfNotAvailable(14);
        this.bufferTag(n, 5);
        this.bufferFixed32NoTag(n2);
    }

    @Override
    public void writeUInt64(int n, long l) {
        this.flushIfNotAvailable(20);
        this.bufferTag(n, 0);
        this.bufferUInt64NoTag(l);
    }

    @Override
    public void writeFixed64(int n, long l) {
        this.flushIfNotAvailable(18);
        this.bufferTag(n, 1);
        this.bufferFixed64NoTag(l);
    }

    @Override
    public void writeBool(int n, boolean bl) {
        this.flushIfNotAvailable(11);
        this.bufferTag(n, 0);
        this.buffer((byte)(bl ? 1 : 0));
    }

    @Override
    public void writeString(int n, String string) {
        this.writeTag(n, 2);
        this.writeStringNoTag(string);
    }

    @Override
    public void writeBytes(int n, ByteString byteString) {
        this.writeTag(n, 2);
        this.writeBytesNoTag(byteString);
    }

    @Override
    public void writeByteArray(int n, byte[] byArray) {
        this.writeByteArray(n, byArray, 0, byArray.length);
    }

    @Override
    public void writeByteArray(int n, byte[] byArray, int n2, int n3) {
        this.writeTag(n, 2);
        this.writeByteArrayNoTag(byArray, n2, n3);
    }

    @Override
    public void writeByteBuffer(int n, ByteBuffer byteBuffer) {
        this.writeTag(n, 2);
        this.writeUInt32NoTag(byteBuffer.capacity());
        this.writeRawBytes(byteBuffer);
    }

    @Override
    public void writeBytesNoTag(ByteString byteString) {
        this.writeUInt32NoTag(byteString.size());
        byteString.writeTo(this);
    }

    @Override
    public void writeByteArrayNoTag(byte[] byArray, int n, int n2) {
        this.writeUInt32NoTag(n2);
        this.write(byArray, n, n2);
    }

    @Override
    public void writeRawBytes(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            this.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.capacity());
        } else {
            ByteBuffer byteBuffer2 = byteBuffer.duplicate();
            byteBuffer2.clear();
            this.write(byteBuffer2);
        }
    }

    @Override
    public void writeMessage(int n, MessageLite messageLite) {
        this.writeTag(n, 2);
        this.writeMessageNoTag(messageLite);
    }

    @Override
    public void writeMessageSetExtension(int n, MessageLite messageLite) {
        this.writeTag(1, 3);
        this.writeUInt32(2, n);
        this.writeMessage(3, messageLite);
        this.writeTag(1, 4);
    }

    @Override
    public void writeRawMessageSetExtension(int n, ByteString byteString) {
        this.writeTag(1, 3);
        this.writeUInt32(2, n);
        this.writeBytes(3, byteString);
        this.writeTag(1, 4);
    }

    @Override
    public void writeMessageNoTag(MessageLite messageLite) {
        this.writeUInt32NoTag(messageLite.getSerializedSize());
        messageLite.writeTo(this);
    }

    @Override
    public void write(byte by) {
        if (this.position == this.limit) {
            this.doFlush();
        }
        this.buffer(by);
    }

    @Override
    public void writeInt32NoTag(int n) {
        if (n >= 0) {
            this.writeUInt32NoTag(n);
        } else {
            this.writeUInt64NoTag(n);
        }
    }

    @Override
    public void writeUInt32NoTag(int n) {
        this.flushIfNotAvailable(10);
        this.bufferUInt32NoTag(n);
    }

    @Override
    public void writeFixed32NoTag(int n) {
        this.flushIfNotAvailable(4);
        this.bufferFixed32NoTag(n);
    }

    @Override
    public void writeUInt64NoTag(long l) {
        this.flushIfNotAvailable(10);
        this.bufferUInt64NoTag(l);
    }

    @Override
    public void writeFixed64NoTag(long l) {
        this.flushIfNotAvailable(8);
        this.bufferFixed64NoTag(l);
    }

    @Override
    public void writeStringNoTag(String string) {
        int n = string.length() * 3;
        int n2 = CodedOutputStream$ByteOutputEncoder.computeUInt32SizeNoTag(n);
        if (n2 + n > this.limit) {
            byte[] byArray = new byte[n];
            int n3 = Utf8.encode(string, byArray, 0, n);
            this.writeUInt32NoTag(n3);
            this.writeLazy(byArray, 0, n3);
            return;
        }
        if (n2 + n > this.limit - this.position) {
            this.doFlush();
        }
        int n4 = this.position;
        try {
            int n5 = CodedOutputStream$ByteOutputEncoder.computeUInt32SizeNoTag(string.length());
            if (n5 == n2) {
                this.position = n4 + n5;
                int n6 = Utf8.encode(string, this.buffer, this.position, this.limit - this.position);
                this.position = n4;
                int n7 = n6 - n4 - n5;
                this.bufferUInt32NoTag(n7);
                this.position = n6;
                this.totalBytesWritten += n7;
            } else {
                int n8 = Utf8.encodedLength(string);
                this.bufferUInt32NoTag(n8);
                this.position = Utf8.encode(string, this.buffer, this.position, n8);
                this.totalBytesWritten += n8;
            }
        }
        catch (Utf8$UnpairedSurrogateException utf8$UnpairedSurrogateException) {
            this.totalBytesWritten -= this.position - n4;
            this.position = n4;
            this.inefficientWriteStringNoTag(string, utf8$UnpairedSurrogateException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new CodedOutputStream$OutOfSpaceException(indexOutOfBoundsException);
        }
    }

    @Override
    public void flush() {
        if (this.position > 0) {
            this.doFlush();
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        this.flush();
        this.out.write(byArray, n, n2);
        this.totalBytesWritten += n2;
    }

    @Override
    public void writeLazy(byte[] byArray, int n, int n2) {
        this.flush();
        this.out.writeLazy(byArray, n, n2);
        this.totalBytesWritten += n2;
    }

    @Override
    public void write(ByteBuffer byteBuffer) {
        this.flush();
        int n = byteBuffer.remaining();
        this.out.write(byteBuffer);
        this.totalBytesWritten += n;
    }

    @Override
    public void writeLazy(ByteBuffer byteBuffer) {
        this.flush();
        int n = byteBuffer.remaining();
        this.out.writeLazy(byteBuffer);
        this.totalBytesWritten += n;
    }

    private void flushIfNotAvailable(int n) {
        if (this.limit - this.position < n) {
            this.doFlush();
        }
    }

    private void doFlush() {
        this.out.write(this.buffer, 0, this.position);
        this.position = 0;
    }
}

