/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.CodedOutputStream$OutOfSpaceException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Utf8;
import com.google.protobuf.Utf8$UnpairedSurrogateException;
import com.google.protobuf.WireFormat;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class CodedOutputStream$SafeDirectNioEncoder
extends CodedOutputStream {
    private final ByteBuffer originalBuffer;
    private final ByteBuffer buffer;
    private final int initialPosition;

    CodedOutputStream$SafeDirectNioEncoder(ByteBuffer byteBuffer) {
        super(null);
        this.originalBuffer = byteBuffer;
        this.buffer = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        this.initialPosition = byteBuffer.position();
    }

    @Override
    public void writeTag(int n, int n2) {
        this.writeUInt32NoTag(WireFormat.makeTag(n, n2));
    }

    @Override
    public void writeInt32(int n, int n2) {
        this.writeTag(n, 0);
        this.writeInt32NoTag(n2);
    }

    @Override
    public void writeUInt32(int n, int n2) {
        this.writeTag(n, 0);
        this.writeUInt32NoTag(n2);
    }

    @Override
    public void writeFixed32(int n, int n2) {
        this.writeTag(n, 5);
        this.writeFixed32NoTag(n2);
    }

    @Override
    public void writeUInt64(int n, long l) {
        this.writeTag(n, 0);
        this.writeUInt64NoTag(l);
    }

    @Override
    public void writeFixed64(int n, long l) {
        this.writeTag(n, 1);
        this.writeFixed64NoTag(l);
    }

    @Override
    public void writeBool(int n, boolean bl) {
        this.writeTag(n, 0);
        this.write((byte)(bl ? 1 : 0));
    }

    @Override
    public void writeString(int n, String string) {
        this.writeTag(n, 2);
        this.writeStringNoTag(string);
    }

    @Override
    public void writeBytes(int n, ByteString byteString) {
        this.writeTag(n, 2);
        this.writeBytesNoTag(byteString);
    }

    @Override
    public void writeByteArray(int n, byte[] byArray) {
        this.writeByteArray(n, byArray, 0, byArray.length);
    }

    @Override
    public void writeByteArray(int n, byte[] byArray, int n2, int n3) {
        this.writeTag(n, 2);
        this.writeByteArrayNoTag(byArray, n2, n3);
    }

    @Override
    public void writeByteBuffer(int n, ByteBuffer byteBuffer) {
        this.writeTag(n, 2);
        this.writeUInt32NoTag(byteBuffer.capacity());
        this.writeRawBytes(byteBuffer);
    }

    @Override
    public void writeMessage(int n, MessageLite messageLite) {
        this.writeTag(n, 2);
        this.writeMessageNoTag(messageLite);
    }

    @Override
    public void writeMessageSetExtension(int n, MessageLite messageLite) {
        this.writeTag(1, 3);
        this.writeUInt32(2, n);
        this.writeMessage(3, messageLite);
        this.writeTag(1, 4);
    }

    @Override
    public void writeRawMessageSetExtension(int n, ByteString byteString) {
        this.writeTag(1, 3);
        this.writeUInt32(2, n);
        this.writeBytes(3, byteString);
        this.writeTag(1, 4);
    }

    @Override
    public void writeMessageNoTag(MessageLite messageLite) {
        this.writeUInt32NoTag(messageLite.getSerializedSize());
        messageLite.writeTo(this);
    }

    @Override
    public void write(byte by) {
        try {
            this.buffer.put(by);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new CodedOutputStream$OutOfSpaceException(bufferOverflowException);
        }
    }

    @Override
    public void writeBytesNoTag(ByteString byteString) {
        this.writeUInt32NoTag(byteString.size());
        byteString.writeTo(this);
    }

    @Override
    public void writeByteArrayNoTag(byte[] byArray, int n, int n2) {
        this.writeUInt32NoTag(n2);
        this.write(byArray, n, n2);
    }

    @Override
    public void writeRawBytes(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            this.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.capacity());
        } else {
            ByteBuffer byteBuffer2 = byteBuffer.duplicate();
            byteBuffer2.clear();
            this.write(byteBuffer2);
        }
    }

    @Override
    public void writeInt32NoTag(int n) {
        if (n >= 0) {
            this.writeUInt32NoTag(n);
        } else {
            this.writeUInt64NoTag(n);
        }
    }

    @Override
    public void writeUInt32NoTag(int n) {
        try {
            while (true) {
                if ((n & 0xFFFFFF80) == 0) {
                    this.buffer.put((byte)n);
                    return;
                }
                this.buffer.put((byte)(n & 0x7F | 0x80));
                n >>>= 7;
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new CodedOutputStream$OutOfSpaceException(bufferOverflowException);
        }
    }

    @Override
    public void writeFixed32NoTag(int n) {
        try {
            this.buffer.putInt(n);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new CodedOutputStream$OutOfSpaceException(bufferOverflowException);
        }
    }

    @Override
    public void writeUInt64NoTag(long l) {
        try {
            while (true) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    this.buffer.put((byte)l);
                    return;
                }
                this.buffer.put((byte)((int)l & 0x7F | 0x80));
                l >>>= 7;
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new CodedOutputStream$OutOfSpaceException(bufferOverflowException);
        }
    }

    @Override
    public void writeFixed64NoTag(long l) {
        try {
            this.buffer.putLong(l);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new CodedOutputStream$OutOfSpaceException(bufferOverflowException);
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        try {
            this.buffer.put(byArray, n, n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new CodedOutputStream$OutOfSpaceException(indexOutOfBoundsException);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new CodedOutputStream$OutOfSpaceException(bufferOverflowException);
        }
    }

    @Override
    public void writeLazy(byte[] byArray, int n, int n2) {
        this.write(byArray, n, n2);
    }

    @Override
    public void write(ByteBuffer byteBuffer) {
        try {
            this.buffer.put(byteBuffer);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new CodedOutputStream$OutOfSpaceException(bufferOverflowException);
        }
    }

    @Override
    public void writeLazy(ByteBuffer byteBuffer) {
        this.write(byteBuffer);
    }

    @Override
    public void writeStringNoTag(String string) {
        int n = this.buffer.position();
        try {
            int n2 = string.length() * 3;
            int n3 = CodedOutputStream$SafeDirectNioEncoder.computeUInt32SizeNoTag(n2);
            int n4 = CodedOutputStream$SafeDirectNioEncoder.computeUInt32SizeNoTag(string.length());
            if (n4 == n3) {
                int n5 = this.buffer.position() + n4;
                this.buffer.position(n5);
                this.encode(string);
                int n6 = this.buffer.position();
                this.buffer.position(n);
                this.writeUInt32NoTag(n6 - n5);
                this.buffer.position(n6);
            } else {
                int n7 = Utf8.encodedLength(string);
                this.writeUInt32NoTag(n7);
                this.encode(string);
            }
        }
        catch (Utf8$UnpairedSurrogateException utf8$UnpairedSurrogateException) {
            this.buffer.position(n);
            this.inefficientWriteStringNoTag(string, utf8$UnpairedSurrogateException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CodedOutputStream$OutOfSpaceException(illegalArgumentException);
        }
    }

    @Override
    public void flush() {
        this.originalBuffer.position(this.buffer.position());
    }

    @Override
    public int spaceLeft() {
        return this.buffer.remaining();
    }

    @Override
    public int getTotalBytesWritten() {
        return this.buffer.position() - this.initialPosition;
    }

    private void encode(String string) {
        try {
            Utf8.encodeUtf8(string, this.buffer);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new CodedOutputStream$OutOfSpaceException(indexOutOfBoundsException);
        }
    }
}

