/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteOutput;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream$1;
import com.google.protobuf.CodedOutputStream$ArrayEncoder;
import com.google.protobuf.CodedOutputStream$ByteOutputEncoder;
import com.google.protobuf.CodedOutputStream$HeapNioEncoder;
import com.google.protobuf.CodedOutputStream$OutOfSpaceException;
import com.google.protobuf.CodedOutputStream$OutputStreamEncoder;
import com.google.protobuf.CodedOutputStream$SafeDirectNioEncoder;
import com.google.protobuf.CodedOutputStream$UnsafeDirectNioEncoder;
import com.google.protobuf.Internal;
import com.google.protobuf.LazyFieldLite;
import com.google.protobuf.MessageLite;
import com.google.protobuf.UnsafeUtil;
import com.google.protobuf.Utf8;
import com.google.protobuf.Utf8$UnpairedSurrogateException;
import com.google.protobuf.WireFormat;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CodedOutputStream
extends ByteOutput {
    private static final Logger logger = Logger.getLogger(CodedOutputStream.class.getName());
    private static final boolean HAS_UNSAFE_ARRAY_OPERATIONS = UnsafeUtil.hasUnsafeArrayOperations();
    @Deprecated
    public static final int LITTLE_ENDIAN_32_SIZE = 4;
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private boolean serializationDeterministic;

    static int computePreferredBufferSize(int n) {
        if (n > 4096) {
            return 4096;
        }
        return n;
    }

    public static CodedOutputStream newInstance(OutputStream outputStream) {
        return CodedOutputStream.newInstance(outputStream, 4096);
    }

    public static CodedOutputStream newInstance(OutputStream outputStream, int n) {
        return new CodedOutputStream$OutputStreamEncoder(outputStream, n);
    }

    public static CodedOutputStream newInstance(byte[] byArray) {
        return CodedOutputStream.newInstance(byArray, 0, byArray.length);
    }

    public static CodedOutputStream newInstance(byte[] byArray, int n, int n2) {
        return new CodedOutputStream$ArrayEncoder(byArray, n, n2);
    }

    public static CodedOutputStream newInstance(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return new CodedOutputStream$HeapNioEncoder(byteBuffer);
        }
        if (byteBuffer.isDirect() && !byteBuffer.isReadOnly()) {
            return CodedOutputStream$UnsafeDirectNioEncoder.isSupported() ? CodedOutputStream.newUnsafeInstance(byteBuffer) : CodedOutputStream.newSafeInstance(byteBuffer);
        }
        throw new IllegalArgumentException("ByteBuffer is read-only");
    }

    static CodedOutputStream newUnsafeInstance(ByteBuffer byteBuffer) {
        return new CodedOutputStream$UnsafeDirectNioEncoder(byteBuffer);
    }

    static CodedOutputStream newSafeInstance(ByteBuffer byteBuffer) {
        return new CodedOutputStream$SafeDirectNioEncoder(byteBuffer);
    }

    public void useDeterministicSerialization() {
        this.serializationDeterministic = true;
    }

    boolean isSerializationDeterministic() {
        return this.serializationDeterministic;
    }

    @Deprecated
    public static CodedOutputStream newInstance(ByteBuffer byteBuffer, int n) {
        return CodedOutputStream.newInstance(byteBuffer);
    }

    static CodedOutputStream newInstance(ByteOutput byteOutput, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("bufferSize must be positive");
        }
        return new CodedOutputStream$ByteOutputEncoder(byteOutput, n);
    }

    private CodedOutputStream() {
    }

    public abstract void writeTag(int var1, int var2);

    public abstract void writeInt32(int var1, int var2);

    public abstract void writeUInt32(int var1, int var2);

    public final void writeSInt32(int n, int n2) {
        this.writeUInt32(n, CodedOutputStream.encodeZigZag32(n2));
    }

    public abstract void writeFixed32(int var1, int var2);

    public final void writeSFixed32(int n, int n2) {
        this.writeFixed32(n, n2);
    }

    public final void writeInt64(int n, long l) {
        this.writeUInt64(n, l);
    }

    public abstract void writeUInt64(int var1, long var2);

    public final void writeSInt64(int n, long l) {
        this.writeUInt64(n, CodedOutputStream.encodeZigZag64(l));
    }

    public abstract void writeFixed64(int var1, long var2);

    public final void writeSFixed64(int n, long l) {
        this.writeFixed64(n, l);
    }

    public final void writeFloat(int n, float f2) {
        this.writeFixed32(n, Float.floatToRawIntBits(f2));
    }

    public final void writeDouble(int n, double d2) {
        this.writeFixed64(n, Double.doubleToRawLongBits(d2));
    }

    public abstract void writeBool(int var1, boolean var2);

    public final void writeEnum(int n, int n2) {
        this.writeInt32(n, n2);
    }

    public abstract void writeString(int var1, String var2);

    public abstract void writeBytes(int var1, ByteString var2);

    public abstract void writeByteArray(int var1, byte[] var2);

    public abstract void writeByteArray(int var1, byte[] var2, int var3, int var4);

    public abstract void writeByteBuffer(int var1, ByteBuffer var2);

    public final void writeRawByte(byte by) {
        this.write(by);
    }

    public final void writeRawByte(int n) {
        this.write((byte)n);
    }

    public final void writeRawBytes(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public final void writeRawBytes(byte[] byArray, int n, int n2) {
        this.write(byArray, n, n2);
    }

    public final void writeRawBytes(ByteString byteString) {
        byteString.writeTo(this);
    }

    public abstract void writeRawBytes(ByteBuffer var1);

    public abstract void writeMessage(int var1, MessageLite var2);

    public abstract void writeMessageSetExtension(int var1, MessageLite var2);

    public abstract void writeRawMessageSetExtension(int var1, ByteString var2);

    public abstract void writeInt32NoTag(int var1);

    public abstract void writeUInt32NoTag(int var1);

    public final void writeSInt32NoTag(int n) {
        this.writeUInt32NoTag(CodedOutputStream.encodeZigZag32(n));
    }

    public abstract void writeFixed32NoTag(int var1);

    public final void writeSFixed32NoTag(int n) {
        this.writeFixed32NoTag(n);
    }

    public final void writeInt64NoTag(long l) {
        this.writeUInt64NoTag(l);
    }

    public abstract void writeUInt64NoTag(long var1);

    public final void writeSInt64NoTag(long l) {
        this.writeUInt64NoTag(CodedOutputStream.encodeZigZag64(l));
    }

    public abstract void writeFixed64NoTag(long var1);

    public final void writeSFixed64NoTag(long l) {
        this.writeFixed64NoTag(l);
    }

    public final void writeFloatNoTag(float f2) {
        this.writeFixed32NoTag(Float.floatToRawIntBits(f2));
    }

    public final void writeDoubleNoTag(double d2) {
        this.writeFixed64NoTag(Double.doubleToRawLongBits(d2));
    }

    public final void writeBoolNoTag(boolean bl) {
        this.write((byte)(bl ? 1 : 0));
    }

    public final void writeEnumNoTag(int n) {
        this.writeInt32NoTag(n);
    }

    public abstract void writeStringNoTag(String var1);

    public abstract void writeBytesNoTag(ByteString var1);

    public final void writeByteArrayNoTag(byte[] byArray) {
        this.writeByteArrayNoTag(byArray, 0, byArray.length);
    }

    public abstract void writeMessageNoTag(MessageLite var1);

    @Override
    public abstract void write(byte var1);

    @Override
    public abstract void write(byte[] var1, int var2, int var3);

    @Override
    public abstract void writeLazy(byte[] var1, int var2, int var3);

    @Override
    public abstract void write(ByteBuffer var1);

    @Override
    public abstract void writeLazy(ByteBuffer var1);

    public static int computeInt32Size(int n, int n2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeInt32SizeNoTag(n2);
    }

    public static int computeUInt32Size(int n, int n2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeUInt32SizeNoTag(n2);
    }

    public static int computeSInt32Size(int n, int n2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeSInt32SizeNoTag(n2);
    }

    public static int computeFixed32Size(int n, int n2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeFixed32SizeNoTag(n2);
    }

    public static int computeSFixed32Size(int n, int n2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeSFixed32SizeNoTag(n2);
    }

    public static int computeInt64Size(int n, long l) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeInt64SizeNoTag(l);
    }

    public static int computeUInt64Size(int n, long l) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeUInt64SizeNoTag(l);
    }

    public static int computeSInt64Size(int n, long l) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeSInt64SizeNoTag(l);
    }

    public static int computeFixed64Size(int n, long l) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeFixed64SizeNoTag(l);
    }

    public static int computeSFixed64Size(int n, long l) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeSFixed64SizeNoTag(l);
    }

    public static int computeFloatSize(int n, float f2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeFloatSizeNoTag(f2);
    }

    public static int computeDoubleSize(int n, double d2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeDoubleSizeNoTag(d2);
    }

    public static int computeBoolSize(int n, boolean bl) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeBoolSizeNoTag(bl);
    }

    public static int computeEnumSize(int n, int n2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeEnumSizeNoTag(n2);
    }

    public static int computeStringSize(int n, String string) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeStringSizeNoTag(string);
    }

    public static int computeBytesSize(int n, ByteString byteString) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeBytesSizeNoTag(byteString);
    }

    public static int computeByteArraySize(int n, byte[] byArray) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeByteArraySizeNoTag(byArray);
    }

    public static int computeByteBufferSize(int n, ByteBuffer byteBuffer) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeByteBufferSizeNoTag(byteBuffer);
    }

    public static int computeLazyFieldSize(int n, LazyFieldLite lazyFieldLite) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeLazyFieldSizeNoTag(lazyFieldLite);
    }

    public static int computeMessageSize(int n, MessageLite messageLite) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeMessageSizeNoTag(messageLite);
    }

    public static int computeMessageSetExtensionSize(int n, MessageLite messageLite) {
        return CodedOutputStream.computeTagSize(1) * 2 + CodedOutputStream.computeUInt32Size(2, n) + CodedOutputStream.computeMessageSize(3, messageLite);
    }

    public static int computeRawMessageSetExtensionSize(int n, ByteString byteString) {
        return CodedOutputStream.computeTagSize(1) * 2 + CodedOutputStream.computeUInt32Size(2, n) + CodedOutputStream.computeBytesSize(3, byteString);
    }

    public static int computeLazyFieldMessageSetExtensionSize(int n, LazyFieldLite lazyFieldLite) {
        return CodedOutputStream.computeTagSize(1) * 2 + CodedOutputStream.computeUInt32Size(2, n) + CodedOutputStream.computeLazyFieldSize(3, lazyFieldLite);
    }

    public static int computeTagSize(int n) {
        return CodedOutputStream.computeUInt32SizeNoTag(WireFormat.makeTag(n, 0));
    }

    public static int computeInt32SizeNoTag(int n) {
        if (n >= 0) {
            return CodedOutputStream.computeUInt32SizeNoTag(n);
        }
        return 10;
    }

    public static int computeUInt32SizeNoTag(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int computeSInt32SizeNoTag(int n) {
        return CodedOutputStream.computeUInt32SizeNoTag(CodedOutputStream.encodeZigZag32(n));
    }

    public static int computeFixed32SizeNoTag(int n) {
        return 4;
    }

    public static int computeSFixed32SizeNoTag(int n) {
        return 4;
    }

    public static int computeInt64SizeNoTag(long l) {
        return CodedOutputStream.computeUInt64SizeNoTag(l);
    }

    public static int computeUInt64SizeNoTag(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l < 0L) {
            return 10;
        }
        int n = 2;
        if ((l & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            l >>>= 28;
        }
        if ((l & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            l >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static int computeSInt64SizeNoTag(long l) {
        return CodedOutputStream.computeUInt64SizeNoTag(CodedOutputStream.encodeZigZag64(l));
    }

    public static int computeFixed64SizeNoTag(long l) {
        return 8;
    }

    public static int computeSFixed64SizeNoTag(long l) {
        return 8;
    }

    public static int computeFloatSizeNoTag(float f2) {
        return 4;
    }

    public static int computeDoubleSizeNoTag(double d2) {
        return 8;
    }

    public static int computeBoolSizeNoTag(boolean bl) {
        return 1;
    }

    public static int computeEnumSizeNoTag(int n) {
        return CodedOutputStream.computeInt32SizeNoTag(n);
    }

    public static int computeStringSizeNoTag(String string) {
        int n;
        try {
            n = Utf8.encodedLength(string);
        }
        catch (Utf8$UnpairedSurrogateException utf8$UnpairedSurrogateException) {
            byte[] byArray = string.getBytes(Internal.UTF_8);
            n = byArray.length;
        }
        return CodedOutputStream.computeLengthDelimitedFieldSize(n);
    }

    public static int computeLazyFieldSizeNoTag(LazyFieldLite lazyFieldLite) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(lazyFieldLite.getSerializedSize());
    }

    public static int computeBytesSizeNoTag(ByteString byteString) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(byteString.size());
    }

    public static int computeByteArraySizeNoTag(byte[] byArray) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(byArray.length);
    }

    public static int computeByteBufferSizeNoTag(ByteBuffer byteBuffer) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(byteBuffer.capacity());
    }

    public static int computeMessageSizeNoTag(MessageLite messageLite) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(messageLite.getSerializedSize());
    }

    static int computeLengthDelimitedFieldSize(int n) {
        return CodedOutputStream.computeUInt32SizeNoTag(n) + n;
    }

    public static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long encodeZigZag64(long l) {
        return l << 1 ^ l >> 63;
    }

    public abstract void flush();

    public abstract int spaceLeft();

    public final void checkNoSpaceLeft() {
        if (this.spaceLeft() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    public abstract int getTotalBytesWritten();

    abstract void writeByteArrayNoTag(byte[] var1, int var2, int var3);

    final void inefficientWriteStringNoTag(String string, Utf8$UnpairedSurrogateException utf8$UnpairedSurrogateException) {
        logger.log(Level.WARNING, "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", utf8$UnpairedSurrogateException);
        byte[] byArray = string.getBytes(Internal.UTF_8);
        try {
            this.writeUInt32NoTag(byArray.length);
            this.writeLazy(byArray, 0, byArray.length);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new CodedOutputStream$OutOfSpaceException(indexOutOfBoundsException);
        }
        catch (CodedOutputStream$OutOfSpaceException codedOutputStream$OutOfSpaceException) {
            throw codedOutputStream$OutOfSpaceException;
        }
    }

    @Deprecated
    public final void writeGroup(int n, MessageLite messageLite) {
        this.writeTag(n, 3);
        this.writeGroupNoTag(messageLite);
        this.writeTag(n, 4);
    }

    @Deprecated
    public final void writeGroupNoTag(MessageLite messageLite) {
        messageLite.writeTo(this);
    }

    @Deprecated
    public static int computeGroupSize(int n, MessageLite messageLite) {
        return CodedOutputStream.computeTagSize(n) * 2 + CodedOutputStream.computeGroupSizeNoTag(messageLite);
    }

    @Deprecated
    public static int computeGroupSizeNoTag(MessageLite messageLite) {
        return messageLite.getSerializedSize();
    }

    @Deprecated
    public final void writeRawVarint32(int n) {
        this.writeUInt32NoTag(n);
    }

    @Deprecated
    public final void writeRawVarint64(long l) {
        this.writeUInt64NoTag(l);
    }

    @Deprecated
    public static int computeRawVarint32Size(int n) {
        return CodedOutputStream.computeUInt32SizeNoTag(n);
    }

    @Deprecated
    public static int computeRawVarint64Size(long l) {
        return CodedOutputStream.computeUInt64SizeNoTag(l);
    }

    @Deprecated
    public final void writeRawLittleEndian32(int n) {
        this.writeFixed32NoTag(n);
    }

    @Deprecated
    public final void writeRawLittleEndian64(long l) {
        this.writeFixed64NoTag(l);
    }

    /* synthetic */ CodedOutputStream(CodedOutputStream$1 codedOutputStream$1) {
        this();
    }

    static /* synthetic */ boolean access$100() {
        return HAS_UNSAFE_ARRAY_OPERATIONS;
    }
}

