/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractProtobufList;
import com.google.protobuf.Internal;
import com.google.protobuf.Internal$DoubleList;
import com.google.protobuf.PrimitiveNonBoxingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class DoubleArrayList
extends AbstractProtobufList<Double>
implements Internal$DoubleList,
PrimitiveNonBoxingCollection,
RandomAccess {
    private static final DoubleArrayList EMPTY_LIST = new DoubleArrayList(new double[0], 0);
    private double[] array;
    private int size;

    public static DoubleArrayList emptyList() {
        return EMPTY_LIST;
    }

    DoubleArrayList() {
        this(new double[10], 0);
    }

    private DoubleArrayList(double[] dArray, int n) {
        this.array = dArray;
        this.size = n;
    }

    @Override
    protected void removeRange(int n, int n2) {
        this.ensureIsMutable();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.array, n2, this.array, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DoubleArrayList)) {
            return super.equals(object);
        }
        DoubleArrayList doubleArrayList = (DoubleArrayList)object;
        if (this.size != doubleArrayList.size) {
            return false;
        }
        double[] dArray = doubleArrayList.array;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.array[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.array[i]);
            n = 31 * n + Internal.hashLong(l);
        }
        return n;
    }

    @Override
    public Internal$DoubleList mutableCopyWithCapacity(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new DoubleArrayList(Arrays.copyOf(this.array, n), this.size);
    }

    @Override
    public Double get(int n) {
        return this.getDouble(n);
    }

    @Override
    public double getDouble(int n) {
        this.ensureIndexInRange(n);
        return this.array[n];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Double set(int n, Double d2) {
        return this.setDouble(n, d2);
    }

    @Override
    public double setDouble(int n, double d2) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n);
        double d3 = this.array[n];
        this.array[n] = d2;
        return d3;
    }

    @Override
    public void add(int n, Double d2) {
        this.addDouble(n, d2);
    }

    @Override
    public void addDouble(double d2) {
        this.addDouble(this.size, d2);
    }

    private void addDouble(int n, double d2) {
        this.ensureIsMutable();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, n, this.array, n + 1, this.size - n);
        } else {
            int n2 = this.size * 3 / 2 + 1;
            double[] dArray = new double[n2];
            System.arraycopy(this.array, 0, dArray, 0, n);
            System.arraycopy(this.array, n, dArray, n + 1, this.size - n);
            this.array = dArray;
        }
        this.array[n] = d2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends Double> collection) {
        this.ensureIsMutable();
        Internal.checkNotNull(collection);
        if (!(collection instanceof DoubleArrayList)) {
            return super.addAll(collection);
        }
        DoubleArrayList doubleArrayList = (DoubleArrayList)collection;
        if (doubleArrayList.size == 0) {
            return false;
        }
        int n = Integer.MAX_VALUE - this.size;
        if (n < doubleArrayList.size) {
            throw new OutOfMemoryError();
        }
        int n2 = this.size + doubleArrayList.size;
        if (n2 > this.array.length) {
            this.array = Arrays.copyOf(this.array, n2);
        }
        System.arraycopy(doubleArrayList.array, 0, this.array, this.size, doubleArrayList.size);
        this.size = n2;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean remove(Object object) {
        this.ensureIsMutable();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.array[i])) continue;
            System.arraycopy(this.array, i + 1, this.array, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public Double remove(int n) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n);
        double d2 = this.array[n];
        if (n < this.size - 1) {
            System.arraycopy(this.array, n + 1, this.array, n, this.size - n - 1);
        }
        --this.size;
        ++this.modCount;
        return d2;
    }

    private void ensureIndexInRange(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int n) {
        int n2 = n;
        int n3 = this.size;
        return new StringBuilder(35).append("Index:").append(n2).append(", Size:").append(n3).toString();
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

