/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.FieldSet$FieldDescriptorLite;
import com.google.protobuf.Internal;
import com.google.protobuf.Internal$EnumLite;
import com.google.protobuf.LazyField;
import com.google.protobuf.LazyField$LazyIterator;
import com.google.protobuf.MessageLite;
import com.google.protobuf.SmallSortedMap;
import com.google.protobuf.WireFormat;
import com.google.protobuf.WireFormat$FieldType;
import com.google.protobuf.WireFormat$JavaType;
import com.google.protobuf.WireFormat$Utf8Validation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class FieldSet<FieldDescriptorType extends FieldSet$FieldDescriptorLite<FieldDescriptorType>> {
    private final SmallSortedMap<FieldDescriptorType, Object> fields;
    private boolean isImmutable;
    private boolean hasLazyField = false;
    private static final FieldSet DEFAULT_INSTANCE = new FieldSet(true);

    private FieldSet() {
        this.fields = SmallSortedMap.newFieldMap(16);
    }

    private FieldSet(boolean bl) {
        this.fields = SmallSortedMap.newFieldMap(0);
        this.makeImmutable();
    }

    public static <T extends FieldSet$FieldDescriptorLite<T>> FieldSet<T> newFieldSet() {
        return new FieldSet();
    }

    public static <T extends FieldSet$FieldDescriptorLite<T>> FieldSet<T> emptySet() {
        return DEFAULT_INSTANCE;
    }

    boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public void makeImmutable() {
        if (this.isImmutable) {
            return;
        }
        this.fields.makeImmutable();
        this.isImmutable = true;
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FieldSet)) {
            return false;
        }
        FieldSet fieldSet = (FieldSet)object;
        return this.fields.equals(fieldSet.fields);
    }

    public int hashCode() {
        return this.fields.hashCode();
    }

    public FieldSet<FieldDescriptorType> clone() {
        FieldSet$FieldDescriptorLite fieldSet$FieldDescriptorLite;
        FieldSet fieldSet = FieldSet.newFieldSet();
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry<FieldDescriptorType, Object> entry = this.fields.getArrayEntryAt(i);
            fieldSet$FieldDescriptorLite = (FieldSet$FieldDescriptorLite)entry.getKey();
            fieldSet.setField(fieldSet$FieldDescriptorLite, entry.getValue());
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            fieldSet$FieldDescriptorLite = (FieldSet$FieldDescriptorLite)entry.getKey();
            fieldSet.setField(fieldSet$FieldDescriptorLite, entry.getValue());
        }
        fieldSet.hasLazyField = this.hasLazyField;
        return fieldSet;
    }

    public void clear() {
        this.fields.clear();
        this.hasLazyField = false;
    }

    public Map<FieldDescriptorType, Object> getAllFields() {
        if (this.hasLazyField) {
            SmallSortedMap smallSortedMap = SmallSortedMap.newFieldMap(16);
            for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
                this.cloneFieldEntry(smallSortedMap, this.fields.getArrayEntryAt(i));
            }
            for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
                this.cloneFieldEntry(smallSortedMap, entry);
            }
            if (this.fields.isImmutable()) {
                smallSortedMap.makeImmutable();
            }
            return smallSortedMap;
        }
        return this.fields.isImmutable() ? this.fields : Collections.unmodifiableMap(this.fields);
    }

    private void cloneFieldEntry(Map<FieldDescriptorType, Object> map, Map.Entry<FieldDescriptorType, Object> entry) {
        FieldSet$FieldDescriptorLite fieldSet$FieldDescriptorLite = (FieldSet$FieldDescriptorLite)entry.getKey();
        Object object = entry.getValue();
        if (object instanceof LazyField) {
            map.put(fieldSet$FieldDescriptorLite, ((LazyField)object).getValue());
        } else {
            map.put(fieldSet$FieldDescriptorLite, object);
        }
    }

    public Iterator<Map.Entry<FieldDescriptorType, Object>> iterator() {
        if (this.hasLazyField) {
            return new LazyField$LazyIterator(this.fields.entrySet().iterator());
        }
        return this.fields.entrySet().iterator();
    }

    public boolean hasField(FieldDescriptorType FieldDescriptorType) {
        if (FieldDescriptorType.isRepeated()) {
            throw new IllegalArgumentException("hasField() can only be called on non-repeated fields.");
        }
        return this.fields.get(FieldDescriptorType) != null;
    }

    public Object getField(FieldDescriptorType FieldDescriptorType) {
        Object object = this.fields.get(FieldDescriptorType);
        if (object instanceof LazyField) {
            return ((LazyField)object).getValue();
        }
        return object;
    }

    public void setField(FieldDescriptorType FieldDescriptorType, Object arrayList) {
        if (FieldDescriptorType.isRepeated()) {
            if (!(arrayList instanceof List)) {
                throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
            }
            ArrayList arrayList2 = new ArrayList();
            arrayList2.addAll(arrayList);
            for (Object e2 : arrayList2) {
                FieldSet.verifyType(FieldDescriptorType.getLiteType(), e2);
            }
            arrayList = arrayList2;
        } else {
            FieldSet.verifyType(FieldDescriptorType.getLiteType(), arrayList);
        }
        if (arrayList instanceof LazyField) {
            this.hasLazyField = true;
        }
        this.fields.put(FieldDescriptorType, (Object)arrayList);
    }

    public void clearField(FieldDescriptorType FieldDescriptorType) {
        this.fields.remove(FieldDescriptorType);
        if (this.fields.isEmpty()) {
            this.hasLazyField = false;
        }
    }

    public int getRepeatedFieldCount(FieldDescriptorType FieldDescriptorType) {
        if (!FieldDescriptorType.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object object = this.getField(FieldDescriptorType);
        if (object == null) {
            return 0;
        }
        return ((List)object).size();
    }

    public Object getRepeatedField(FieldDescriptorType FieldDescriptorType, int n) {
        if (!FieldDescriptorType.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object object = this.getField(FieldDescriptorType);
        if (object == null) {
            throw new IndexOutOfBoundsException();
        }
        return ((List)object).get(n);
    }

    public void setRepeatedField(FieldDescriptorType FieldDescriptorType, int n, Object object) {
        if (!FieldDescriptorType.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object object2 = this.getField(FieldDescriptorType);
        if (object2 == null) {
            throw new IndexOutOfBoundsException();
        }
        FieldSet.verifyType(FieldDescriptorType.getLiteType(), object);
        ((List)object2).set(n, object);
    }

    public void addRepeatedField(FieldDescriptorType FieldDescriptorType, Object object) {
        ArrayList<Object> arrayList;
        if (!FieldDescriptorType.isRepeated()) {
            throw new IllegalArgumentException("addRepeatedField() can only be called on repeated fields.");
        }
        FieldSet.verifyType(FieldDescriptorType.getLiteType(), object);
        Object object2 = this.getField(FieldDescriptorType);
        if (object2 == null) {
            arrayList = new ArrayList<Object>();
            this.fields.put(FieldDescriptorType, (Object)arrayList);
        } else {
            arrayList = (ArrayList<Object>)object2;
        }
        arrayList.add(object);
    }

    private static void verifyType(WireFormat$FieldType wireFormat$FieldType, Object object) {
        Internal.checkNotNull(object);
        boolean bl = false;
        switch (wireFormat$FieldType.getJavaType()) {
            case INT: {
                bl = object instanceof Integer;
                break;
            }
            case LONG: {
                bl = object instanceof Long;
                break;
            }
            case FLOAT: {
                bl = object instanceof Float;
                break;
            }
            case DOUBLE: {
                bl = object instanceof Double;
                break;
            }
            case BOOLEAN: {
                bl = object instanceof Boolean;
                break;
            }
            case STRING: {
                bl = object instanceof String;
                break;
            }
            case BYTE_STRING: {
                bl = object instanceof ByteString || object instanceof byte[];
                break;
            }
            case ENUM: {
                bl = object instanceof Integer || object instanceof Internal$EnumLite;
                break;
            }
            case MESSAGE: {
                boolean bl2 = bl = object instanceof MessageLite || object instanceof LazyField;
            }
        }
        if (!bl) {
            throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
        }
    }

    public boolean isInitialized() {
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            if (this.isInitialized(this.fields.getArrayEntryAt(i))) continue;
            return false;
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            if (this.isInitialized(entry)) continue;
            return false;
        }
        return true;
    }

    private boolean isInitialized(Map.Entry<FieldDescriptorType, Object> entry) {
        FieldSet$FieldDescriptorLite fieldSet$FieldDescriptorLite = (FieldSet$FieldDescriptorLite)entry.getKey();
        if (fieldSet$FieldDescriptorLite.getLiteJavaType() == WireFormat$JavaType.MESSAGE) {
            if (fieldSet$FieldDescriptorLite.isRepeated()) {
                for (MessageLite messageLite : (List)entry.getValue()) {
                    if (messageLite.isInitialized()) continue;
                    return false;
                }
            } else {
                Object object = entry.getValue();
                if (object instanceof MessageLite) {
                    if (!((MessageLite)object).isInitialized()) {
                        return false;
                    }
                } else {
                    if (object instanceof LazyField) {
                        return true;
                    }
                    throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
                }
            }
        }
        return true;
    }

    static int getWireFormatForFieldType(WireFormat$FieldType wireFormat$FieldType, boolean bl) {
        if (bl) {
            return 2;
        }
        return wireFormat$FieldType.getWireType();
    }

    public void mergeFrom(FieldSet<FieldDescriptorType> fieldSet) {
        for (int i = 0; i < fieldSet.fields.getNumArrayEntries(); ++i) {
            this.mergeFromField(fieldSet.fields.getArrayEntryAt(i));
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : fieldSet.fields.getOverflowEntries()) {
            this.mergeFromField(entry);
        }
    }

    private Object cloneIfMutable(Object object) {
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            return byArray2;
        }
        return object;
    }

    private void mergeFromField(Map.Entry<FieldDescriptorType, Object> entry) {
        FieldSet$FieldDescriptorLite fieldSet$FieldDescriptorLite = (FieldSet$FieldDescriptorLite)entry.getKey();
        Object object = entry.getValue();
        if (object instanceof LazyField) {
            object = ((LazyField)object).getValue();
        }
        if (fieldSet$FieldDescriptorLite.isRepeated()) {
            ArrayList arrayList = this.getField(fieldSet$FieldDescriptorLite);
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            for (Object e2 : (List)object) {
                ((List)arrayList).add(this.cloneIfMutable(e2));
            }
            this.fields.put((FieldDescriptorType)fieldSet$FieldDescriptorLite, (Object)arrayList);
        } else if (fieldSet$FieldDescriptorLite.getLiteJavaType() == WireFormat$JavaType.MESSAGE) {
            Object object2 = this.getField(fieldSet$FieldDescriptorLite);
            if (object2 == null) {
                this.fields.put((FieldDescriptorType)fieldSet$FieldDescriptorLite, this.cloneIfMutable(object));
            } else {
                object2 = fieldSet$FieldDescriptorLite.internalMergeFrom(((MessageLite)object2).toBuilder(), (MessageLite)object).build();
                this.fields.put((FieldDescriptorType)fieldSet$FieldDescriptorLite, object2);
            }
        } else {
            this.fields.put((FieldDescriptorType)fieldSet$FieldDescriptorLite, this.cloneIfMutable(object));
        }
    }

    public static Object readPrimitiveField(CodedInputStream codedInputStream, WireFormat$FieldType wireFormat$FieldType, boolean bl) {
        if (bl) {
            return WireFormat.readPrimitiveField(codedInputStream, wireFormat$FieldType, WireFormat$Utf8Validation.STRICT);
        }
        return WireFormat.readPrimitiveField(codedInputStream, wireFormat$FieldType, WireFormat$Utf8Validation.LOOSE);
    }

    public void writeTo(CodedOutputStream codedOutputStream) {
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry<FieldDescriptorType, Object> entry = this.fields.getArrayEntryAt(i);
            FieldSet.writeField((FieldSet$FieldDescriptorLite)entry.getKey(), entry.getValue(), codedOutputStream);
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            FieldSet.writeField((FieldSet$FieldDescriptorLite)entry.getKey(), entry.getValue(), codedOutputStream);
        }
    }

    public void writeMessageSetTo(CodedOutputStream codedOutputStream) {
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            this.writeMessageSetTo(this.fields.getArrayEntryAt(i), codedOutputStream);
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            this.writeMessageSetTo(entry, codedOutputStream);
        }
    }

    private void writeMessageSetTo(Map.Entry<FieldDescriptorType, Object> entry, CodedOutputStream codedOutputStream) {
        FieldSet$FieldDescriptorLite fieldSet$FieldDescriptorLite = (FieldSet$FieldDescriptorLite)entry.getKey();
        if (fieldSet$FieldDescriptorLite.getLiteJavaType() == WireFormat$JavaType.MESSAGE && !fieldSet$FieldDescriptorLite.isRepeated() && !fieldSet$FieldDescriptorLite.isPacked()) {
            Object object = entry.getValue();
            if (object instanceof LazyField) {
                object = ((LazyField)object).getValue();
            }
            codedOutputStream.writeMessageSetExtension(((FieldSet$FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)object);
        } else {
            FieldSet.writeField(fieldSet$FieldDescriptorLite, entry.getValue(), codedOutputStream);
        }
    }

    static void writeElement(CodedOutputStream codedOutputStream, WireFormat$FieldType wireFormat$FieldType, int n, Object object) {
        if (wireFormat$FieldType == WireFormat$FieldType.GROUP) {
            codedOutputStream.writeGroup(n, (MessageLite)object);
        } else {
            codedOutputStream.writeTag(n, FieldSet.getWireFormatForFieldType(wireFormat$FieldType, false));
            FieldSet.writeElementNoTag(codedOutputStream, wireFormat$FieldType, object);
        }
    }

    static void writeElementNoTag(CodedOutputStream codedOutputStream, WireFormat$FieldType wireFormat$FieldType, Object object) {
        switch (wireFormat$FieldType) {
            case DOUBLE: {
                codedOutputStream.writeDoubleNoTag((Double)object);
                break;
            }
            case FLOAT: {
                codedOutputStream.writeFloatNoTag(((Float)object).floatValue());
                break;
            }
            case INT64: {
                codedOutputStream.writeInt64NoTag((Long)object);
                break;
            }
            case UINT64: {
                codedOutputStream.writeUInt64NoTag((Long)object);
                break;
            }
            case INT32: {
                codedOutputStream.writeInt32NoTag((Integer)object);
                break;
            }
            case FIXED64: {
                codedOutputStream.writeFixed64NoTag((Long)object);
                break;
            }
            case FIXED32: {
                codedOutputStream.writeFixed32NoTag((Integer)object);
                break;
            }
            case BOOL: {
                codedOutputStream.writeBoolNoTag((Boolean)object);
                break;
            }
            case GROUP: {
                codedOutputStream.writeGroupNoTag((MessageLite)object);
                break;
            }
            case MESSAGE: {
                codedOutputStream.writeMessageNoTag((MessageLite)object);
                break;
            }
            case STRING: {
                if (object instanceof ByteString) {
                    codedOutputStream.writeBytesNoTag((ByteString)object);
                    break;
                }
                codedOutputStream.writeStringNoTag((String)object);
                break;
            }
            case BYTES: {
                if (object instanceof ByteString) {
                    codedOutputStream.writeBytesNoTag((ByteString)object);
                    break;
                }
                codedOutputStream.writeByteArrayNoTag((byte[])object);
                break;
            }
            case UINT32: {
                codedOutputStream.writeUInt32NoTag((Integer)object);
                break;
            }
            case SFIXED32: {
                codedOutputStream.writeSFixed32NoTag((Integer)object);
                break;
            }
            case SFIXED64: {
                codedOutputStream.writeSFixed64NoTag((Long)object);
                break;
            }
            case SINT32: {
                codedOutputStream.writeSInt32NoTag((Integer)object);
                break;
            }
            case SINT64: {
                codedOutputStream.writeSInt64NoTag((Long)object);
                break;
            }
            case ENUM: {
                if (object instanceof Internal$EnumLite) {
                    codedOutputStream.writeEnumNoTag(((Internal$EnumLite)object).getNumber());
                    break;
                }
                codedOutputStream.writeEnumNoTag((Integer)object);
            }
        }
    }

    public static void writeField(FieldSet$FieldDescriptorLite<?> fieldSet$FieldDescriptorLite, Object object, CodedOutputStream codedOutputStream) {
        WireFormat$FieldType wireFormat$FieldType = fieldSet$FieldDescriptorLite.getLiteType();
        int n = fieldSet$FieldDescriptorLite.getNumber();
        if (fieldSet$FieldDescriptorLite.isRepeated()) {
            List list = (List)object;
            if (fieldSet$FieldDescriptorLite.isPacked()) {
                codedOutputStream.writeTag(n, 2);
                int n2 = 0;
                for (Object e2 : list) {
                    n2 += FieldSet.computeElementSizeNoTag(wireFormat$FieldType, e2);
                }
                codedOutputStream.writeRawVarint32(n2);
                for (Object e2 : list) {
                    FieldSet.writeElementNoTag(codedOutputStream, wireFormat$FieldType, e2);
                }
            } else {
                for (Object e3 : list) {
                    FieldSet.writeElement(codedOutputStream, wireFormat$FieldType, n, e3);
                }
            }
        } else if (object instanceof LazyField) {
            FieldSet.writeElement(codedOutputStream, wireFormat$FieldType, n, ((LazyField)object).getValue());
        } else {
            FieldSet.writeElement(codedOutputStream, wireFormat$FieldType, n, object);
        }
    }

    public int getSerializedSize() {
        int n = 0;
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry<FieldDescriptorType, Object> entry = this.fields.getArrayEntryAt(i);
            n += FieldSet.computeFieldSize((FieldSet$FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            n += FieldSet.computeFieldSize((FieldSet$FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        return n;
    }

    public int getMessageSetSerializedSize() {
        int n = 0;
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            n += this.getMessageSetSerializedSize(this.fields.getArrayEntryAt(i));
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            n += this.getMessageSetSerializedSize(entry);
        }
        return n;
    }

    private int getMessageSetSerializedSize(Map.Entry<FieldDescriptorType, Object> entry) {
        FieldSet$FieldDescriptorLite fieldSet$FieldDescriptorLite = (FieldSet$FieldDescriptorLite)entry.getKey();
        Object object = entry.getValue();
        if (fieldSet$FieldDescriptorLite.getLiteJavaType() == WireFormat$JavaType.MESSAGE && !fieldSet$FieldDescriptorLite.isRepeated() && !fieldSet$FieldDescriptorLite.isPacked()) {
            if (object instanceof LazyField) {
                return CodedOutputStream.computeLazyFieldMessageSetExtensionSize(((FieldSet$FieldDescriptorLite)entry.getKey()).getNumber(), (LazyField)object);
            }
            return CodedOutputStream.computeMessageSetExtensionSize(((FieldSet$FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)object);
        }
        return FieldSet.computeFieldSize(fieldSet$FieldDescriptorLite, object);
    }

    static int computeElementSize(WireFormat$FieldType wireFormat$FieldType, int n, Object object) {
        int n2 = CodedOutputStream.computeTagSize(n);
        if (wireFormat$FieldType == WireFormat$FieldType.GROUP) {
            n2 *= 2;
        }
        return n2 + FieldSet.computeElementSizeNoTag(wireFormat$FieldType, object);
    }

    static int computeElementSizeNoTag(WireFormat$FieldType wireFormat$FieldType, Object object) {
        switch (wireFormat$FieldType) {
            case DOUBLE: {
                return CodedOutputStream.computeDoubleSizeNoTag((Double)object);
            }
            case FLOAT: {
                return CodedOutputStream.computeFloatSizeNoTag(((Float)object).floatValue());
            }
            case INT64: {
                return CodedOutputStream.computeInt64SizeNoTag((Long)object);
            }
            case UINT64: {
                return CodedOutputStream.computeUInt64SizeNoTag((Long)object);
            }
            case INT32: {
                return CodedOutputStream.computeInt32SizeNoTag((Integer)object);
            }
            case FIXED64: {
                return CodedOutputStream.computeFixed64SizeNoTag((Long)object);
            }
            case FIXED32: {
                return CodedOutputStream.computeFixed32SizeNoTag((Integer)object);
            }
            case BOOL: {
                return CodedOutputStream.computeBoolSizeNoTag((Boolean)object);
            }
            case GROUP: {
                return CodedOutputStream.computeGroupSizeNoTag((MessageLite)object);
            }
            case BYTES: {
                if (object instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)object);
                }
                return CodedOutputStream.computeByteArraySizeNoTag((byte[])object);
            }
            case STRING: {
                if (object instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)object);
                }
                return CodedOutputStream.computeStringSizeNoTag((String)object);
            }
            case UINT32: {
                return CodedOutputStream.computeUInt32SizeNoTag((Integer)object);
            }
            case SFIXED32: {
                return CodedOutputStream.computeSFixed32SizeNoTag((Integer)object);
            }
            case SFIXED64: {
                return CodedOutputStream.computeSFixed64SizeNoTag((Long)object);
            }
            case SINT32: {
                return CodedOutputStream.computeSInt32SizeNoTag((Integer)object);
            }
            case SINT64: {
                return CodedOutputStream.computeSInt64SizeNoTag((Long)object);
            }
            case MESSAGE: {
                if (object instanceof LazyField) {
                    return CodedOutputStream.computeLazyFieldSizeNoTag((LazyField)object);
                }
                return CodedOutputStream.computeMessageSizeNoTag((MessageLite)object);
            }
            case ENUM: {
                if (object instanceof Internal$EnumLite) {
                    return CodedOutputStream.computeEnumSizeNoTag(((Internal$EnumLite)object).getNumber());
                }
                return CodedOutputStream.computeEnumSizeNoTag((Integer)object);
            }
        }
        throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
    }

    public static int computeFieldSize(FieldSet$FieldDescriptorLite<?> fieldSet$FieldDescriptorLite, Object object) {
        WireFormat$FieldType wireFormat$FieldType = fieldSet$FieldDescriptorLite.getLiteType();
        int n = fieldSet$FieldDescriptorLite.getNumber();
        if (fieldSet$FieldDescriptorLite.isRepeated()) {
            if (fieldSet$FieldDescriptorLite.isPacked()) {
                int n2 = 0;
                for (Object e2 : (List)object) {
                    n2 += FieldSet.computeElementSizeNoTag(wireFormat$FieldType, e2);
                }
                return n2 + CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeRawVarint32Size(n2);
            }
            int n3 = 0;
            for (Object e3 : (List)object) {
                n3 += FieldSet.computeElementSize(wireFormat$FieldType, n, e3);
            }
            return n3;
        }
        return FieldSet.computeElementSize(wireFormat$FieldType, n, object);
    }
}

