/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractProtobufList;
import com.google.protobuf.Internal;
import com.google.protobuf.Internal$LongList;
import com.google.protobuf.PrimitiveNonBoxingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class LongArrayList
extends AbstractProtobufList<Long>
implements Internal$LongList,
PrimitiveNonBoxingCollection,
RandomAccess {
    private static final LongArrayList EMPTY_LIST = new LongArrayList(new long[0], 0);
    private long[] array;
    private int size;

    public static LongArrayList emptyList() {
        return EMPTY_LIST;
    }

    LongArrayList() {
        this(new long[10], 0);
    }

    private LongArrayList(long[] lArray, int n) {
        this.array = lArray;
        this.size = n;
    }

    @Override
    protected void removeRange(int n, int n2) {
        this.ensureIsMutable();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.array, n2, this.array, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LongArrayList)) {
            return super.equals(object);
        }
        LongArrayList longArrayList = (LongArrayList)object;
        if (this.size != longArrayList.size) {
            return false;
        }
        long[] lArray = longArrayList.array;
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = 31 * n + Internal.hashLong(this.array[i]);
        }
        return n;
    }

    @Override
    public Internal$LongList mutableCopyWithCapacity(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new LongArrayList(Arrays.copyOf(this.array, n), this.size);
    }

    @Override
    public Long get(int n) {
        return this.getLong(n);
    }

    @Override
    public long getLong(int n) {
        this.ensureIndexInRange(n);
        return this.array[n];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Long set(int n, Long l) {
        return this.setLong(n, l);
    }

    @Override
    public long setLong(int n, long l) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n);
        long l2 = this.array[n];
        this.array[n] = l;
        return l2;
    }

    @Override
    public void add(int n, Long l) {
        this.addLong(n, l);
    }

    @Override
    public void addLong(long l) {
        this.addLong(this.size, l);
    }

    private void addLong(int n, long l) {
        this.ensureIsMutable();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, n, this.array, n + 1, this.size - n);
        } else {
            int n2 = this.size * 3 / 2 + 1;
            long[] lArray = new long[n2];
            System.arraycopy(this.array, 0, lArray, 0, n);
            System.arraycopy(this.array, n, lArray, n + 1, this.size - n);
            this.array = lArray;
        }
        this.array[n] = l;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends Long> collection) {
        this.ensureIsMutable();
        Internal.checkNotNull(collection);
        if (!(collection instanceof LongArrayList)) {
            return super.addAll(collection);
        }
        LongArrayList longArrayList = (LongArrayList)collection;
        if (longArrayList.size == 0) {
            return false;
        }
        int n = Integer.MAX_VALUE - this.size;
        if (n < longArrayList.size) {
            throw new OutOfMemoryError();
        }
        int n2 = this.size + longArrayList.size;
        if (n2 > this.array.length) {
            this.array = Arrays.copyOf(this.array, n2);
        }
        System.arraycopy(longArrayList.array, 0, this.array, this.size, longArrayList.size);
        this.size = n2;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean remove(Object object) {
        this.ensureIsMutable();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.array[i])) continue;
            System.arraycopy(this.array, i + 1, this.array, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public Long remove(int n) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n);
        long l = this.array[n];
        if (n < this.size - 1) {
            System.arraycopy(this.array, n + 1, this.array, n, this.size - n - 1);
        }
        --this.size;
        ++this.modCount;
        return l;
    }

    private void ensureIndexInRange(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int n) {
        int n2 = n;
        int n3 = this.size;
        return new StringBuilder(35).append("Index:").append(n2).append(", Size:").append(n3).toString();
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

